package org.cloudfoundry.uaa.tokens;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the get token by authorization code operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetTokenByAuthorizationCodeRequest"})
public final class GetTokenByAuthorizationCodeRequest
    extends org.cloudfoundry.uaa.tokens._GetTokenByAuthorizationCodeRequest {
  private final String authorizationCode;
  private final String clientId;
  private final String clientSecret;
  private final @Nullable String redirectUri;
  private final @Nullable TokenFormat tokenFormat;

  private GetTokenByAuthorizationCodeRequest(GetTokenByAuthorizationCodeRequest.Builder builder) {
    this.authorizationCode = builder.authorizationCode;
    this.clientId = builder.clientId;
    this.clientSecret = builder.clientSecret;
    this.redirectUri = builder.redirectUri;
    this.tokenFormat = builder.tokenFormat;
  }

  /**
   * The authorization code
   */
  @Override
  public String getAuthorizationCode() {
    return authorizationCode;
  }

  /**
   * The client identifier
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The client's secret passphrase
   */
  @Override
  public String getClientSecret() {
    return clientSecret;
  }

  /**
   * The redirection URI
   */
  @Override
  public @Nullable String getRedirectUri() {
    return redirectUri;
  }

  /**
   * The token format
   */
  @Override
  public @Nullable TokenFormat getTokenFormat() {
    return tokenFormat;
  }

  /**
   * This instance is equal to all instances of {@code GetTokenByAuthorizationCodeRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetTokenByAuthorizationCodeRequest
        && equalTo((GetTokenByAuthorizationCodeRequest) another);
  }

  private boolean equalTo(GetTokenByAuthorizationCodeRequest another) {
    return authorizationCode.equals(another.authorizationCode)
        && clientId.equals(another.clientId)
        && clientSecret.equals(another.clientSecret)
        && Objects.equals(redirectUri, another.redirectUri)
        && Objects.equals(tokenFormat, another.tokenFormat);
  }

  /**
   * Computes a hash code from attributes: {@code authorizationCode}, {@code clientId}, {@code clientSecret}, {@code redirectUri}, {@code tokenFormat}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + authorizationCode.hashCode();
    h = h * 17 + clientId.hashCode();
    h = h * 17 + clientSecret.hashCode();
    h = h * 17 + Objects.hashCode(redirectUri);
    h = h * 17 + Objects.hashCode(tokenFormat);
    return h;
  }

  /**
   * Prints the immutable value {@code GetTokenByAuthorizationCodeRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetTokenByAuthorizationCodeRequest{"
        + "authorizationCode=" + authorizationCode
        + ", clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + ", redirectUri=" + redirectUri
        + ", tokenFormat=" + tokenFormat
        + "}";
  }

  /**
   * Creates a builder for {@link GetTokenByAuthorizationCodeRequest GetTokenByAuthorizationCodeRequest}.
   * @return A new GetTokenByAuthorizationCodeRequest builder
   */
  public static GetTokenByAuthorizationCodeRequest.Builder builder() {
    return new GetTokenByAuthorizationCodeRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetTokenByAuthorizationCodeRequest GetTokenByAuthorizationCodeRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_AUTHORIZATION_CODE = 0x1L;
    private static final long INIT_BIT_CLIENT_ID = 0x2L;
    private static final long INIT_BIT_CLIENT_SECRET = 0x4L;
    private long initBits = 0x7L;

    private String authorizationCode;
    private String clientId;
    private String clientSecret;
    private String redirectUri;
    private TokenFormat tokenFormat;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetTokenByAuthorizationCodeRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetTokenByAuthorizationCodeRequest instance) {
      return from((_GetTokenByAuthorizationCodeRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetTokenByAuthorizationCodeRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetTokenByAuthorizationCodeRequest instance) {
      Objects.requireNonNull(instance, "instance");
      authorizationCode(instance.getAuthorizationCode());
      clientId(instance.getClientId());
      clientSecret(instance.getClientSecret());
      String redirectUriValue = instance.getRedirectUri();
      if (redirectUriValue != null) {
        redirectUri(redirectUriValue);
      }
      TokenFormat tokenFormatValue = instance.getTokenFormat();
      if (tokenFormatValue != null) {
        tokenFormat(tokenFormatValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByAuthorizationCodeRequest#getAuthorizationCode() authorizationCode} attribute.
     * @param authorizationCode The value for authorizationCode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorizationCode(String authorizationCode) {
      this.authorizationCode = Objects.requireNonNull(authorizationCode, "authorizationCode");
      initBits &= ~INIT_BIT_AUTHORIZATION_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByAuthorizationCodeRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByAuthorizationCodeRequest#getClientSecret() clientSecret} attribute.
     * @param clientSecret The value for clientSecret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(String clientSecret) {
      this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
      initBits &= ~INIT_BIT_CLIENT_SECRET;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByAuthorizationCodeRequest#getRedirectUri() redirectUri} attribute.
     * @param redirectUri The value for redirectUri (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUri(@Nullable String redirectUri) {
      this.redirectUri = redirectUri;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByAuthorizationCodeRequest#getTokenFormat() tokenFormat} attribute.
     * @param tokenFormat The value for tokenFormat (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenFormat(@Nullable TokenFormat tokenFormat) {
      this.tokenFormat = tokenFormat;
      return this;
    }

    /**
     * Builds a new {@link GetTokenByAuthorizationCodeRequest GetTokenByAuthorizationCodeRequest}.
     * @return An immutable instance of GetTokenByAuthorizationCodeRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetTokenByAuthorizationCodeRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetTokenByAuthorizationCodeRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_AUTHORIZATION_CODE) != 0) attributes.add("authorizationCode");
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_CLIENT_SECRET) != 0) attributes.add("clientSecret");
      return "Cannot build GetTokenByAuthorizationCodeRequest, some of required attributes are not set " + attributes;
    }
  }
}
