package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Copy the Application operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CopyApplicationRequest"})
public final class CopyApplicationRequest
    extends org.cloudfoundry.client.v2.applications._CopyApplicationRequest {
  private final String applicationId;
  private final String sourceApplicationId;

  private CopyApplicationRequest(CopyApplicationRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.sourceApplicationId = builder.sourceApplicationId;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The source application id
   */
  @Override
  public String getSourceApplicationId() {
    return sourceApplicationId;
  }

  /**
   * This instance is equal to all instances of {@code CopyApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CopyApplicationRequest
        && equalTo((CopyApplicationRequest) another);
  }

  private boolean equalTo(CopyApplicationRequest another) {
    return applicationId.equals(another.applicationId)
        && sourceApplicationId.equals(another.sourceApplicationId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code sourceApplicationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationId.hashCode();
    h = h * 17 + sourceApplicationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CopyApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CopyApplicationRequest{"
        + "applicationId=" + applicationId
        + ", sourceApplicationId=" + sourceApplicationId
        + "}";
  }

  /**
   * Creates a builder for {@link CopyApplicationRequest CopyApplicationRequest}.
   * @return A new CopyApplicationRequest builder
   */
  public static CopyApplicationRequest.Builder builder() {
    return new CopyApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link CopyApplicationRequest CopyApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_SOURCE_APPLICATION_ID = 0x2L;
    private long initBits = 0x3L;

    private String applicationId;
    private String sourceApplicationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CopyApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CopyApplicationRequest instance) {
      return from((_CopyApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CopyApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CopyApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      sourceApplicationId(instance.getSourceApplicationId());
      return this;
    }

    /**
     * Initializes the value for the {@link _CopyApplicationRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _CopyApplicationRequest#getSourceApplicationId() sourceApplicationId} attribute.
     * @param sourceApplicationId The value for sourceApplicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceApplicationId(String sourceApplicationId) {
      this.sourceApplicationId = Objects.requireNonNull(sourceApplicationId, "sourceApplicationId");
      initBits &= ~INIT_BIT_SOURCE_APPLICATION_ID;
      return this;
    }

    /**
     * Builds a new {@link CopyApplicationRequest CopyApplicationRequest}.
     * @return An immutable instance of CopyApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CopyApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CopyApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_SOURCE_APPLICATION_ID) != 0) attributes.add("sourceApplicationId");
      return "Cannot build CopyApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
