package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload to Update a Service Instance
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateServiceInstanceRequest"})
public final class UpdateServiceInstanceRequest
    extends org.cloudfoundry.client.v2.serviceinstances._UpdateServiceInstanceRequest {
  private final @Nullable Boolean acceptsIncomplete;
  private final @Nullable String name;
  private final @Nullable Map<String, Object> parameters;
  private final String serviceInstanceId;
  private final @Nullable String servicePlanId;
  private final @Nullable List<String> tags;

  private UpdateServiceInstanceRequest(UpdateServiceInstanceRequest.Builder builder) {
    this.acceptsIncomplete = builder.acceptsIncomplete;
    this.name = builder.name;
    this.parameters = builder.parameters == null ? null : createUnmodifiableMap(false, false, builder.parameters);
    this.serviceInstanceId = builder.serviceInstanceId;
    this.servicePlanId = builder.servicePlanId;
    this.tags = builder.tags == null ? null : createUnmodifiableList(true, builder.tags);
  }

  /**
   * The accept incomplete flag
   */
  @Override
  public @Nullable Boolean getAcceptsIncomplete() {
    return acceptsIncomplete;
  }

  /**
   * The name
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * Key/value pairs of all arbitrary parameters to pass along to the service broker
   */
  @Override
  public @Nullable Map<String, Object> getParameters() {
    return parameters;
  }

  /**
   * The service instance id
   */
  @Override
  public String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * The service plan id
   */
  @Override
  public @Nullable String getServicePlanId() {
    return servicePlanId;
  }

  /**
   * A list of tags for the service instance
   */
  @Override
  public @Nullable List<String> getTags() {
    return tags;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServiceInstanceRequest
        && equalTo((UpdateServiceInstanceRequest) another);
  }

  private boolean equalTo(UpdateServiceInstanceRequest another) {
    return Objects.equals(acceptsIncomplete, another.acceptsIncomplete)
        && Objects.equals(name, another.name)
        && Objects.equals(parameters, another.parameters)
        && serviceInstanceId.equals(another.serviceInstanceId)
        && Objects.equals(servicePlanId, another.servicePlanId)
        && Objects.equals(tags, another.tags);
  }

  /**
   * Computes a hash code from attributes: {@code acceptsIncomplete}, {@code name}, {@code parameters}, {@code serviceInstanceId}, {@code servicePlanId}, {@code tags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(acceptsIncomplete);
    h = h * 17 + Objects.hashCode(name);
    h = h * 17 + Objects.hashCode(parameters);
    h = h * 17 + serviceInstanceId.hashCode();
    h = h * 17 + Objects.hashCode(servicePlanId);
    h = h * 17 + Objects.hashCode(tags);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServiceInstanceRequest{"
        + "acceptsIncomplete=" + acceptsIncomplete
        + ", name=" + name
        + ", parameters=" + parameters
        + ", serviceInstanceId=" + serviceInstanceId
        + ", servicePlanId=" + servicePlanId
        + ", tags=" + tags
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateServiceInstanceRequest UpdateServiceInstanceRequest}.
   * @return A new UpdateServiceInstanceRequest builder
   */
  public static UpdateServiceInstanceRequest.Builder builder() {
    return new UpdateServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServiceInstanceRequest UpdateServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_INSTANCE_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean acceptsIncomplete;
    private String name;
    private Map<String, Object> parameters = null;
    private String serviceInstanceId;
    private String servicePlanId;
    private List<String> tags = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServiceInstanceRequest instance) {
      return from((_UpdateServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean acceptsIncompleteValue = instance.getAcceptsIncomplete();
      if (acceptsIncompleteValue != null) {
        acceptsIncomplete(acceptsIncompleteValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Map<String, Object> parametersValue = instance.getParameters();
      if (parametersValue != null) {
        putAllParameters(parametersValue);
      }
      serviceInstanceId(instance.getServiceInstanceId());
      String servicePlanIdValue = instance.getServicePlanId();
      if (servicePlanIdValue != null) {
        servicePlanId(servicePlanIdValue);
      }
      List<String> tagsValue = instance.getTags();
      if (tagsValue != null) {
        addAllTags(tagsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateServiceInstanceRequest#getAcceptsIncomplete() acceptsIncomplete} attribute.
     * @param acceptsIncomplete The value for acceptsIncomplete (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder acceptsIncomplete(@Nullable Boolean acceptsIncomplete) {
      this.acceptsIncomplete = acceptsIncomplete;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateServiceInstanceRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateServiceInstanceRequest#getParameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(String key, Object value) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      this.parameters.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.parameters.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _UpdateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param parameters The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(@Nullable Map<String, ? extends Object> parameters) {
      if (parameters == null) {
        this.parameters = null;
        return this;
      }
      this.parameters = new LinkedHashMap<String, Object>();
      return putAllParameters(parameters);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _UpdateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted
     * @param parameters The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParameters(Map<String, ? extends Object> parameters) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.parameters.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateServiceInstanceRequest#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceId(String serviceInstanceId) {
      this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateServiceInstanceRequest#getServicePlanId() servicePlanId} attribute.
     * @param servicePlanId The value for servicePlanId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanId(@Nullable String servicePlanId) {
      this.servicePlanId = servicePlanId;
      return this;
    }

    /**
     * Adds one element to {@link _UpdateServiceInstanceRequest#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String element) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link _UpdateServiceInstanceRequest#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String... elements) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UpdateServiceInstanceRequest#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.tags = null;
        return this;
      }
      this.tags = new ArrayList<String>();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link _UpdateServiceInstanceRequest#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      Objects.requireNonNull(elements, "tags element");
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Builds a new {@link UpdateServiceInstanceRequest UpdateServiceInstanceRequest}.
     * @return An immutable instance of UpdateServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_ID) != 0) attributes.add("serviceInstanceId");
      return "Cannot build UpdateServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
