package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Disassociate Manager with the Space by Username operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RemoveSpaceManagerByUsernameRequest"})
public final class RemoveSpaceManagerByUsernameRequest
    extends org.cloudfoundry.client.v2.spaces._RemoveSpaceManagerByUsernameRequest {
  private final String spaceId;
  private final String username;

  private RemoveSpaceManagerByUsernameRequest(RemoveSpaceManagerByUsernameRequest.Builder builder) {
    this.spaceId = builder.spaceId;
    this.username = builder.username;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * The username
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code RemoveSpaceManagerByUsernameRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveSpaceManagerByUsernameRequest
        && equalTo((RemoveSpaceManagerByUsernameRequest) another);
  }

  private boolean equalTo(RemoveSpaceManagerByUsernameRequest another) {
    return spaceId.equals(another.spaceId)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code spaceId}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + spaceId.hashCode();
    h = h * 17 + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveSpaceManagerByUsernameRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveSpaceManagerByUsernameRequest{"
        + "spaceId=" + spaceId
        + ", username=" + username
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveSpaceManagerByUsernameRequest RemoveSpaceManagerByUsernameRequest}.
   * @return A new RemoveSpaceManagerByUsernameRequest builder
   */
  public static RemoveSpaceManagerByUsernameRequest.Builder builder() {
    return new RemoveSpaceManagerByUsernameRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveSpaceManagerByUsernameRequest RemoveSpaceManagerByUsernameRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private static final long INIT_BIT_USERNAME = 0x2L;
    private long initBits = 0x3L;

    private String spaceId;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveSpaceManagerByUsernameRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveSpaceManagerByUsernameRequest instance) {
      return from((_RemoveSpaceManagerByUsernameRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveSpaceManagerByUsernameRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveSpaceManagerByUsernameRequest instance) {
      Objects.requireNonNull(instance, "instance");
      spaceId(instance.getSpaceId());
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveSpaceManagerByUsernameRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveSpaceManagerByUsernameRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link RemoveSpaceManagerByUsernameRequest RemoveSpaceManagerByUsernameRequest}.
     * @return An immutable instance of RemoveSpaceManagerByUsernameRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveSpaceManagerByUsernameRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveSpaceManagerByUsernameRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build RemoveSpaceManagerByUsernameRequest, some of required attributes are not set " + attributes;
    }
  }
}
