package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Update a Space operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateSpaceRequest"})
public final class UpdateSpaceRequest extends org.cloudfoundry.client.v2.spaces._UpdateSpaceRequest {
  private final @Nullable Boolean allowSsh;
  private final @Nullable List<String> auditorIds;
  private final @Nullable List<String> developerIds;
  private final @Nullable List<String> domainIds;
  private final @Nullable List<String> managerIds;
  private final @Nullable String name;
  private final @Nullable String organizationId;
  private final @Nullable List<String> securityGroupIds;
  private final String spaceId;

  private UpdateSpaceRequest(UpdateSpaceRequest.Builder builder) {
    this.allowSsh = builder.allowSsh;
    this.auditorIds = builder.auditorIds == null ? null : createUnmodifiableList(true, builder.auditorIds);
    this.developerIds = builder.developerIds == null ? null : createUnmodifiableList(true, builder.developerIds);
    this.domainIds = builder.domainIds == null ? null : createUnmodifiableList(true, builder.domainIds);
    this.managerIds = builder.managerIds == null ? null : createUnmodifiableList(true, builder.managerIds);
    this.name = builder.name;
    this.organizationId = builder.organizationId;
    this.securityGroupIds = builder.securityGroupIds == null ? null : createUnmodifiableList(true, builder.securityGroupIds);
    this.spaceId = builder.spaceId;
  }

  /**
   * Allow SSH
   */
  @Override
  public @Nullable Boolean getAllowSsh() {
    return allowSsh;
  }

  /**
   * The auditor ids
   */
  @Override
  public @Nullable List<String> getAuditorIds() {
    return auditorIds;
  }

  /**
   * The developer ids
   */
  @Override
  public @Nullable List<String> getDeveloperIds() {
    return developerIds;
  }

  /**
   * The domain ids
   */
  @Override
  public @Nullable List<String> getDomainIds() {
    return domainIds;
  }

  /**
   * The manager ids
   */
  @Override
  public @Nullable List<String> getManagerIds() {
    return managerIds;
  }

  /**
   * The name
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The organization id
   */
  @Override
  public @Nullable String getOrganizationId() {
    return organizationId;
  }

  /**
   * The security group ids
   */
  @Override
  public @Nullable List<String> getSecurityGroupIds() {
    return securityGroupIds;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateSpaceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateSpaceRequest
        && equalTo((UpdateSpaceRequest) another);
  }

  private boolean equalTo(UpdateSpaceRequest another) {
    return Objects.equals(allowSsh, another.allowSsh)
        && Objects.equals(auditorIds, another.auditorIds)
        && Objects.equals(developerIds, another.developerIds)
        && Objects.equals(domainIds, another.domainIds)
        && Objects.equals(managerIds, another.managerIds)
        && Objects.equals(name, another.name)
        && Objects.equals(organizationId, another.organizationId)
        && Objects.equals(securityGroupIds, another.securityGroupIds)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code allowSsh}, {@code auditorIds}, {@code developerIds}, {@code domainIds}, {@code managerIds}, {@code name}, {@code organizationId}, {@code securityGroupIds}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(allowSsh);
    h = h * 17 + Objects.hashCode(auditorIds);
    h = h * 17 + Objects.hashCode(developerIds);
    h = h * 17 + Objects.hashCode(domainIds);
    h = h * 17 + Objects.hashCode(managerIds);
    h = h * 17 + Objects.hashCode(name);
    h = h * 17 + Objects.hashCode(organizationId);
    h = h * 17 + Objects.hashCode(securityGroupIds);
    h = h * 17 + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateSpaceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateSpaceRequest{"
        + "allowSsh=" + allowSsh
        + ", auditorIds=" + auditorIds
        + ", developerIds=" + developerIds
        + ", domainIds=" + domainIds
        + ", managerIds=" + managerIds
        + ", name=" + name
        + ", organizationId=" + organizationId
        + ", securityGroupIds=" + securityGroupIds
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateSpaceRequest UpdateSpaceRequest}.
   * @return A new UpdateSpaceRequest builder
   */
  public static UpdateSpaceRequest.Builder builder() {
    return new UpdateSpaceRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateSpaceRequest UpdateSpaceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean allowSsh;
    private List<String> auditorIds = null;
    private List<String> developerIds = null;
    private List<String> domainIds = null;
    private List<String> managerIds = null;
    private String name;
    private String organizationId;
    private List<String> securityGroupIds = null;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateSpaceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateSpaceRequest instance) {
      return from((_UpdateSpaceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateSpaceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateSpaceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean allowSshValue = instance.getAllowSsh();
      if (allowSshValue != null) {
        allowSsh(allowSshValue);
      }
      List<String> auditorIdsValue = instance.getAuditorIds();
      if (auditorIdsValue != null) {
        addAllAuditorIds(auditorIdsValue);
      }
      List<String> developerIdsValue = instance.getDeveloperIds();
      if (developerIdsValue != null) {
        addAllDeveloperIds(developerIdsValue);
      }
      List<String> domainIdsValue = instance.getDomainIds();
      if (domainIdsValue != null) {
        addAllDomainIds(domainIdsValue);
      }
      List<String> managerIdsValue = instance.getManagerIds();
      if (managerIdsValue != null) {
        addAllManagerIds(managerIdsValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String organizationIdValue = instance.getOrganizationId();
      if (organizationIdValue != null) {
        organizationId(organizationIdValue);
      }
      List<String> securityGroupIdsValue = instance.getSecurityGroupIds();
      if (securityGroupIdsValue != null) {
        addAllSecurityGroupIds(securityGroupIdsValue);
      }
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateSpaceRequest#getAllowSsh() allowSsh} attribute.
     * @param allowSsh The value for allowSsh (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowSsh(@Nullable Boolean allowSsh) {
      this.allowSsh = allowSsh;
      return this;
    }

    /**
     * Adds one element to {@link _UpdateSpaceRequest#getAuditorIds() auditorIds} list.
     * @param element A auditorIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorId(String element) {
      if (this.auditorIds == null) {
        this.auditorIds = new ArrayList<String>();
      }
      this.auditorIds.add(Objects.requireNonNull(element, "auditorIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _UpdateSpaceRequest#getAuditorIds() auditorIds} list.
     * @param elements An array of auditorIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorId(String... elements) {
      if (this.auditorIds == null) {
        this.auditorIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditorIds.add(Objects.requireNonNull(element, "auditorIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UpdateSpaceRequest#getAuditorIds() auditorIds} list.
     * @param elements An iterable of auditorIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.auditorIds = null;
        return this;
      }
      this.auditorIds = new ArrayList<String>();
      return addAllAuditorIds(elements);
    }

    /**
     * Adds elements to {@link _UpdateSpaceRequest#getAuditorIds() auditorIds} list.
     * @param elements An iterable of auditorIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuditorIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "auditorIds element");
      if (this.auditorIds == null) {
        this.auditorIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditorIds.add(Objects.requireNonNull(element, "auditorIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _UpdateSpaceRequest#getDeveloperIds() developerIds} list.
     * @param element A developerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerId(String element) {
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _UpdateSpaceRequest#getDeveloperIds() developerIds} list.
     * @param elements An array of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerId(String... elements) {
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UpdateSpaceRequest#getDeveloperIds() developerIds} list.
     * @param elements An iterable of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.developerIds = null;
        return this;
      }
      this.developerIds = new ArrayList<String>();
      return addAllDeveloperIds(elements);
    }

    /**
     * Adds elements to {@link _UpdateSpaceRequest#getDeveloperIds() developerIds} list.
     * @param elements An iterable of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDeveloperIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "developerIds element");
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _UpdateSpaceRequest#getDomainIds() domainIds} list.
     * @param element A domainIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String element) {
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _UpdateSpaceRequest#getDomainIds() domainIds} list.
     * @param elements An array of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String... elements) {
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UpdateSpaceRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.domainIds = null;
        return this;
      }
      this.domainIds = new ArrayList<String>();
      return addAllDomainIds(elements);
    }

    /**
     * Adds elements to {@link _UpdateSpaceRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomainIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "domainIds element");
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _UpdateSpaceRequest#getManagerIds() managerIds} list.
     * @param element A managerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerId(String element) {
      if (this.managerIds == null) {
        this.managerIds = new ArrayList<String>();
      }
      this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _UpdateSpaceRequest#getManagerIds() managerIds} list.
     * @param elements An array of managerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerId(String... elements) {
      if (this.managerIds == null) {
        this.managerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UpdateSpaceRequest#getManagerIds() managerIds} list.
     * @param elements An iterable of managerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.managerIds = null;
        return this;
      }
      this.managerIds = new ArrayList<String>();
      return addAllManagerIds(elements);
    }

    /**
     * Adds elements to {@link _UpdateSpaceRequest#getManagerIds() managerIds} list.
     * @param elements An iterable of managerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllManagerIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "managerIds element");
      if (this.managerIds == null) {
        this.managerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateSpaceRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateSpaceRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
      return this;
    }

    /**
     * Adds one element to {@link _UpdateSpaceRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param element A securityGroupIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String element) {
      if (this.securityGroupIds == null) {
        this.securityGroupIds = new ArrayList<String>();
      }
      this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _UpdateSpaceRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An array of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String... elements) {
      if (this.securityGroupIds == null) {
        this.securityGroupIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UpdateSpaceRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An iterable of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.securityGroupIds = null;
        return this;
      }
      this.securityGroupIds = new ArrayList<String>();
      return addAllSecurityGroupIds(elements);
    }

    /**
     * Adds elements to {@link _UpdateSpaceRequest#getSecurityGroupIds() securityGroupIds} list.
     * @param elements An iterable of securityGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSecurityGroupIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "securityGroupIds element");
      if (this.securityGroupIds == null) {
        this.securityGroupIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.securityGroupIds.add(Objects.requireNonNull(element, "securityGroupIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateSpaceRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateSpaceRequest UpdateSpaceRequest}.
     * @return An immutable instance of UpdateSpaceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateSpaceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateSpaceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build UpdateSpaceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
