package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get User Summary operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_SummaryUserRequest"})
public final class SummaryUserRequest extends org.cloudfoundry.client.v2.users._SummaryUserRequest {
  private final String userId;

  private SummaryUserRequest(SummaryUserRequest.Builder builder) {
    this.userId = builder.userId;
  }

  /**
   * The ID of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code SummaryUserRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SummaryUserRequest
        && equalTo((SummaryUserRequest) another);
  }

  private boolean equalTo(SummaryUserRequest another) {
    return userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SummaryUserRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SummaryUserRequest{"
        + "userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link SummaryUserRequest SummaryUserRequest}.
   * @return A new SummaryUserRequest builder
   */
  public static SummaryUserRequest.Builder builder() {
    return new SummaryUserRequest.Builder();
  }

  /**
   * Builds instances of type {@link SummaryUserRequest SummaryUserRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private long initBits = 0x1L;

    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SummaryUserRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SummaryUserRequest instance) {
      return from((_SummaryUserRequest) instance);
    }

    /**
     * Copy abstract value type {@code _SummaryUserRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SummaryUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link _SummaryUserRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link SummaryUserRequest SummaryUserRequest}.
     * @return An immutable instance of SummaryUserRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SummaryUserRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SummaryUserRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build SummaryUserRequest, some of required attributes are not set " + attributes;
    }
  }
}
