package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Update a User operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateUserRequest"})
public final class UpdateUserRequest extends org.cloudfoundry.client.v2.users._UpdateUserRequest {
  private final @Nullable String defaultSpaceId;
  private final String userId;

  private UpdateUserRequest(UpdateUserRequest.Builder builder) {
    this.defaultSpaceId = builder.defaultSpaceId;
    this.userId = builder.userId;
  }

  /**
   * The id of the default space for apps created by this user
   */
  @Override
  public @Nullable String getDefaultSpaceId() {
    return defaultSpaceId;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateUserRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateUserRequest
        && equalTo((UpdateUserRequest) another);
  }

  private boolean equalTo(UpdateUserRequest another) {
    return Objects.equals(defaultSpaceId, another.defaultSpaceId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code defaultSpaceId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(defaultSpaceId);
    h = h * 17 + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateUserRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateUserRequest{"
        + "defaultSpaceId=" + defaultSpaceId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateUserRequest UpdateUserRequest}.
   * @return A new UpdateUserRequest builder
   */
  public static UpdateUserRequest.Builder builder() {
    return new UpdateUserRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateUserRequest UpdateUserRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private long initBits = 0x1L;

    private String defaultSpaceId;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateUserRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateUserRequest instance) {
      return from((_UpdateUserRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateUserRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String defaultSpaceIdValue = instance.getDefaultSpaceId();
      if (defaultSpaceIdValue != null) {
        defaultSpaceId(defaultSpaceIdValue);
      }
      userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateUserRequest#getDefaultSpaceId() defaultSpaceId} attribute.
     * @param defaultSpaceId The value for defaultSpaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder defaultSpaceId(@Nullable String defaultSpaceId) {
      this.defaultSpaceId = defaultSpaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateUserRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateUserRequest UpdateUserRequest}.
     * @return An immutable instance of UpdateUserRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateUserRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateUserRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build UpdateUserRequest, some of required attributes are not set " + attributes;
    }
  }
}
