package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedAndSortedRequest;
import org.cloudfoundry.client.v3.PaginatedRequest;

/**
 * The request payload for the List Application Droplets operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListApplicationDropletsRequest"})
public final class ListApplicationDropletsRequest
    extends org.cloudfoundry.client.v3.applications._ListApplicationDropletsRequest {
  private final String applicationId;
  private final List<String> states;
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;

  private ListApplicationDropletsRequest(ListApplicationDropletsRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.states = createUnmodifiableList(true, builder.states);
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The states
   */
  @Override
  public List<String> getStates() {
    return states;
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * This instance is equal to all instances of {@code ListApplicationDropletsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListApplicationDropletsRequest
        && equalTo((ListApplicationDropletsRequest) another);
  }

  private boolean equalTo(ListApplicationDropletsRequest another) {
    return applicationId.equals(another.applicationId)
        && states.equals(another.states)
        && Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code states}, {@code orderBy}, {@code page}, {@code perPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationId.hashCode();
    h = h * 17 + states.hashCode();
    h = h * 17 + Objects.hashCode(orderBy);
    h = h * 17 + Objects.hashCode(page);
    h = h * 17 + Objects.hashCode(perPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListApplicationDropletsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListApplicationDropletsRequest{"
        + "applicationId=" + applicationId
        + ", states=" + states
        + ", orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListApplicationDropletsRequest ListApplicationDropletsRequest}.
   * @return A new ListApplicationDropletsRequest builder
   */
  public static ListApplicationDropletsRequest.Builder builder() {
    return new ListApplicationDropletsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListApplicationDropletsRequest ListApplicationDropletsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;
    private List<String> states = new ArrayList<String>();
    private String orderBy;
    private Integer page;
    private Integer perPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListApplicationDropletsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListApplicationDropletsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListApplicationDropletsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListApplicationDropletsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedAndSortedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedAndSortedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.applications._ListApplicationDropletsRequest) {
        org.cloudfoundry.client.v3.applications._ListApplicationDropletsRequest instance = (org.cloudfoundry.client.v3.applications._ListApplicationDropletsRequest) object;
        applicationId(instance.getApplicationId());
        addAllStates(instance.getStates());
      }
      if (object instanceof PaginatedAndSortedRequest) {
        PaginatedAndSortedRequest instance = (PaginatedAndSortedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _ListApplicationDropletsRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Adds one element to {@link _ListApplicationDropletsRequest#getStates() states} list.
     * @param element A states element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(String element) {
      this.states.add(Objects.requireNonNull(element, "states element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListApplicationDropletsRequest#getStates() states} list.
     * @param elements An array of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(String... elements) {
      for (String element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListApplicationDropletsRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(Iterable<String> elements) {
      this.states.clear();
      return addAllStates(elements);
    }

    /**
     * Adds elements to {@link _ListApplicationDropletsRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStates(Iterable<String> elements) {
      for (String element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListApplicationDropletsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListApplicationDropletsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListApplicationDropletsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Builds a new {@link ListApplicationDropletsRequest ListApplicationDropletsRequest}.
     * @return An immutable instance of ListApplicationDropletsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListApplicationDropletsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListApplicationDropletsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build ListApplicationDropletsRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
