package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedAndSortedRequest;
import org.cloudfoundry.client.v3.PaginatedRequest;

/**
 * The request payload for the List Applications operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListApplicationsRequest"})
public final class ListApplicationsRequest
    extends org.cloudfoundry.client.v3.applications._ListApplicationsRequest {
  private final List<String> ids;
  private final List<String> names;
  private final List<String> organizationIds;
  private final List<String> spaceIds;
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;

  private ListApplicationsRequest(ListApplicationsRequest.Builder builder) {
    this.ids = createUnmodifiableList(true, builder.ids);
    this.names = createUnmodifiableList(true, builder.names);
    this.organizationIds = createUnmodifiableList(true, builder.organizationIds);
    this.spaceIds = createUnmodifiableList(true, builder.spaceIds);
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
  }

  /**
   * The ids
   */
  @Override
  public List<String> getIds() {
    return ids;
  }

  /**
   * The names
   */
  @Override
  public List<String> getNames() {
    return names;
  }

  /**
   * The organization ids
   */
  @Override
  public List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The space ids
   */
  @Override
  public List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * This instance is equal to all instances of {@code ListApplicationsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListApplicationsRequest
        && equalTo((ListApplicationsRequest) another);
  }

  private boolean equalTo(ListApplicationsRequest another) {
    return ids.equals(another.ids)
        && names.equals(another.names)
        && organizationIds.equals(another.organizationIds)
        && spaceIds.equals(another.spaceIds)
        && Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage);
  }

  /**
   * Computes a hash code from attributes: {@code ids}, {@code names}, {@code organizationIds}, {@code spaceIds}, {@code orderBy}, {@code page}, {@code perPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + ids.hashCode();
    h = h * 17 + names.hashCode();
    h = h * 17 + organizationIds.hashCode();
    h = h * 17 + spaceIds.hashCode();
    h = h * 17 + Objects.hashCode(orderBy);
    h = h * 17 + Objects.hashCode(page);
    h = h * 17 + Objects.hashCode(perPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListApplicationsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListApplicationsRequest{"
        + "ids=" + ids
        + ", names=" + names
        + ", organizationIds=" + organizationIds
        + ", spaceIds=" + spaceIds
        + ", orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListApplicationsRequest ListApplicationsRequest}.
   * @return A new ListApplicationsRequest builder
   */
  public static ListApplicationsRequest.Builder builder() {
    return new ListApplicationsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListApplicationsRequest ListApplicationsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<String> ids = new ArrayList<String>();
    private List<String> names = new ArrayList<String>();
    private List<String> organizationIds = new ArrayList<String>();
    private List<String> spaceIds = new ArrayList<String>();
    private String orderBy;
    private Integer page;
    private Integer perPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListApplicationsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListApplicationsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListApplicationsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListApplicationsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedAndSortedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedAndSortedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.applications._ListApplicationsRequest) {
        org.cloudfoundry.client.v3.applications._ListApplicationsRequest instance = (org.cloudfoundry.client.v3.applications._ListApplicationsRequest) object;
        addAllIds(instance.getIds());
        addAllNames(instance.getNames());
        addAllSpaceIds(instance.getSpaceIds());
        addAllOrganizationIds(instance.getOrganizationIds());
      }
      if (object instanceof PaginatedAndSortedRequest) {
        PaginatedAndSortedRequest instance = (PaginatedAndSortedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
      }
    }

    /**
     * Adds one element to {@link _ListApplicationsRequest#getIds() ids} list.
     * @param element A ids element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String element) {
      this.ids.add(Objects.requireNonNull(element, "ids element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListApplicationsRequest#getIds() ids} list.
     * @param elements An array of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String... elements) {
      for (String element : elements) {
        this.ids.add(Objects.requireNonNull(element, "ids element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListApplicationsRequest#getIds() ids} list.
     * @param elements An iterable of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ids(Iterable<String> elements) {
      this.ids.clear();
      return addAllIds(elements);
    }

    /**
     * Adds elements to {@link _ListApplicationsRequest#getIds() ids} list.
     * @param elements An iterable of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIds(Iterable<String> elements) {
      for (String element : elements) {
        this.ids.add(Objects.requireNonNull(element, "ids element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListApplicationsRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListApplicationsRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String... elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListApplicationsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(Iterable<String> elements) {
      this.names.clear();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link _ListApplicationsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListApplicationsRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListApplicationsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String... elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListApplicationsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(Iterable<String> elements) {
      this.organizationIds.clear();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link _ListApplicationsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListApplicationsRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListApplicationsRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String... elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListApplicationsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(Iterable<String> elements) {
      this.spaceIds.clear();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link _ListApplicationsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListApplicationsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListApplicationsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListApplicationsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Builds a new {@link ListApplicationsRequest ListApplicationsRequest}.
     * @return An immutable instance of ListApplicationsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListApplicationsRequest build() {
      return new ListApplicationsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
