package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _Data}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Data.builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Data"})
public final class Data extends org.cloudfoundry.client.v3.processes._Data {
  private final @Nullable Integer timeout;

  private Data(Data.Builder builder) {
    this.timeout = builder.timeout;
  }

  /**
   * The timeout
   */
  @JsonProperty("timeout")
  @Override
  public @Nullable Integer getTimeout() {
    return timeout;
  }

  /**
   * This instance is equal to all instances of {@code Data} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Data
        && equalTo((Data) another);
  }

  private boolean equalTo(Data another) {
    return Objects.equals(timeout, another.timeout);
  }

  /**
   * Computes a hash code from attributes: {@code timeout}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(timeout);
    return h;
  }

  /**
   * Prints the immutable value {@code Data} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Data{"
        + "timeout=" + timeout
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.processes._Data {
    Integer timeout;
    @JsonProperty("timeout")
    public void setTimeout(@Nullable Integer timeout) {
      this.timeout = timeout;
    }
    @Override
    public Integer getTimeout() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Data fromJson(Json json) {
    Data.Builder builder = Data.builder();
    if (json.timeout != null) {
      builder.timeout(json.timeout);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Data Data}.
   * @return A new Data builder
   */
  public static Data.Builder builder() {
    return new Data.Builder();
  }

  /**
   * Builds instances of type {@link Data Data}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Integer timeout;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Data} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Data instance) {
      return from((_Data) instance);
    }

    /**
     * Copy abstract value type {@code _Data} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Data instance) {
      Objects.requireNonNull(instance, "instance");
      Integer timeoutValue = instance.getTimeout();
      if (timeoutValue != null) {
        timeout(timeoutValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Data#getTimeout() timeout} attribute.
     * @param timeout The value for timeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("timeout")
    public final Builder timeout(@Nullable Integer timeout) {
      this.timeout = timeout;
      return this;
    }

    /**
     * Builds a new {@link Data Data}.
     * @return An immutable instance of Data
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Data build() {
      return new Data(this);
    }
  }
}
