package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;

/**
 * The response payload from the check a membership of a group request
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CheckMembershipResponse"})
public final class CheckMembershipResponse extends org.cloudfoundry.uaa.groups._CheckMembershipResponse {
  private final String memberId;
  private final String origin;
  private final MemberType type;

  private CheckMembershipResponse(CheckMembershipResponse.Builder builder) {
    this.memberId = builder.memberId;
    this.origin = builder.origin;
    this.type = builder.type;
  }

  /**
   * Globally unique identifier of the member, either a user ID or another group ID
   */
  @JsonProperty("value")
  @Override
  public String getMemberId() {
    return memberId;
  }

  /**
   * The alias of the identity provider that authenticated this user. "uaa" is an internal UAA user.
   */
  @JsonProperty("origin")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public Optional<String> getOrigin() {
    return Optional.ofNullable(origin);
  }

  /**
   * The member type
   */
  @JsonProperty("type")
  @Override
  public Optional<MemberType> getType() {
    return Optional.ofNullable(type);
  }

  /**
   * This instance is equal to all instances of {@code CheckMembershipResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CheckMembershipResponse
        && equalTo((CheckMembershipResponse) another);
  }

  private boolean equalTo(CheckMembershipResponse another) {
    return memberId.equals(another.memberId)
        && Objects.equals(origin, another.origin)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code memberId}, {@code origin}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + memberId.hashCode();
    h = h * 17 + Objects.hashCode(origin);
    h = h * 17 + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code CheckMembershipResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("CheckMembershipResponse{");
    builder.append("memberId=").append(memberId);
    if (origin != null) {
      builder.append(", ");
      builder.append("origin=").append(origin);
    }
    if (type != null) {
      builder.append(", ");
      builder.append("type=").append(type);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.groups._CheckMembershipResponse {
    String memberId;
    Optional<String> origin = Optional.empty();
    Optional<MemberType> type = Optional.empty();
    @JsonProperty("value")
    public void setMemberId(String memberId) {
      this.memberId = memberId;
    }
    @JsonProperty("origin")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setOrigin(Optional<String> origin) {
      this.origin = origin;
    }
    @JsonProperty("type")
    public void setType(Optional<MemberType> type) {
      this.type = type;
    }
    @Override
    public String getMemberId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<MemberType> getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CheckMembershipResponse fromJson(Json json) {
    CheckMembershipResponse.Builder builder = CheckMembershipResponse.builder();
    if (json.memberId != null) {
      builder.memberId(json.memberId);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CheckMembershipResponse CheckMembershipResponse}.
   * @return A new CheckMembershipResponse builder
   */
  public static CheckMembershipResponse.Builder builder() {
    return new CheckMembershipResponse.Builder();
  }

  /**
   * Builds instances of type {@link CheckMembershipResponse CheckMembershipResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_MEMBER_ID = 0x1L;
    private long initBits = 0x1L;

    private String memberId;
    private String origin;
    private MemberType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.groups.AbstractMember} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractMember instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckMembershipResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CheckMembershipResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _CheckMembershipResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CheckMembershipResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractMember) {
        AbstractMember instance = (AbstractMember) object;
        Optional<MemberType> typeOptional = instance.getType();
        if (typeOptional.isPresent()) {
          type(typeOptional);
        }
        Optional<String> originOptional = instance.getOrigin();
        if (originOptional.isPresent()) {
          origin(originOptional);
        }
        memberId(instance.getMemberId());
      }
    }

    /**
     * Initializes the value for the {@link _CheckMembershipResponse#getMemberId() memberId} attribute.
     * @param memberId The value for memberId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder memberId(String memberId) {
      this.memberId = Objects.requireNonNull(memberId, "memberId");
      initBits &= ~INIT_BIT_MEMBER_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link _CheckMembershipResponse#getOrigin() origin} to origin.
     * @param origin The value for origin
     * @return {@code this} builder for chained invocation
     */
    public final Builder origin(String origin) {
      this.origin = Objects.requireNonNull(origin, "origin");
      return this;
    }

    /**
     * Initializes the optional value {@link _CheckMembershipResponse#getOrigin() origin} to origin.
     * @param origin The value for origin
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("origin")
    public final Builder origin(Optional<String> origin) {
      this.origin = origin.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link _CheckMembershipResponse#getType() type} to type.
     * @param type The value for type
     * @return {@code this} builder for chained invocation
     */
    public final Builder type(MemberType type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Initializes the optional value {@link _CheckMembershipResponse#getType() type} to type.
     * @param type The value for type
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(Optional<MemberType> type) {
      this.type = type.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link CheckMembershipResponse CheckMembershipResponse}.
     * @return An immutable instance of CheckMembershipResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CheckMembershipResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CheckMembershipResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_MEMBER_ID) != 0) attributes.add("memberId");
      return "Cannot build CheckMembershipResponse, some of required attributes are not set " + attributes;
    }
  }
}
