package org.cloudfoundry.uaa.tokens;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The response from the get token key request
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetTokenKeyResponse"})
public final class GetTokenKeyResponse extends org.cloudfoundry.uaa.tokens._GetTokenKeyResponse {
  private final String algorithm;
  private final String e;
  private final @Nullable String id;
  private final KeyType keyType;
  private final String n;
  private final String use;
  private final String value;

  private GetTokenKeyResponse(GetTokenKeyResponse.Builder builder) {
    this.algorithm = builder.algorithm;
    this.e = builder.e;
    this.id = builder.id;
    this.keyType = builder.keyType;
    this.n = builder.n;
    this.use = builder.use;
    this.value = builder.value;
  }

  /**
   * The algorithm
   */
  @JsonProperty("alg")
  @Override
  public String getAlgorithm() {
    return algorithm;
  }

  /**
   * The exponent
   */
  @JsonProperty("e")
  @Override
  public String getE() {
    return e;
  }

  /**
   * The id
   */
  @JsonProperty("kid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The key type
   */
  @JsonProperty("kty")
  @Override
  public KeyType getKeyType() {
    return keyType;
  }

  /**
   * The modulus
   */
  @JsonProperty("n")
  @Override
  public String getN() {
    return n;
  }

  /**
   * The use
   */
  @JsonProperty("use")
  @Override
  public String getUse() {
    return use;
  }

  /**
   * The value
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code GetTokenKeyResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetTokenKeyResponse
        && equalTo((GetTokenKeyResponse) another);
  }

  private boolean equalTo(GetTokenKeyResponse another) {
    return algorithm.equals(another.algorithm)
        && e.equals(another.e)
        && Objects.equals(id, another.id)
        && keyType.equals(another.keyType)
        && n.equals(another.n)
        && use.equals(another.use)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code algorithm}, {@code e}, {@code id}, {@code keyType}, {@code n}, {@code use}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + algorithm.hashCode();
    h = h * 17 + e.hashCode();
    h = h * 17 + Objects.hashCode(id);
    h = h * 17 + keyType.hashCode();
    h = h * 17 + n.hashCode();
    h = h * 17 + use.hashCode();
    h = h * 17 + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetTokenKeyResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetTokenKeyResponse{"
        + "algorithm=" + algorithm
        + ", e=" + e
        + ", id=" + id
        + ", keyType=" + keyType
        + ", n=" + n
        + ", use=" + use
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.tokens._GetTokenKeyResponse {
    String algorithm;
    String e;
    String id;
    KeyType keyType;
    String n;
    String use;
    String value;
    @JsonProperty("alg")
    public void setAlgorithm(String algorithm) {
      this.algorithm = algorithm;
    }
    @JsonProperty("e")
    public void setE(String e) {
      this.e = e;
    }
    @JsonProperty("kid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("kty")
    public void setKeyType(KeyType keyType) {
      this.keyType = keyType;
    }
    @JsonProperty("n")
    public void setN(String n) {
      this.n = n;
    }
    @JsonProperty("use")
    public void setUse(String use) {
      this.use = use;
    }
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @Override
    public String getAlgorithm() { throw new UnsupportedOperationException(); }
    @Override
    public String getE() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public KeyType getKeyType() { throw new UnsupportedOperationException(); }
    @Override
    public String getN() { throw new UnsupportedOperationException(); }
    @Override
    public String getUse() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetTokenKeyResponse fromJson(Json json) {
    GetTokenKeyResponse.Builder builder = GetTokenKeyResponse.builder();
    if (json.algorithm != null) {
      builder.algorithm(json.algorithm);
    }
    if (json.e != null) {
      builder.e(json.e);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.keyType != null) {
      builder.keyType(json.keyType);
    }
    if (json.n != null) {
      builder.n(json.n);
    }
    if (json.use != null) {
      builder.use(json.use);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetTokenKeyResponse GetTokenKeyResponse}.
   * @return A new GetTokenKeyResponse builder
   */
  public static GetTokenKeyResponse.Builder builder() {
    return new GetTokenKeyResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetTokenKeyResponse GetTokenKeyResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ALGORITHM = 0x1L;
    private static final long INIT_BIT_E = 0x2L;
    private static final long INIT_BIT_KEY_TYPE = 0x4L;
    private static final long INIT_BIT_N = 0x8L;
    private static final long INIT_BIT_USE = 0x10L;
    private static final long INIT_BIT_VALUE = 0x20L;
    private long initBits = 0x3fL;

    private String algorithm;
    private String e;
    private String id;
    private KeyType keyType;
    private String n;
    private String use;
    private String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.tokens.AbstractTokenKey} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractTokenKey instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetTokenKeyResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetTokenKeyResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetTokenKeyResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetTokenKeyResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractTokenKey) {
        AbstractTokenKey instance = (AbstractTokenKey) object;
        e(instance.getE());
        use(instance.getUse());
        String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
        keyType(instance.getKeyType());
        value(instance.getValue());
        n(instance.getN());
        algorithm(instance.getAlgorithm());
      }
    }

    /**
     * Initializes the value for the {@link _GetTokenKeyResponse#getAlgorithm() algorithm} attribute.
     * @param algorithm The value for algorithm 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("alg")
    public final Builder algorithm(String algorithm) {
      this.algorithm = Objects.requireNonNull(algorithm, "algorithm");
      initBits &= ~INIT_BIT_ALGORITHM;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenKeyResponse#getE() e} attribute.
     * @param e The value for e 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("e")
    public final Builder e(String e) {
      this.e = Objects.requireNonNull(e, "e");
      initBits &= ~INIT_BIT_E;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenKeyResponse#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("kid")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenKeyResponse#getKeyType() keyType} attribute.
     * @param keyType The value for keyType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("kty")
    public final Builder keyType(KeyType keyType) {
      this.keyType = Objects.requireNonNull(keyType, "keyType");
      initBits &= ~INIT_BIT_KEY_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenKeyResponse#getN() n} attribute.
     * @param n The value for n 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("n")
    public final Builder n(String n) {
      this.n = Objects.requireNonNull(n, "n");
      initBits &= ~INIT_BIT_N;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenKeyResponse#getUse() use} attribute.
     * @param use The value for use 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("use")
    public final Builder use(String use) {
      this.use = Objects.requireNonNull(use, "use");
      initBits &= ~INIT_BIT_USE;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenKeyResponse#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link GetTokenKeyResponse GetTokenKeyResponse}.
     * @return An immutable instance of GetTokenKeyResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetTokenKeyResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetTokenKeyResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ALGORITHM) != 0) attributes.add("algorithm");
      if ((initBits & INIT_BIT_E) != 0) attributes.add("e");
      if ((initBits & INIT_BIT_KEY_TYPE) != 0) attributes.add("keyType");
      if ((initBits & INIT_BIT_N) != 0) attributes.add("n");
      if ((initBits & INIT_BIT_USE) != 0) attributes.add("use");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build GetTokenKeyResponse, some of required attributes are not set " + attributes;
    }
  }
}
