package org.cloudfoundry.uaa.tokens;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the refresh token operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RefreshTokenRequest"})
public final class RefreshTokenRequest extends org.cloudfoundry.uaa.tokens._RefreshTokenRequest {
  private final String clientId;
  private final String clientSecret;
  private final String refreshToken;
  private final @Nullable TokenFormat tokenFormat;

  private RefreshTokenRequest(RefreshTokenRequest.Builder builder) {
    this.clientId = builder.clientId;
    this.clientSecret = builder.clientSecret;
    this.refreshToken = builder.refreshToken;
    this.tokenFormat = builder.tokenFormat;
  }

  /**
   * The client identifier
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The client's secret passphrase
   */
  @Override
  public String getClientSecret() {
    return clientSecret;
  }

  /**
   * The password
   */
  @Override
  public String getRefreshToken() {
    return refreshToken;
  }

  /**
   * The token format
   */
  @Override
  public @Nullable TokenFormat getTokenFormat() {
    return tokenFormat;
  }

  /**
   * This instance is equal to all instances of {@code RefreshTokenRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RefreshTokenRequest
        && equalTo((RefreshTokenRequest) another);
  }

  private boolean equalTo(RefreshTokenRequest another) {
    return clientId.equals(another.clientId)
        && clientSecret.equals(another.clientSecret)
        && refreshToken.equals(another.refreshToken)
        && Objects.equals(tokenFormat, another.tokenFormat);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code clientSecret}, {@code refreshToken}, {@code tokenFormat}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + clientId.hashCode();
    h = h * 17 + clientSecret.hashCode();
    h = h * 17 + refreshToken.hashCode();
    h = h * 17 + Objects.hashCode(tokenFormat);
    return h;
  }

  /**
   * Prints the immutable value {@code RefreshTokenRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RefreshTokenRequest{"
        + "clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + ", refreshToken=" + refreshToken
        + ", tokenFormat=" + tokenFormat
        + "}";
  }

  /**
   * Creates a builder for {@link RefreshTokenRequest RefreshTokenRequest}.
   * @return A new RefreshTokenRequest builder
   */
  public static RefreshTokenRequest.Builder builder() {
    return new RefreshTokenRequest.Builder();
  }

  /**
   * Builds instances of type {@link RefreshTokenRequest RefreshTokenRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private static final long INIT_BIT_CLIENT_SECRET = 0x2L;
    private static final long INIT_BIT_REFRESH_TOKEN = 0x4L;
    private long initBits = 0x7L;

    private String clientId;
    private String clientSecret;
    private String refreshToken;
    private TokenFormat tokenFormat;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RefreshTokenRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RefreshTokenRequest instance) {
      return from((_RefreshTokenRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RefreshTokenRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RefreshTokenRequest instance) {
      Objects.requireNonNull(instance, "instance");
      clientId(instance.getClientId());
      clientSecret(instance.getClientSecret());
      refreshToken(instance.getRefreshToken());
      TokenFormat tokenFormatValue = instance.getTokenFormat();
      if (tokenFormatValue != null) {
        tokenFormat(tokenFormatValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _RefreshTokenRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _RefreshTokenRequest#getClientSecret() clientSecret} attribute.
     * @param clientSecret The value for clientSecret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(String clientSecret) {
      this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
      initBits &= ~INIT_BIT_CLIENT_SECRET;
      return this;
    }

    /**
     * Initializes the value for the {@link _RefreshTokenRequest#getRefreshToken() refreshToken} attribute.
     * @param refreshToken The value for refreshToken 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder refreshToken(String refreshToken) {
      this.refreshToken = Objects.requireNonNull(refreshToken, "refreshToken");
      initBits &= ~INIT_BIT_REFRESH_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link _RefreshTokenRequest#getTokenFormat() tokenFormat} attribute.
     * @param tokenFormat The value for tokenFormat (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tokenFormat(@Nullable TokenFormat tokenFormat) {
      this.tokenFormat = tokenFormat;
      return this;
    }

    /**
     * Builds a new {@link RefreshTokenRequest RefreshTokenRequest}.
     * @return An immutable instance of RefreshTokenRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RefreshTokenRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RefreshTokenRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_CLIENT_SECRET) != 0) attributes.add("clientSecret");
      if ((initBits & INIT_BIT_REFRESH_TOKEN) != 0) attributes.add("refreshToken");
      return "Cannot build RefreshTokenRequest, some of required attributes are not set " + attributes;
    }
  }
}
