package org.cloudfoundry.client.v2.environmentvariablegroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the update staging environment variable group
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateStagingEnvironmentVariablesResponse"})
public final class UpdateStagingEnvironmentVariablesResponse
    extends org.cloudfoundry.client.v2.environmentvariablegroups._UpdateStagingEnvironmentVariablesResponse {
  private final Map<String, Object> environmentVariables;

  private UpdateStagingEnvironmentVariablesResponse(UpdateStagingEnvironmentVariablesResponse.Builder builder) {
    this.environmentVariables = createUnmodifiableMap(false, false, builder.environmentVariables);
  }

  /**
   * The environment variables
   */
  @JsonProperty("environmentVariables")
  @Override
  public Map<String, Object> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * This instance is equal to all instances of {@code UpdateStagingEnvironmentVariablesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateStagingEnvironmentVariablesResponse
        && equalTo((UpdateStagingEnvironmentVariablesResponse) another);
  }

  private boolean equalTo(UpdateStagingEnvironmentVariablesResponse another) {
    return environmentVariables.equals(another.environmentVariables);
  }

  /**
   * Computes a hash code from attributes: {@code environmentVariables}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + environmentVariables.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateStagingEnvironmentVariablesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateStagingEnvironmentVariablesResponse{"
        + "environmentVariables=" + environmentVariables
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.environmentvariablegroups._UpdateStagingEnvironmentVariablesResponse {
    Map<String, Object> environmentVariables = Collections.emptyMap();
    @JsonProperty("environmentVariables")
    public void setEnvironmentVariables(Map<String, Object> environmentVariables) {
      this.environmentVariables = environmentVariables;
    }
    @Override
    public Map<String, Object> getEnvironmentVariables() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateStagingEnvironmentVariablesResponse fromJson(Json json) {
    UpdateStagingEnvironmentVariablesResponse.Builder builder = UpdateStagingEnvironmentVariablesResponse.builder();
    if (json.environmentVariables != null) {
      builder.putAllEnvironmentVariables(json.environmentVariables);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateStagingEnvironmentVariablesResponse UpdateStagingEnvironmentVariablesResponse}.
   * @return A new UpdateStagingEnvironmentVariablesResponse builder
   */
  public static UpdateStagingEnvironmentVariablesResponse.Builder builder() {
    return new UpdateStagingEnvironmentVariablesResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateStagingEnvironmentVariablesResponse UpdateStagingEnvironmentVariablesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Map<String, Object> environmentVariables = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateStagingEnvironmentVariablesResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateStagingEnvironmentVariablesResponse instance) {
      return from((_UpdateStagingEnvironmentVariablesResponse) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateStagingEnvironmentVariablesResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateStagingEnvironmentVariablesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      putAllEnvironmentVariables(instance.getEnvironmentVariables());
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateStagingEnvironmentVariablesResponse#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(String key, Object value) {
      this.environmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateStagingEnvironmentVariablesResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.environmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _UpdateStagingEnvironmentVariablesResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("environmentVariables")
    public final Builder environmentVariables(Map<String, ? extends Object> environmentVariables) {
      this.environmentVariables.clear();
      return putAllEnvironmentVariables(environmentVariables);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _UpdateStagingEnvironmentVariablesResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> environmentVariables) {
      for (Map.Entry<String, ? extends Object> entry : environmentVariables.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.environmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link UpdateStagingEnvironmentVariablesResponse UpdateStagingEnvironmentVariablesResponse}.
     * @return An immutable instance of UpdateStagingEnvironmentVariablesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateStagingEnvironmentVariablesResponse build() {
      return new UpdateStagingEnvironmentVariablesResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
