package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Disassociate Billing Manager with the Organization by Username operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RemoveOrganizationBillingManagerByUsernameRequest"})
public final class RemoveOrganizationBillingManagerByUsernameRequest
    extends org.cloudfoundry.client.v2.organizations._RemoveOrganizationBillingManagerByUsernameRequest {
  private final String organizationId;
  private final @Nullable String origin;
  private final String username;

  private RemoveOrganizationBillingManagerByUsernameRequest(RemoveOrganizationBillingManagerByUsernameRequest.Builder builder) {
    this.organizationId = builder.organizationId;
    this.origin = builder.origin;
    this.username = builder.username;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The origin
   */
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * The username
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code RemoveOrganizationBillingManagerByUsernameRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveOrganizationBillingManagerByUsernameRequest
        && equalTo((RemoveOrganizationBillingManagerByUsernameRequest) another);
  }

  private boolean equalTo(RemoveOrganizationBillingManagerByUsernameRequest another) {
    return organizationId.equals(another.organizationId)
        && Objects.equals(origin, another.origin)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}, {@code origin}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + Objects.hashCode(origin);
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveOrganizationBillingManagerByUsernameRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveOrganizationBillingManagerByUsernameRequest{"
        + "organizationId=" + organizationId
        + ", origin=" + origin
        + ", username=" + username
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveOrganizationBillingManagerByUsernameRequest RemoveOrganizationBillingManagerByUsernameRequest}.
   * @return A new RemoveOrganizationBillingManagerByUsernameRequest builder
   */
  public static RemoveOrganizationBillingManagerByUsernameRequest.Builder builder() {
    return new RemoveOrganizationBillingManagerByUsernameRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveOrganizationBillingManagerByUsernameRequest RemoveOrganizationBillingManagerByUsernameRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_USERNAME = 0x2L;
    private long initBits = 0x3L;

    private String organizationId;
    private String origin;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveOrganizationBillingManagerByUsernameRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveOrganizationBillingManagerByUsernameRequest instance) {
      return from((_RemoveOrganizationBillingManagerByUsernameRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveOrganizationBillingManagerByUsernameRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveOrganizationBillingManagerByUsernameRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationId(instance.getOrganizationId());
      String originValue = instance.getOrigin();
      if (originValue != null) {
        origin(originValue);
      }
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveOrganizationBillingManagerByUsernameRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveOrganizationBillingManagerByUsernameRequest#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Initializes the value for the {@link _RemoveOrganizationBillingManagerByUsernameRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link RemoveOrganizationBillingManagerByUsernameRequest RemoveOrganizationBillingManagerByUsernameRequest}.
     * @return An immutable instance of RemoveOrganizationBillingManagerByUsernameRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveOrganizationBillingManagerByUsernameRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveOrganizationBillingManagerByUsernameRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build RemoveOrganizationBillingManagerByUsernameRequest, some of required attributes are not set " + attributes;
    }
  }
}
