package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The entity representing a service instance schema
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ServiceInstanceSchema"})
public final class ServiceInstanceSchema
    extends org.cloudfoundry.client.v2.serviceplans._ServiceInstanceSchema {
  private final Schema create;
  private final Schema update;

  private ServiceInstanceSchema(ServiceInstanceSchema.Builder builder) {
    this.create = builder.create;
    this.update = builder.update;
  }

  /**
   * The create schema
   */
  @JsonProperty("create")
  @Override
  public Schema getCreate() {
    return create;
  }

  /**
   * The update schema
   */
  @JsonProperty("update")
  @Override
  public Schema getUpdate() {
    return update;
  }

  /**
   * This instance is equal to all instances of {@code ServiceInstanceSchema} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceInstanceSchema
        && equalTo((ServiceInstanceSchema) another);
  }

  private boolean equalTo(ServiceInstanceSchema another) {
    return create.equals(another.create)
        && update.equals(another.update);
  }

  /**
   * Computes a hash code from attributes: {@code create}, {@code update}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + create.hashCode();
    h += (h << 5) + update.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceInstanceSchema} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceInstanceSchema{"
        + "create=" + create
        + ", update=" + update
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceplans._ServiceInstanceSchema {
    Schema create;
    Schema update;
    @JsonProperty("create")
    public void setCreate(Schema create) {
      this.create = create;
    }
    @JsonProperty("update")
    public void setUpdate(Schema update) {
      this.update = update;
    }
    @Override
    public Schema getCreate() { throw new UnsupportedOperationException(); }
    @Override
    public Schema getUpdate() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceInstanceSchema fromJson(Json json) {
    ServiceInstanceSchema.Builder builder = ServiceInstanceSchema.builder();
    if (json.create != null) {
      builder.create(json.create);
    }
    if (json.update != null) {
      builder.update(json.update);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceInstanceSchema ServiceInstanceSchema}.
   * @return A new ServiceInstanceSchema builder
   */
  public static ServiceInstanceSchema.Builder builder() {
    return new ServiceInstanceSchema.Builder();
  }

  /**
   * Builds instances of type {@link ServiceInstanceSchema ServiceInstanceSchema}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CREATE = 0x1L;
    private static final long INIT_BIT_UPDATE = 0x2L;
    private long initBits = 0x3L;

    private Schema create;
    private Schema update;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceInstanceSchema} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceInstanceSchema instance) {
      return from((_ServiceInstanceSchema) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceInstanceSchema} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceInstanceSchema instance) {
      Objects.requireNonNull(instance, "instance");
      create(instance.getCreate());
      update(instance.getUpdate());
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstanceSchema#getCreate() create} attribute.
     * @param create The value for create 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("create")
    public final Builder create(Schema create) {
      this.create = Objects.requireNonNull(create, "create");
      initBits &= ~INIT_BIT_CREATE;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstanceSchema#getUpdate() update} attribute.
     * @param update The value for update 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("update")
    public final Builder update(Schema update) {
      this.update = Objects.requireNonNull(update, "update");
      initBits &= ~INIT_BIT_UPDATE;
      return this;
    }

    /**
     * Builds a new {@link ServiceInstanceSchema ServiceInstanceSchema}.
     * @return An immutable instance of ServiceInstanceSchema
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceInstanceSchema build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServiceInstanceSchema(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_CREATE) != 0) attributes.add("create");
      if ((initBits & INIT_BIT_UPDATE) != 0) attributes.add("update");
      return "Cannot build ServiceInstanceSchema, some of required attributes are not set " + attributes;
    }
  }
}
