package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Associate Auditor with the Space by Username operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_AssociateSpaceAuditorByUsernameRequest"})
public final class AssociateSpaceAuditorByUsernameRequest
    extends org.cloudfoundry.client.v2.spaces._AssociateSpaceAuditorByUsernameRequest {
  private final @Nullable String origin;
  private final String spaceId;
  private final String username;

  private AssociateSpaceAuditorByUsernameRequest(AssociateSpaceAuditorByUsernameRequest.Builder builder) {
    this.origin = builder.origin;
    this.spaceId = builder.spaceId;
    this.username = builder.username;
  }

  /**
   * The origin
   */
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * The username
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code AssociateSpaceAuditorByUsernameRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateSpaceAuditorByUsernameRequest
        && equalTo((AssociateSpaceAuditorByUsernameRequest) another);
  }

  private boolean equalTo(AssociateSpaceAuditorByUsernameRequest another) {
    return Objects.equals(origin, another.origin)
        && spaceId.equals(another.spaceId)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code origin}, {@code spaceId}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(origin);
    h += (h << 5) + spaceId.hashCode();
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateSpaceAuditorByUsernameRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateSpaceAuditorByUsernameRequest{"
        + "origin=" + origin
        + ", spaceId=" + spaceId
        + ", username=" + username
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateSpaceAuditorByUsernameRequest AssociateSpaceAuditorByUsernameRequest}.
   * @return A new AssociateSpaceAuditorByUsernameRequest builder
   */
  public static AssociateSpaceAuditorByUsernameRequest.Builder builder() {
    return new AssociateSpaceAuditorByUsernameRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateSpaceAuditorByUsernameRequest AssociateSpaceAuditorByUsernameRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private static final long INIT_BIT_USERNAME = 0x2L;
    private long initBits = 0x3L;

    private String origin;
    private String spaceId;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateSpaceAuditorByUsernameRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateSpaceAuditorByUsernameRequest instance) {
      return from((_AssociateSpaceAuditorByUsernameRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateSpaceAuditorByUsernameRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateSpaceAuditorByUsernameRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String originValue = instance.getOrigin();
      if (originValue != null) {
        origin(originValue);
      }
      spaceId(instance.getSpaceId());
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link _AssociateSpaceAuditorByUsernameRequest#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Initializes the value for the {@link _AssociateSpaceAuditorByUsernameRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _AssociateSpaceAuditorByUsernameRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link AssociateSpaceAuditorByUsernameRequest AssociateSpaceAuditorByUsernameRequest}.
     * @return An immutable instance of AssociateSpaceAuditorByUsernameRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateSpaceAuditorByUsernameRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateSpaceAuditorByUsernameRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build AssociateSpaceAuditorByUsernameRequest, some of required attributes are not set " + attributes;
    }
  }
}
