package org.cloudfoundry.client.v3.packages;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Upload Package operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UploadPackageRequest"})
public final class UploadPackageRequest extends org.cloudfoundry.client.v3.packages._UploadPackageRequest {
  private final Path bits;
  private final String packageId;

  private UploadPackageRequest(UploadPackageRequest.Builder builder) {
    this.bits = builder.bits;
    this.packageId = builder.packageId;
  }

  /**
   * The bits
   */
  @Override
  public Path getBits() {
    return bits;
  }

  /**
   * The package id
   */
  @Override
  public String getPackageId() {
    return packageId;
  }

  /**
   * This instance is equal to all instances of {@code UploadPackageRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UploadPackageRequest
        && equalTo((UploadPackageRequest) another);
  }

  private boolean equalTo(UploadPackageRequest another) {
    return bits.equals(another.bits)
        && packageId.equals(another.packageId);
  }

  /**
   * Computes a hash code from attributes: {@code bits}, {@code packageId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + bits.hashCode();
    h += (h << 5) + packageId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UploadPackageRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UploadPackageRequest{"
        + "bits=" + bits
        + ", packageId=" + packageId
        + "}";
  }

  /**
   * Creates a builder for {@link UploadPackageRequest UploadPackageRequest}.
   * @return A new UploadPackageRequest builder
   */
  public static UploadPackageRequest.Builder builder() {
    return new UploadPackageRequest.Builder();
  }

  /**
   * Builds instances of type {@link UploadPackageRequest UploadPackageRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_BITS = 0x1L;
    private static final long INIT_BIT_PACKAGE_ID = 0x2L;
    private long initBits = 0x3L;

    private Path bits;
    private String packageId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UploadPackageRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UploadPackageRequest instance) {
      return from((_UploadPackageRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UploadPackageRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UploadPackageRequest instance) {
      Objects.requireNonNull(instance, "instance");
      bits(instance.getBits());
      packageId(instance.getPackageId());
      return this;
    }

    /**
     * Initializes the value for the {@link _UploadPackageRequest#getBits() bits} attribute.
     * @param bits The value for bits 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bits(Path bits) {
      this.bits = Objects.requireNonNull(bits, "bits");
      initBits &= ~INIT_BIT_BITS;
      return this;
    }

    /**
     * Initializes the value for the {@link _UploadPackageRequest#getPackageId() packageId} attribute.
     * @param packageId The value for packageId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageId(String packageId) {
      this.packageId = Objects.requireNonNull(packageId, "packageId");
      initBits &= ~INIT_BIT_PACKAGE_ID;
      return this;
    }

    /**
     * Builds a new {@link UploadPackageRequest UploadPackageRequest}.
     * @return An immutable instance of UploadPackageRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UploadPackageRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UploadPackageRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_BITS) != 0) attributes.add("bits");
      if ((initBits & INIT_BIT_PACKAGE_ID) != 0) attributes.add("packageId");
      return "Cannot build UploadPackageRequest, some of required attributes are not set " + attributes;
    }
  }
}
