package org.cloudfoundry.client.v3.processes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Terminate Process Instance operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_TerminateProcessInstanceRequest"})
public final class TerminateProcessInstanceRequest
    extends org.cloudfoundry.client.v3.processes._TerminateProcessInstanceRequest {
  private final String index;
  private final String processId;

  private TerminateProcessInstanceRequest(TerminateProcessInstanceRequest.Builder builder) {
    this.index = builder.index;
    this.processId = builder.processId;
  }

  /**
   * The index
   */
  @Override
  public String getIndex() {
    return index;
  }

  /**
   * The process id
   */
  @Override
  public String getProcessId() {
    return processId;
  }

  /**
   * This instance is equal to all instances of {@code TerminateProcessInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof TerminateProcessInstanceRequest
        && equalTo((TerminateProcessInstanceRequest) another);
  }

  private boolean equalTo(TerminateProcessInstanceRequest another) {
    return index.equals(another.index)
        && processId.equals(another.processId);
  }

  /**
   * Computes a hash code from attributes: {@code index}, {@code processId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + index.hashCode();
    h += (h << 5) + processId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TerminateProcessInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TerminateProcessInstanceRequest{"
        + "index=" + index
        + ", processId=" + processId
        + "}";
  }

  /**
   * Creates a builder for {@link TerminateProcessInstanceRequest TerminateProcessInstanceRequest}.
   * @return A new TerminateProcessInstanceRequest builder
   */
  public static TerminateProcessInstanceRequest.Builder builder() {
    return new TerminateProcessInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link TerminateProcessInstanceRequest TerminateProcessInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_INDEX = 0x1L;
    private static final long INIT_BIT_PROCESS_ID = 0x2L;
    private long initBits = 0x3L;

    private String index;
    private String processId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TerminateProcessInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TerminateProcessInstanceRequest instance) {
      return from((_TerminateProcessInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _TerminateProcessInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_TerminateProcessInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      index(instance.getIndex());
      processId(instance.getProcessId());
      return this;
    }

    /**
     * Initializes the value for the {@link _TerminateProcessInstanceRequest#getIndex() index} attribute.
     * @param index The value for index 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder index(String index) {
      this.index = Objects.requireNonNull(index, "index");
      initBits &= ~INIT_BIT_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link _TerminateProcessInstanceRequest#getProcessId() processId} attribute.
     * @param processId The value for processId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processId(String processId) {
      this.processId = Objects.requireNonNull(processId, "processId");
      initBits &= ~INIT_BIT_PROCESS_ID;
      return this;
    }

    /**
     * Builds a new {@link TerminateProcessInstanceRequest TerminateProcessInstanceRequest}.
     * @return An immutable instance of TerminateProcessInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public TerminateProcessInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new TerminateProcessInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_INDEX) != 0) attributes.add("index");
      if ((initBits & INIT_BIT_PROCESS_ID) != 0) attributes.add("processId");
      return "Cannot build TerminateProcessInstanceRequest, some of required attributes are not set " + attributes;
    }
  }
}
