package org.cloudfoundry.routing.v1.tcproutes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Create TCP Routes operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CreateTcpRoutesRequest"})
public final class CreateTcpRoutesRequest
    extends org.cloudfoundry.routing.v1.tcproutes._CreateTcpRoutesRequest {
  private final List<TcpRouteConfiguration> tcpRoutes;

  private CreateTcpRoutesRequest(CreateTcpRoutesRequest.Builder builder) {
    this.tcpRoutes = createUnmodifiableList(true, builder.tcpRoutes);
  }

  /**
   * The TCP Routes
   */
  @JsonProperty("tcpRoutes")
  @Override
  public List<TcpRouteConfiguration> getTcpRoutes() {
    return tcpRoutes;
  }

  /**
   * This instance is equal to all instances of {@code CreateTcpRoutesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateTcpRoutesRequest
        && equalTo((CreateTcpRoutesRequest) another);
  }

  private boolean equalTo(CreateTcpRoutesRequest another) {
    return tcpRoutes.equals(another.tcpRoutes);
  }

  /**
   * Computes a hash code from attributes: {@code tcpRoutes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + tcpRoutes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateTcpRoutesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateTcpRoutesRequest{"
        + "tcpRoutes=" + tcpRoutes
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.routing.v1.tcproutes._CreateTcpRoutesRequest {
    List<TcpRouteConfiguration> tcpRoutes = Collections.emptyList();
    @JsonProperty("tcpRoutes")
    public void setTcpRoutes(List<TcpRouteConfiguration> tcpRoutes) {
      this.tcpRoutes = tcpRoutes;
    }
    @Override
    public List<TcpRouteConfiguration> getTcpRoutes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateTcpRoutesRequest fromJson(Json json) {
    CreateTcpRoutesRequest.Builder builder = CreateTcpRoutesRequest.builder();
    if (json.tcpRoutes != null) {
      builder.addAllTcpRoutes(json.tcpRoutes);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateTcpRoutesRequest CreateTcpRoutesRequest}.
   * @return A new CreateTcpRoutesRequest builder
   */
  public static CreateTcpRoutesRequest.Builder builder() {
    return new CreateTcpRoutesRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateTcpRoutesRequest CreateTcpRoutesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<TcpRouteConfiguration> tcpRoutes = new ArrayList<TcpRouteConfiguration>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateTcpRoutesRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateTcpRoutesRequest instance) {
      return from((_CreateTcpRoutesRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateTcpRoutesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateTcpRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTcpRoutes(instance.getTcpRoutes());
      return this;
    }

    /**
     * Adds one element to {@link _CreateTcpRoutesRequest#getTcpRoutes() tcpRoutes} list.
     * @param element A tcpRoutes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tcpRoute(TcpRouteConfiguration element) {
      this.tcpRoutes.add(Objects.requireNonNull(element, "tcpRoutes element"));
      return this;
    }

    /**
     * Adds elements to {@link _CreateTcpRoutesRequest#getTcpRoutes() tcpRoutes} list.
     * @param elements An array of tcpRoutes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tcpRoute(TcpRouteConfiguration... elements) {
      for (TcpRouteConfiguration element : elements) {
        this.tcpRoutes.add(Objects.requireNonNull(element, "tcpRoutes element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _CreateTcpRoutesRequest#getTcpRoutes() tcpRoutes} list.
     * @param elements An iterable of tcpRoutes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tcpRoutes(Iterable<? extends TcpRouteConfiguration> elements) {
      this.tcpRoutes.clear();
      return addAllTcpRoutes(elements);
    }

    /**
     * Adds elements to {@link _CreateTcpRoutesRequest#getTcpRoutes() tcpRoutes} list.
     * @param elements An iterable of tcpRoutes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTcpRoutes(Iterable<? extends TcpRouteConfiguration> elements) {
      for (TcpRouteConfiguration element : elements) {
        this.tcpRoutes.add(Objects.requireNonNull(element, "tcpRoutes element"));
      }
      return this;
    }

    /**
     * Builds a new {@link CreateTcpRoutesRequest CreateTcpRoutesRequest}.
     * @return An immutable instance of CreateTcpRoutesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateTcpRoutesRequest build() {
      return new CreateTcpRoutesRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
