package org.cloudfoundry.uaa.identityproviders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * The request payload for the delete identity provider
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_DeleteIdentityProviderRequest"})
public final class DeleteIdentityProviderRequest
    extends org.cloudfoundry.uaa.identityproviders._DeleteIdentityProviderRequest {
  private final String identityProviderId;
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;

  private DeleteIdentityProviderRequest(DeleteIdentityProviderRequest.Builder builder) {
    this.identityProviderId = builder.identityProviderId;
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
  }

  /**
   * The identity provider id
   */
  @Override
  public String getIdentityProviderId() {
    return identityProviderId;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * This instance is equal to all instances of {@code DeleteIdentityProviderRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteIdentityProviderRequest
        && equalTo((DeleteIdentityProviderRequest) another);
  }

  private boolean equalTo(DeleteIdentityProviderRequest another) {
    return identityProviderId.equals(another.identityProviderId)
        && Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain);
  }

  /**
   * Computes a hash code from attributes: {@code identityProviderId}, {@code identityZoneId}, {@code identityZoneSubdomain}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + identityProviderId.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteIdentityProviderRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteIdentityProviderRequest{"
        + "identityProviderId=" + identityProviderId
        + ", identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteIdentityProviderRequest DeleteIdentityProviderRequest}.
   * @return A new DeleteIdentityProviderRequest builder
   */
  public static DeleteIdentityProviderRequest.Builder builder() {
    return new DeleteIdentityProviderRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteIdentityProviderRequest DeleteIdentityProviderRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_IDENTITY_PROVIDER_ID = 0x1L;
    private long initBits = 0x1L;

    private String identityProviderId;
    private String identityZoneId;
    private String identityZoneSubdomain;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteIdentityProviderRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteIdentityProviderRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _DeleteIdentityProviderRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteIdentityProviderRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.identityproviders._DeleteIdentityProviderRequest) {
        org.cloudfoundry.uaa.identityproviders._DeleteIdentityProviderRequest instance = (org.cloudfoundry.uaa.identityproviders._DeleteIdentityProviderRequest) object;
        identityProviderId(instance.getIdentityProviderId());
      }
    }

    /**
     * Initializes the value for the {@link _DeleteIdentityProviderRequest#getIdentityProviderId() identityProviderId} attribute.
     * @param identityProviderId The value for identityProviderId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityProviderId(String identityProviderId) {
      this.identityProviderId = Objects.requireNonNull(identityProviderId, "identityProviderId");
      initBits &= ~INIT_BIT_IDENTITY_PROVIDER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteIdentityProviderRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteIdentityProviderRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Builds a new {@link DeleteIdentityProviderRequest DeleteIdentityProviderRequest}.
     * @return An immutable instance of DeleteIdentityProviderRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteIdentityProviderRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteIdentityProviderRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_IDENTITY_PROVIDER_ID) != 0) attributes.add("identityProviderId");
      return "Cannot build DeleteIdentityProviderRequest, some of required attributes are not set " + attributes;
    }
  }
}
