package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The payload for the identity branding banner configuration
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Banner"})
public final class Banner extends org.cloudfoundry.uaa.identityzones._Banner {
  private final @Nullable String backgroundColor;
  private final @Nullable String link;
  private final @Nullable String logo;
  private final @Nullable String text;
  private final @Nullable String textColor;

  private Banner(Banner.Builder builder) {
    this.backgroundColor = builder.backgroundColor;
    this.link = builder.link;
    this.logo = builder.logo;
    this.text = builder.text;
    this.textColor = builder.textColor;
  }

  /**
   * The hexadecimal color code for banner background color
   */
  @JsonProperty("backgroundColor")
  @Override
  public @Nullable String getBackgroundColor() {
    return backgroundColor;
  }

  /**
   * The UAA login banner will be a link pointing to this url
   */
  @JsonProperty("link")
  @Override
  public @Nullable String getLink() {
    return link;
  }

  /**
   * The base64 encoded PNG data displayed in a banner at the top of the UAA login page, overrides banner text
   */
  @JsonProperty("logo")
  @Override
  public @Nullable String getLogo() {
    return logo;
  }

  /**
   * The text displayed in a banner at the top of the UAA login page
   */
  @JsonProperty("text")
  @Override
  public @Nullable String getText() {
    return text;
  }

  /**
   * The hexadecimal color code for the banner text color
   */
  @JsonProperty("textColor")
  @Override
  public @Nullable String getTextColor() {
    return textColor;
  }

  /**
   * This instance is equal to all instances of {@code Banner} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Banner
        && equalTo((Banner) another);
  }

  private boolean equalTo(Banner another) {
    return Objects.equals(backgroundColor, another.backgroundColor)
        && Objects.equals(link, another.link)
        && Objects.equals(logo, another.logo)
        && Objects.equals(text, another.text)
        && Objects.equals(textColor, another.textColor);
  }

  /**
   * Computes a hash code from attributes: {@code backgroundColor}, {@code link}, {@code logo}, {@code text}, {@code textColor}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(backgroundColor);
    h += (h << 5) + Objects.hashCode(link);
    h += (h << 5) + Objects.hashCode(logo);
    h += (h << 5) + Objects.hashCode(text);
    h += (h << 5) + Objects.hashCode(textColor);
    return h;
  }

  /**
   * Prints the immutable value {@code Banner} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Banner{"
        + "backgroundColor=" + backgroundColor
        + ", link=" + link
        + ", logo=" + logo
        + ", text=" + text
        + ", textColor=" + textColor
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._Banner {
    String backgroundColor;
    String link;
    String logo;
    String text;
    String textColor;
    @JsonProperty("backgroundColor")
    public void setBackgroundColor(@Nullable String backgroundColor) {
      this.backgroundColor = backgroundColor;
    }
    @JsonProperty("link")
    public void setLink(@Nullable String link) {
      this.link = link;
    }
    @JsonProperty("logo")
    public void setLogo(@Nullable String logo) {
      this.logo = logo;
    }
    @JsonProperty("text")
    public void setText(@Nullable String text) {
      this.text = text;
    }
    @JsonProperty("textColor")
    public void setTextColor(@Nullable String textColor) {
      this.textColor = textColor;
    }
    @Override
    public String getBackgroundColor() { throw new UnsupportedOperationException(); }
    @Override
    public String getLink() { throw new UnsupportedOperationException(); }
    @Override
    public String getLogo() { throw new UnsupportedOperationException(); }
    @Override
    public String getText() { throw new UnsupportedOperationException(); }
    @Override
    public String getTextColor() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Banner fromJson(Json json) {
    Banner.Builder builder = Banner.builder();
    if (json.backgroundColor != null) {
      builder.backgroundColor(json.backgroundColor);
    }
    if (json.link != null) {
      builder.link(json.link);
    }
    if (json.logo != null) {
      builder.logo(json.logo);
    }
    if (json.text != null) {
      builder.text(json.text);
    }
    if (json.textColor != null) {
      builder.textColor(json.textColor);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Banner Banner}.
   * @return A new Banner builder
   */
  public static Banner.Builder builder() {
    return new Banner.Builder();
  }

  /**
   * Builds instances of type {@link Banner Banner}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String backgroundColor;
    private String link;
    private String logo;
    private String text;
    private String textColor;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Banner} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Banner instance) {
      return from((_Banner) instance);
    }

    /**
     * Copy abstract value type {@code _Banner} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Banner instance) {
      Objects.requireNonNull(instance, "instance");
      String backgroundColorValue = instance.getBackgroundColor();
      if (backgroundColorValue != null) {
        backgroundColor(backgroundColorValue);
      }
      String linkValue = instance.getLink();
      if (linkValue != null) {
        link(linkValue);
      }
      String logoValue = instance.getLogo();
      if (logoValue != null) {
        logo(logoValue);
      }
      String textValue = instance.getText();
      if (textValue != null) {
        text(textValue);
      }
      String textColorValue = instance.getTextColor();
      if (textColorValue != null) {
        textColor(textColorValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Banner#getBackgroundColor() backgroundColor} attribute.
     * @param backgroundColor The value for backgroundColor (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("backgroundColor")
    public final Builder backgroundColor(@Nullable String backgroundColor) {
      this.backgroundColor = backgroundColor;
      return this;
    }

    /**
     * Initializes the value for the {@link _Banner#getLink() link} attribute.
     * @param link The value for link (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("link")
    public final Builder link(@Nullable String link) {
      this.link = link;
      return this;
    }

    /**
     * Initializes the value for the {@link _Banner#getLogo() logo} attribute.
     * @param logo The value for logo (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("logo")
    public final Builder logo(@Nullable String logo) {
      this.logo = logo;
      return this;
    }

    /**
     * Initializes the value for the {@link _Banner#getText() text} attribute.
     * @param text The value for text (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("text")
    public final Builder text(@Nullable String text) {
      this.text = text;
      return this;
    }

    /**
     * Initializes the value for the {@link _Banner#getTextColor() textColor} attribute.
     * @param textColor The value for textColor (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("textColor")
    public final Builder textColor(@Nullable String textColor) {
      this.textColor = textColor;
      return this;
    }

    /**
     * Builds a new {@link Banner Banner}.
     * @return An immutable instance of Banner
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Banner build() {
      return new Banner(this);
    }
  }
}
