package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The payload for the key
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Key"})
public final class Key extends org.cloudfoundry.uaa.identityzones._Key {
  private final @Nullable String certificate;
  private final @Nullable String key;
  private final @Nullable String passphrase;

  private Key(Key.Builder builder) {
    this.certificate = builder.certificate;
    this.key = builder.key;
    this.passphrase = builder.passphrase;
  }

  /**
   * The certificate
   */
  @JsonProperty("certificate")
  @Override
  public @Nullable String getCertificate() {
    return certificate;
  }

  /**
   * The SAML provider's private key
   */
  @JsonProperty("key")
  @Override
  public @Nullable String getKey() {
    return key;
  }

  /**
   * The SAML provider's private key password
   */
  @JsonProperty("passphrase")
  @Override
  public @Nullable String getPassphrase() {
    return passphrase;
  }

  /**
   * This instance is equal to all instances of {@code Key} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Key
        && equalTo((Key) another);
  }

  private boolean equalTo(Key another) {
    return Objects.equals(certificate, another.certificate)
        && Objects.equals(key, another.key)
        && Objects.equals(passphrase, another.passphrase);
  }

  /**
   * Computes a hash code from attributes: {@code certificate}, {@code key}, {@code passphrase}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(certificate);
    h += (h << 5) + Objects.hashCode(key);
    h += (h << 5) + Objects.hashCode(passphrase);
    return h;
  }

  /**
   * Prints the immutable value {@code Key} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Key{"
        + "certificate=" + certificate
        + ", key=" + key
        + ", passphrase=" + passphrase
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._Key {
    String certificate;
    String key;
    String passphrase;
    @JsonProperty("certificate")
    public void setCertificate(@Nullable String certificate) {
      this.certificate = certificate;
    }
    @JsonProperty("key")
    public void setKey(@Nullable String key) {
      this.key = key;
    }
    @JsonProperty("passphrase")
    public void setPassphrase(@Nullable String passphrase) {
      this.passphrase = passphrase;
    }
    @Override
    public String getCertificate() { throw new UnsupportedOperationException(); }
    @Override
    public String getKey() { throw new UnsupportedOperationException(); }
    @Override
    public String getPassphrase() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Key fromJson(Json json) {
    Key.Builder builder = Key.builder();
    if (json.certificate != null) {
      builder.certificate(json.certificate);
    }
    if (json.key != null) {
      builder.key(json.key);
    }
    if (json.passphrase != null) {
      builder.passphrase(json.passphrase);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Key Key}.
   * @return A new Key builder
   */
  public static Key.Builder builder() {
    return new Key.Builder();
  }

  /**
   * Builds instances of type {@link Key Key}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String certificate;
    private String key;
    private String passphrase;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Key} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Key instance) {
      return from((_Key) instance);
    }

    /**
     * Copy abstract value type {@code _Key} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Key instance) {
      Objects.requireNonNull(instance, "instance");
      String certificateValue = instance.getCertificate();
      if (certificateValue != null) {
        certificate(certificateValue);
      }
      String keyValue = instance.getKey();
      if (keyValue != null) {
        key(keyValue);
      }
      String passphraseValue = instance.getPassphrase();
      if (passphraseValue != null) {
        passphrase(passphraseValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Key#getCertificate() certificate} attribute.
     * @param certificate The value for certificate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("certificate")
    public final Builder certificate(@Nullable String certificate) {
      this.certificate = certificate;
      return this;
    }

    /**
     * Initializes the value for the {@link _Key#getKey() key} attribute.
     * @param key The value for key (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("key")
    public final Builder key(@Nullable String key) {
      this.key = key;
      return this;
    }

    /**
     * Initializes the value for the {@link _Key#getPassphrase() passphrase} attribute.
     * @param passphrase The value for passphrase (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("passphrase")
    public final Builder passphrase(@Nullable String passphrase) {
      this.passphrase = passphrase;
      return this;
    }

    /**
     * Builds a new {@link Key Key}.
     * @return An immutable instance of Key
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Key build() {
      return new Key(this);
    }
  }
}
