package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The payload for the Multi-factor Authentication configuration
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_MfaConfig"})
public final class MfaConfig extends org.cloudfoundry.uaa.identityzones._MfaConfig {
  private final @Nullable Boolean enabled;
  private final @Nullable String providerName;

  private MfaConfig(MfaConfig.Builder builder) {
    this.enabled = builder.enabled;
    this.providerName = builder.providerName;
  }

  /**
   * Whether Multi-factor Authentication is enabled
   */
  @JsonProperty("enabled")
  @Override
  public @Nullable Boolean getEnabled() {
    return enabled;
  }

  /**
   * The XHR configuration
   */
  @JsonProperty("providerName")
  @Override
  public @Nullable String getProviderName() {
    return providerName;
  }

  /**
   * This instance is equal to all instances of {@code MfaConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof MfaConfig
        && equalTo((MfaConfig) another);
  }

  private boolean equalTo(MfaConfig another) {
    return Objects.equals(enabled, another.enabled)
        && Objects.equals(providerName, another.providerName);
  }

  /**
   * Computes a hash code from attributes: {@code enabled}, {@code providerName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(enabled);
    h += (h << 5) + Objects.hashCode(providerName);
    return h;
  }

  /**
   * Prints the immutable value {@code MfaConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MfaConfig{"
        + "enabled=" + enabled
        + ", providerName=" + providerName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._MfaConfig {
    Boolean enabled;
    String providerName;
    @JsonProperty("enabled")
    public void setEnabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
    }
    @JsonProperty("providerName")
    public void setProviderName(@Nullable String providerName) {
      this.providerName = providerName;
    }
    @Override
    public Boolean getEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public String getProviderName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static MfaConfig fromJson(Json json) {
    MfaConfig.Builder builder = MfaConfig.builder();
    if (json.enabled != null) {
      builder.enabled(json.enabled);
    }
    if (json.providerName != null) {
      builder.providerName(json.providerName);
    }
    return builder.build();
  }


  private static MfaConfig validate(MfaConfig instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link MfaConfig MfaConfig}.
   * @return A new MfaConfig builder
   */
  public static MfaConfig.Builder builder() {
    return new MfaConfig.Builder();
  }

  /**
   * Builds instances of type {@link MfaConfig MfaConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean enabled;
    private String providerName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MfaConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MfaConfig instance) {
      return from((_MfaConfig) instance);
    }

    /**
     * Copy abstract value type {@code _MfaConfig} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_MfaConfig instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean enabledValue = instance.getEnabled();
      if (enabledValue != null) {
        enabled(enabledValue);
      }
      String providerNameValue = instance.getProviderName();
      if (providerNameValue != null) {
        providerName(providerNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _MfaConfig#getEnabled() enabled} attribute.
     * @param enabled The value for enabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("enabled")
    public final Builder enabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    /**
     * Initializes the value for the {@link _MfaConfig#getProviderName() providerName} attribute.
     * @param providerName The value for providerName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("providerName")
    public final Builder providerName(@Nullable String providerName) {
      this.providerName = providerName;
      return this;
    }

    /**
     * Builds a new {@link MfaConfig MfaConfig}.
     * @return An immutable instance of MfaConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public MfaConfig build() {
      return MfaConfig.validate(new MfaConfig(this));
    }
  }
}
