package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The payload for the identity zone saml configuration
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_SamlConfiguration"})
public final class SamlConfiguration extends org.cloudfoundry.uaa.identityzones._SamlConfiguration {
  private final @Nullable String activeKeyId;
  private final @Nullable Boolean assertionSigned;
  private final @Nullable Integer assertionTimeToLive;
  private final @Nullable String certificate;
  private final @Nullable Boolean disableInResponseToCheck;
  private final @Nullable String entityId;
  private final @Nullable Map<String, Key> keys;
  private final @Nullable String privateKey;
  private final @Nullable String privateKeyPassword;
  private final @Nullable Boolean requestSigned;
  private final @Nullable Boolean wantAssertionSigned;
  private final @Nullable Boolean wantPartnerAuthenticationRequestSigned;

  private SamlConfiguration(SamlConfiguration.Builder builder) {
    this.activeKeyId = builder.activeKeyId;
    this.assertionSigned = builder.assertionSigned;
    this.assertionTimeToLive = builder.assertionTimeToLive;
    this.certificate = builder.certificate;
    this.disableInResponseToCheck = builder.disableInResponseToCheck;
    this.entityId = builder.entityId;
    this.keys = builder.keys == null ? null : createUnmodifiableMap(false, false, builder.keys);
    this.privateKey = builder.privateKey;
    this.privateKeyPassword = builder.privateKeyPassword;
    this.requestSigned = builder.requestSigned;
    this.wantAssertionSigned = builder.wantAssertionSigned;
    this.wantPartnerAuthenticationRequestSigned = builder.wantPartnerAuthenticationRequestSigned;
  }

  /**
   * The active key id
   */
  @JsonProperty("activeKeyId")
  @Override
  public @Nullable String getActiveKeyId() {
    return activeKeyId;
  }

  /**
   * If true, the SAML provider will sign all assertions.
   */
  @JsonProperty("assertionSigned")
  @Override
  public @Nullable Boolean getAssertionSigned() {
    return assertionSigned;
  }

  /**
   * The lifetime of a SAML assertion in seconds.
   */
  @JsonProperty("assertionTimeToLiveSeconds")
  @Override
  public @Nullable Integer getAssertionTimeToLive() {
    return assertionTimeToLive;
  }

  /**
   * Exposed SAML metadata property. The certificate used to sign all communications.
   */
  @JsonProperty("certificate")
  @Override
  public @Nullable String getCertificate() {
    return certificate;
  }

  /**
   * If true, this zone will not validate the InResponseToField part of an incoming IDP assertion.
   */
  @JsonProperty("disableInResponseToCheck")
  @Override
  public @Nullable Boolean getDisableInResponseToCheck() {
    return disableInResponseToCheck;
  }

  /**
   * Unique ID of the SAML2 entity.
   */
  @JsonProperty("entityID")
  @Override
  public @Nullable String getEntityId() {
    return entityId;
  }

  /**
   * The keys
   */
  @JsonProperty("keys")
  @Override
  public @Nullable Map<String, Key> getKeys() {
    return keys;
  }

  /**
   * Exposed SAML metadata property. The SAML provider’s private key.
   */
  @JsonProperty("privateKey")
  @Override
  public @Nullable String getPrivateKey() {
    return privateKey;
  }

  /**
   * Exposed SAML metadata property. The SAML provider’s private key password. Reserved for future use.
   */
  @JsonProperty("privateKeyPassword")
  @Override
  public @Nullable String getPrivateKeyPassword() {
    return privateKeyPassword;
  }

  /**
   * Exposed SAML metadata property. If true, the service provider will sign all outgoing authentication requests.
   */
  @JsonProperty("requestSigned")
  @Override
  public @Nullable Boolean getRequestSigned() {
    return requestSigned;
  }

  /**
   * Exposed SAML metadata property. If true, all assertions received by the SAML provider must be signed.
   */
  @JsonProperty("wantAssertionSigned")
  @Override
  public @Nullable Boolean getWantAssertionSigned() {
    return wantAssertionSigned;
  }

  /**
   * If true, the authentication request from the partner service provider must be signed.
   */
  @JsonProperty("wantAuthnRequestSigned")
  @Override
  public @Nullable Boolean getWantPartnerAuthenticationRequestSigned() {
    return wantPartnerAuthenticationRequestSigned;
  }

  /**
   * This instance is equal to all instances of {@code SamlConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SamlConfiguration
        && equalTo((SamlConfiguration) another);
  }

  private boolean equalTo(SamlConfiguration another) {
    return Objects.equals(activeKeyId, another.activeKeyId)
        && Objects.equals(assertionSigned, another.assertionSigned)
        && Objects.equals(assertionTimeToLive, another.assertionTimeToLive)
        && Objects.equals(certificate, another.certificate)
        && Objects.equals(disableInResponseToCheck, another.disableInResponseToCheck)
        && Objects.equals(entityId, another.entityId)
        && Objects.equals(keys, another.keys)
        && Objects.equals(privateKey, another.privateKey)
        && Objects.equals(privateKeyPassword, another.privateKeyPassword)
        && Objects.equals(requestSigned, another.requestSigned)
        && Objects.equals(wantAssertionSigned, another.wantAssertionSigned)
        && Objects.equals(wantPartnerAuthenticationRequestSigned, another.wantPartnerAuthenticationRequestSigned);
  }

  /**
   * Computes a hash code from attributes: {@code activeKeyId}, {@code assertionSigned}, {@code assertionTimeToLive}, {@code certificate}, {@code disableInResponseToCheck}, {@code entityId}, {@code keys}, {@code privateKey}, {@code privateKeyPassword}, {@code requestSigned}, {@code wantAssertionSigned}, {@code wantPartnerAuthenticationRequestSigned}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(activeKeyId);
    h += (h << 5) + Objects.hashCode(assertionSigned);
    h += (h << 5) + Objects.hashCode(assertionTimeToLive);
    h += (h << 5) + Objects.hashCode(certificate);
    h += (h << 5) + Objects.hashCode(disableInResponseToCheck);
    h += (h << 5) + Objects.hashCode(entityId);
    h += (h << 5) + Objects.hashCode(keys);
    h += (h << 5) + Objects.hashCode(privateKey);
    h += (h << 5) + Objects.hashCode(privateKeyPassword);
    h += (h << 5) + Objects.hashCode(requestSigned);
    h += (h << 5) + Objects.hashCode(wantAssertionSigned);
    h += (h << 5) + Objects.hashCode(wantPartnerAuthenticationRequestSigned);
    return h;
  }

  /**
   * Prints the immutable value {@code SamlConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SamlConfiguration{"
        + "activeKeyId=" + activeKeyId
        + ", assertionSigned=" + assertionSigned
        + ", assertionTimeToLive=" + assertionTimeToLive
        + ", certificate=" + certificate
        + ", disableInResponseToCheck=" + disableInResponseToCheck
        + ", entityId=" + entityId
        + ", keys=" + keys
        + ", privateKey=" + privateKey
        + ", privateKeyPassword=" + privateKeyPassword
        + ", requestSigned=" + requestSigned
        + ", wantAssertionSigned=" + wantAssertionSigned
        + ", wantPartnerAuthenticationRequestSigned=" + wantPartnerAuthenticationRequestSigned
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._SamlConfiguration {
    String activeKeyId;
    Boolean assertionSigned;
    Integer assertionTimeToLive;
    String certificate;
    Boolean disableInResponseToCheck;
    String entityId;
    Map<String, Key> keys = null;
    String privateKey;
    String privateKeyPassword;
    Boolean requestSigned;
    Boolean wantAssertionSigned;
    Boolean wantPartnerAuthenticationRequestSigned;
    @JsonProperty("activeKeyId")
    public void setActiveKeyId(@Nullable String activeKeyId) {
      this.activeKeyId = activeKeyId;
    }
    @JsonProperty("assertionSigned")
    public void setAssertionSigned(@Nullable Boolean assertionSigned) {
      this.assertionSigned = assertionSigned;
    }
    @JsonProperty("assertionTimeToLiveSeconds")
    public void setAssertionTimeToLive(@Nullable Integer assertionTimeToLive) {
      this.assertionTimeToLive = assertionTimeToLive;
    }
    @JsonProperty("certificate")
    public void setCertificate(@Nullable String certificate) {
      this.certificate = certificate;
    }
    @JsonProperty("disableInResponseToCheck")
    public void setDisableInResponseToCheck(@Nullable Boolean disableInResponseToCheck) {
      this.disableInResponseToCheck = disableInResponseToCheck;
    }
    @JsonProperty("entityID")
    public void setEntityId(@Nullable String entityId) {
      this.entityId = entityId;
    }
    @JsonProperty("keys")
    public void setKeys(@Nullable Map<String, Key> keys) {
      this.keys = keys;
    }
    @JsonProperty("privateKey")
    public void setPrivateKey(@Nullable String privateKey) {
      this.privateKey = privateKey;
    }
    @JsonProperty("privateKeyPassword")
    public void setPrivateKeyPassword(@Nullable String privateKeyPassword) {
      this.privateKeyPassword = privateKeyPassword;
    }
    @JsonProperty("requestSigned")
    public void setRequestSigned(@Nullable Boolean requestSigned) {
      this.requestSigned = requestSigned;
    }
    @JsonProperty("wantAssertionSigned")
    public void setWantAssertionSigned(@Nullable Boolean wantAssertionSigned) {
      this.wantAssertionSigned = wantAssertionSigned;
    }
    @JsonProperty("wantAuthnRequestSigned")
    public void setWantPartnerAuthenticationRequestSigned(@Nullable Boolean wantPartnerAuthenticationRequestSigned) {
      this.wantPartnerAuthenticationRequestSigned = wantPartnerAuthenticationRequestSigned;
    }
    @Override
    public String getActiveKeyId() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getAssertionSigned() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getAssertionTimeToLive() { throw new UnsupportedOperationException(); }
    @Override
    public String getCertificate() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getDisableInResponseToCheck() { throw new UnsupportedOperationException(); }
    @Override
    public String getEntityId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Key> getKeys() { throw new UnsupportedOperationException(); }
    @Override
    public String getPrivateKey() { throw new UnsupportedOperationException(); }
    @Override
    public String getPrivateKeyPassword() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getRequestSigned() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getWantAssertionSigned() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getWantPartnerAuthenticationRequestSigned() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static SamlConfiguration fromJson(Json json) {
    SamlConfiguration.Builder builder = SamlConfiguration.builder();
    if (json.activeKeyId != null) {
      builder.activeKeyId(json.activeKeyId);
    }
    if (json.assertionSigned != null) {
      builder.assertionSigned(json.assertionSigned);
    }
    if (json.assertionTimeToLive != null) {
      builder.assertionTimeToLive(json.assertionTimeToLive);
    }
    if (json.certificate != null) {
      builder.certificate(json.certificate);
    }
    if (json.disableInResponseToCheck != null) {
      builder.disableInResponseToCheck(json.disableInResponseToCheck);
    }
    if (json.entityId != null) {
      builder.entityId(json.entityId);
    }
    if (json.keys != null) {
      builder.putAllKeys(json.keys);
    }
    if (json.privateKey != null) {
      builder.privateKey(json.privateKey);
    }
    if (json.privateKeyPassword != null) {
      builder.privateKeyPassword(json.privateKeyPassword);
    }
    if (json.requestSigned != null) {
      builder.requestSigned(json.requestSigned);
    }
    if (json.wantAssertionSigned != null) {
      builder.wantAssertionSigned(json.wantAssertionSigned);
    }
    if (json.wantPartnerAuthenticationRequestSigned != null) {
      builder.wantPartnerAuthenticationRequestSigned(json.wantPartnerAuthenticationRequestSigned);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link SamlConfiguration SamlConfiguration}.
   * @return A new SamlConfiguration builder
   */
  public static SamlConfiguration.Builder builder() {
    return new SamlConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link SamlConfiguration SamlConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String activeKeyId;
    private Boolean assertionSigned;
    private Integer assertionTimeToLive;
    private String certificate;
    private Boolean disableInResponseToCheck;
    private String entityId;
    private Map<String, Key> keys = null;
    private String privateKey;
    private String privateKeyPassword;
    private Boolean requestSigned;
    private Boolean wantAssertionSigned;
    private Boolean wantPartnerAuthenticationRequestSigned;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SamlConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SamlConfiguration instance) {
      return from((_SamlConfiguration) instance);
    }

    /**
     * Copy abstract value type {@code _SamlConfiguration} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SamlConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      String activeKeyIdValue = instance.getActiveKeyId();
      if (activeKeyIdValue != null) {
        activeKeyId(activeKeyIdValue);
      }
      Boolean assertionSignedValue = instance.getAssertionSigned();
      if (assertionSignedValue != null) {
        assertionSigned(assertionSignedValue);
      }
      Integer assertionTimeToLiveValue = instance.getAssertionTimeToLive();
      if (assertionTimeToLiveValue != null) {
        assertionTimeToLive(assertionTimeToLiveValue);
      }
      String certificateValue = instance.getCertificate();
      if (certificateValue != null) {
        certificate(certificateValue);
      }
      Boolean disableInResponseToCheckValue = instance.getDisableInResponseToCheck();
      if (disableInResponseToCheckValue != null) {
        disableInResponseToCheck(disableInResponseToCheckValue);
      }
      String entityIdValue = instance.getEntityId();
      if (entityIdValue != null) {
        entityId(entityIdValue);
      }
      Map<String, Key> keysValue = instance.getKeys();
      if (keysValue != null) {
        putAllKeys(keysValue);
      }
      String privateKeyValue = instance.getPrivateKey();
      if (privateKeyValue != null) {
        privateKey(privateKeyValue);
      }
      String privateKeyPasswordValue = instance.getPrivateKeyPassword();
      if (privateKeyPasswordValue != null) {
        privateKeyPassword(privateKeyPasswordValue);
      }
      Boolean requestSignedValue = instance.getRequestSigned();
      if (requestSignedValue != null) {
        requestSigned(requestSignedValue);
      }
      Boolean wantAssertionSignedValue = instance.getWantAssertionSigned();
      if (wantAssertionSignedValue != null) {
        wantAssertionSigned(wantAssertionSignedValue);
      }
      Boolean wantPartnerAuthenticationRequestSignedValue = instance.getWantPartnerAuthenticationRequestSigned();
      if (wantPartnerAuthenticationRequestSignedValue != null) {
        wantPartnerAuthenticationRequestSigned(wantPartnerAuthenticationRequestSignedValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getActiveKeyId() activeKeyId} attribute.
     * @param activeKeyId The value for activeKeyId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("activeKeyId")
    public final Builder activeKeyId(@Nullable String activeKeyId) {
      this.activeKeyId = activeKeyId;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getAssertionSigned() assertionSigned} attribute.
     * @param assertionSigned The value for assertionSigned (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("assertionSigned")
    public final Builder assertionSigned(@Nullable Boolean assertionSigned) {
      this.assertionSigned = assertionSigned;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getAssertionTimeToLive() assertionTimeToLive} attribute.
     * @param assertionTimeToLive The value for assertionTimeToLive (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("assertionTimeToLiveSeconds")
    public final Builder assertionTimeToLive(@Nullable Integer assertionTimeToLive) {
      this.assertionTimeToLive = assertionTimeToLive;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getCertificate() certificate} attribute.
     * @param certificate The value for certificate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("certificate")
    public final Builder certificate(@Nullable String certificate) {
      this.certificate = certificate;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getDisableInResponseToCheck() disableInResponseToCheck} attribute.
     * @param disableInResponseToCheck The value for disableInResponseToCheck (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("disableInResponseToCheck")
    public final Builder disableInResponseToCheck(@Nullable Boolean disableInResponseToCheck) {
      this.disableInResponseToCheck = disableInResponseToCheck;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getEntityId() entityId} attribute.
     * @param entityId The value for entityId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("entityID")
    public final Builder entityId(@Nullable String entityId) {
      this.entityId = entityId;
      return this;
    }

    /**
     * Put one entry to the {@link _SamlConfiguration#getKeys() keys} map.
     * @param key The key in the keys map
     * @param value The associated value in the keys map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(String key, Key value) {
      if (this.keys == null) {
        this.keys = new LinkedHashMap<String, Key>();
      }
      this.keys.put(
          Objects.requireNonNull(key, "keys key"),
          Objects.requireNonNull(value, "keys value"));
      return this;
    }

    /**
     * Put one entry to the {@link _SamlConfiguration#getKeys() keys} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(Map.Entry<String, ? extends Key> entry) {
      if (this.keys == null) {
        this.keys = new LinkedHashMap<String, Key>();
      }
      String k = entry.getKey();
      Key v = entry.getValue();
      this.keys.put(
          Objects.requireNonNull(k, "keys key"),
          Objects.requireNonNull(v, "keys value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _SamlConfiguration#getKeys() keys} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param keys The entries that will be added to the keys map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("keys")
    public final Builder keys(@Nullable Map<String, ? extends Key> keys) {
      if (keys == null) {
        this.keys = null;
        return this;
      }
      this.keys = new LinkedHashMap<String, Key>();
      return putAllKeys(keys);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _SamlConfiguration#getKeys() keys} map. Nulls are not permitted
     * @param keys The entries that will be added to the keys map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllKeys(Map<String, ? extends Key> keys) {
      if (this.keys == null) {
        this.keys = new LinkedHashMap<String, Key>();
      }
      for (Map.Entry<String, ? extends Key> entry : keys.entrySet()) {
        String k = entry.getKey();
        Key v = entry.getValue();
        this.keys.put(
            Objects.requireNonNull(k, "keys key"),
            Objects.requireNonNull(v, "keys value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getPrivateKey() privateKey} attribute.
     * @param privateKey The value for privateKey (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("privateKey")
    public final Builder privateKey(@Nullable String privateKey) {
      this.privateKey = privateKey;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getPrivateKeyPassword() privateKeyPassword} attribute.
     * @param privateKeyPassword The value for privateKeyPassword (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("privateKeyPassword")
    public final Builder privateKeyPassword(@Nullable String privateKeyPassword) {
      this.privateKeyPassword = privateKeyPassword;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getRequestSigned() requestSigned} attribute.
     * @param requestSigned The value for requestSigned (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("requestSigned")
    public final Builder requestSigned(@Nullable Boolean requestSigned) {
      this.requestSigned = requestSigned;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getWantAssertionSigned() wantAssertionSigned} attribute.
     * @param wantAssertionSigned The value for wantAssertionSigned (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("wantAssertionSigned")
    public final Builder wantAssertionSigned(@Nullable Boolean wantAssertionSigned) {
      this.wantAssertionSigned = wantAssertionSigned;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getWantPartnerAuthenticationRequestSigned() wantPartnerAuthenticationRequestSigned} attribute.
     * @param wantPartnerAuthenticationRequestSigned The value for wantPartnerAuthenticationRequestSigned (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("wantAuthnRequestSigned")
    public final Builder wantPartnerAuthenticationRequestSigned(@Nullable Boolean wantPartnerAuthenticationRequestSigned) {
      this.wantPartnerAuthenticationRequestSigned = wantPartnerAuthenticationRequestSigned;
      return this;
    }

    /**
     * Builds a new {@link SamlConfiguration SamlConfiguration}.
     * @return An immutable instance of SamlConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SamlConfiguration build() {
      return new SamlConfiguration(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
