package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List all Routes for the Application operation
 */
@Generated(from = "_ListApplicationRoutesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListApplicationRoutesRequest
    extends org.cloudfoundry.client.v2.applications._ListApplicationRoutesRequest {
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;
  private final String applicationId;
  private final @Nullable List<String> domainIds;
  private final @Nullable List<String> hosts;
  private final @Nullable List<String> paths;
  private final @Nullable List<Integer> ports;

  private ListApplicationRoutesRequest(ListApplicationRoutesRequest.Builder builder) {
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
    this.applicationId = builder.applicationId;
    this.domainIds = builder.domainIds == null ? null : createUnmodifiableList(true, builder.domainIds);
    this.hosts = builder.hosts == null ? null : createUnmodifiableList(true, builder.hosts);
    this.paths = builder.paths == null ? null : createUnmodifiableList(true, builder.paths);
    this.ports = builder.ports == null ? null : createUnmodifiableList(true, builder.ports);
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The domain ids
   */
  @Override
  public @Nullable List<String> getDomainIds() {
    return domainIds;
  }

  /**
   * The hosts
   */
  @Override
  public @Nullable List<String> getHosts() {
    return hosts;
  }

  /**
   * The paths
   */
  @Override
  public @Nullable List<String> getPaths() {
    return paths;
  }

  /**
   * The ports
   */
  @Override
  public @Nullable List<Integer> getPorts() {
    return ports;
  }

  /**
   * This instance is equal to all instances of {@code ListApplicationRoutesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListApplicationRoutesRequest
        && equalTo((ListApplicationRoutesRequest) another);
  }

  private boolean equalTo(ListApplicationRoutesRequest another) {
    return Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage)
        && applicationId.equals(another.applicationId)
        && Objects.equals(domainIds, another.domainIds)
        && Objects.equals(hosts, another.hosts)
        && Objects.equals(paths, another.paths)
        && Objects.equals(ports, another.ports);
  }

  /**
   * Computes a hash code from attributes: {@code orderDirection}, {@code page}, {@code resultsPerPage}, {@code applicationId}, {@code domainIds}, {@code hosts}, {@code paths}, {@code ports}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + Objects.hashCode(domainIds);
    h += (h << 5) + Objects.hashCode(hosts);
    h += (h << 5) + Objects.hashCode(paths);
    h += (h << 5) + Objects.hashCode(ports);
    return h;
  }

  /**
   * Prints the immutable value {@code ListApplicationRoutesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListApplicationRoutesRequest{"
        + "orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + ", applicationId=" + applicationId
        + ", domainIds=" + domainIds
        + ", hosts=" + hosts
        + ", paths=" + paths
        + ", ports=" + ports
        + "}";
  }

  /**
   * Creates a builder for {@link ListApplicationRoutesRequest ListApplicationRoutesRequest}.
   * <pre>
   * ListApplicationRoutesRequest.builder()
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListApplicationRoutesRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListApplicationRoutesRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListApplicationRoutesRequest#getResultsPerPage() resultsPerPage}
   *    .applicationId(String) // required {@link ListApplicationRoutesRequest#getApplicationId() applicationId}
   *    .domainIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListApplicationRoutesRequest#getDomainIds() domainIds}
   *    .hosts(List&amp;lt;String&amp;gt; | null) // nullable {@link ListApplicationRoutesRequest#getHosts() hosts}
   *    .paths(List&amp;lt;String&amp;gt; | null) // nullable {@link ListApplicationRoutesRequest#getPaths() paths}
   *    .ports(List&amp;lt;Integer&amp;gt; | null) // nullable {@link ListApplicationRoutesRequest#getPorts() ports}
   *    .build();
   * </pre>
   * @return A new ListApplicationRoutesRequest builder
   */
  public static ListApplicationRoutesRequest.Builder builder() {
    return new ListApplicationRoutesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListApplicationRoutesRequest ListApplicationRoutesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListApplicationRoutesRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;
    private String applicationId;
    private List<String> domainIds = null;
    private List<String> hosts = null;
    private List<String> paths = null;
    private List<Integer> ports = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListApplicationRoutesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListApplicationRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListApplicationRoutesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListApplicationRoutesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.applications._ListApplicationRoutesRequest) {
        org.cloudfoundry.client.v2.applications._ListApplicationRoutesRequest instance = (org.cloudfoundry.client.v2.applications._ListApplicationRoutesRequest) object;
        List<String> domainIdsValue = instance.getDomainIds();
        if (domainIdsValue != null) {
          addAllDomainIds(domainIdsValue);
        }
        applicationId(instance.getApplicationId());
        List<Integer> portsValue = instance.getPorts();
        if (portsValue != null) {
          addAllPorts(portsValue);
        }
        List<String> hostsValue = instance.getHosts();
        if (hostsValue != null) {
          addAllHosts(hostsValue);
        }
        List<String> pathsValue = instance.getPaths();
        if (pathsValue != null) {
          addAllPaths(pathsValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListApplicationRoutesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationRoutesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationRoutesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationRoutesRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationRoutesRequest#getDomainIds() domainIds} list.
     * @param element A domainIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String element) {
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationRoutesRequest#getDomainIds() domainIds} list.
     * @param elements An array of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainIds(String... elements) {
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationRoutesRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.domainIds = null;
        return this;
      }
      this.domainIds = new ArrayList<String>();
      return addAllDomainIds(elements);
    }

    /**
     * Adds elements to {@link ListApplicationRoutesRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomainIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "domainIds element");
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationRoutesRequest#getHosts() hosts} list.
     * @param element A hosts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(String element) {
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationRoutesRequest#getHosts() hosts} list.
     * @param elements An array of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hosts(String... elements) {
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationRoutesRequest#getHosts() hosts} list.
     * @param elements An iterable of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hosts(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.hosts = null;
        return this;
      }
      this.hosts = new ArrayList<String>();
      return addAllHosts(elements);
    }

    /**
     * Adds elements to {@link ListApplicationRoutesRequest#getHosts() hosts} list.
     * @param elements An iterable of hosts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllHosts(Iterable<String> elements) {
      Objects.requireNonNull(elements, "hosts element");
      if (this.hosts == null) {
        this.hosts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.hosts.add(Objects.requireNonNull(element, "hosts element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationRoutesRequest#getPaths() paths} list.
     * @param element A paths element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(String element) {
      if (this.paths == null) {
        this.paths = new ArrayList<String>();
      }
      this.paths.add(Objects.requireNonNull(element, "paths element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationRoutesRequest#getPaths() paths} list.
     * @param elements An array of paths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder paths(String... elements) {
      if (this.paths == null) {
        this.paths = new ArrayList<String>();
      }
      for (String element : elements) {
        this.paths.add(Objects.requireNonNull(element, "paths element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationRoutesRequest#getPaths() paths} list.
     * @param elements An iterable of paths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder paths(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.paths = null;
        return this;
      }
      this.paths = new ArrayList<String>();
      return addAllPaths(elements);
    }

    /**
     * Adds elements to {@link ListApplicationRoutesRequest#getPaths() paths} list.
     * @param elements An iterable of paths elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPaths(Iterable<String> elements) {
      Objects.requireNonNull(elements, "paths element");
      if (this.paths == null) {
        this.paths = new ArrayList<String>();
      }
      for (String element : elements) {
        this.paths.add(Objects.requireNonNull(element, "paths element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationRoutesRequest#getPorts() ports} list.
     * @param element A ports element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(int element) {
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      this.ports.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationRoutesRequest#getPorts() ports} list.
     * @param elements An array of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ports(int... elements) {
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      for (int element : elements) {
        this.ports.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationRoutesRequest#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ports(@Nullable Iterable<Integer> elements) {
      if (elements == null) {
        this.ports = null;
        return this;
      }
      this.ports = new ArrayList<Integer>();
      return addAllPorts(elements);
    }

    /**
     * Adds elements to {@link ListApplicationRoutesRequest#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPorts(Iterable<Integer> elements) {
      Objects.requireNonNull(elements, "ports element");
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      for (int element : elements) {
        this.ports.add(Objects.requireNonNull(element, "ports element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListApplicationRoutesRequest ListApplicationRoutesRequest}.
     * @return An immutable instance of ListApplicationRoutesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListApplicationRoutesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListApplicationRoutesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build ListApplicationRoutesRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
