package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List all Apps operation
 */
@Generated(from = "_ListApplicationsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListApplicationsRequest
    extends org.cloudfoundry.client.v2.applications._ListApplicationsRequest {
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;
  private final @Nullable Boolean diego;
  private final @Nullable List<String> names;
  private final @Nullable List<String> organizationIds;
  private final @Nullable List<String> spaceIds;
  private final @Nullable List<String> stackIds;

  private ListApplicationsRequest(ListApplicationsRequest.Builder builder) {
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
    this.diego = builder.diego;
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
    this.organizationIds = builder.organizationIds == null ? null : createUnmodifiableList(true, builder.organizationIds);
    this.spaceIds = builder.spaceIds == null ? null : createUnmodifiableList(true, builder.spaceIds);
    this.stackIds = builder.stackIds == null ? null : createUnmodifiableList(true, builder.stackIds);
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * The diego flag
   */
  @Override
  public @Nullable Boolean getDiego() {
    return diego;
  }

  /**
   * The names
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * The organization ids
   */
  @Override
  public @Nullable List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The space ids
   */
  @Override
  public @Nullable List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * The stack ids
   */
  @Override
  public @Nullable List<String> getStackIds() {
    return stackIds;
  }

  /**
   * This instance is equal to all instances of {@code ListApplicationsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListApplicationsRequest
        && equalTo((ListApplicationsRequest) another);
  }

  private boolean equalTo(ListApplicationsRequest another) {
    return Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage)
        && Objects.equals(diego, another.diego)
        && Objects.equals(names, another.names)
        && Objects.equals(organizationIds, another.organizationIds)
        && Objects.equals(spaceIds, another.spaceIds)
        && Objects.equals(stackIds, another.stackIds);
  }

  /**
   * Computes a hash code from attributes: {@code orderDirection}, {@code page}, {@code resultsPerPage}, {@code diego}, {@code names}, {@code organizationIds}, {@code spaceIds}, {@code stackIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    h += (h << 5) + Objects.hashCode(diego);
    h += (h << 5) + Objects.hashCode(names);
    h += (h << 5) + Objects.hashCode(organizationIds);
    h += (h << 5) + Objects.hashCode(spaceIds);
    h += (h << 5) + Objects.hashCode(stackIds);
    return h;
  }

  /**
   * Prints the immutable value {@code ListApplicationsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListApplicationsRequest{"
        + "orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + ", diego=" + diego
        + ", names=" + names
        + ", organizationIds=" + organizationIds
        + ", spaceIds=" + spaceIds
        + ", stackIds=" + stackIds
        + "}";
  }

  /**
   * Creates a builder for {@link ListApplicationsRequest ListApplicationsRequest}.
   * <pre>
   * ListApplicationsRequest.builder()
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListApplicationsRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListApplicationsRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListApplicationsRequest#getResultsPerPage() resultsPerPage}
   *    .diego(Boolean | null) // nullable {@link ListApplicationsRequest#getDiego() diego}
   *    .names(List&amp;lt;String&amp;gt; | null) // nullable {@link ListApplicationsRequest#getNames() names}
   *    .organizationIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListApplicationsRequest#getOrganizationIds() organizationIds}
   *    .spaceIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListApplicationsRequest#getSpaceIds() spaceIds}
   *    .stackIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListApplicationsRequest#getStackIds() stackIds}
   *    .build();
   * </pre>
   * @return A new ListApplicationsRequest builder
   */
  public static ListApplicationsRequest.Builder builder() {
    return new ListApplicationsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListApplicationsRequest ListApplicationsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListApplicationsRequest", generator = "Immutables")
  public static final class Builder {
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;
    private Boolean diego;
    private List<String> names = null;
    private List<String> organizationIds = null;
    private List<String> spaceIds = null;
    private List<String> stackIds = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListApplicationsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListApplicationsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListApplicationsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListApplicationsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v2.applications._ListApplicationsRequest) {
        org.cloudfoundry.client.v2.applications._ListApplicationsRequest instance = (org.cloudfoundry.client.v2.applications._ListApplicationsRequest) object;
        Boolean diegoValue = instance.getDiego();
        if (diegoValue != null) {
          diego(diegoValue);
        }
        List<String> namesValue = instance.getNames();
        if (namesValue != null) {
          addAllNames(namesValue);
        }
        List<String> spaceIdsValue = instance.getSpaceIds();
        if (spaceIdsValue != null) {
          addAllSpaceIds(spaceIdsValue);
        }
        List<String> stackIdsValue = instance.getStackIds();
        if (stackIdsValue != null) {
          addAllStackIds(stackIdsValue);
        }
        List<String> organizationIdsValue = instance.getOrganizationIds();
        if (organizationIdsValue != null) {
          addAllOrganizationIds(organizationIdsValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListApplicationsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationsRequest#getDiego() diego} attribute.
     * @param diego The value for diego (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diego(@Nullable Boolean diego) {
      this.diego = diego;
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationsRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationsRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListApplicationsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationsRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.organizationIds = null;
        return this;
      }
      this.organizationIds = new ArrayList<String>();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListApplicationsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "organizationIds element");
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationsRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationsRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.spaceIds = null;
        return this;
      }
      this.spaceIds = new ArrayList<String>();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListApplicationsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "spaceIds element");
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListApplicationsRequest#getStackIds() stackIds} list.
     * @param element A stackIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stackId(String element) {
      if (this.stackIds == null) {
        this.stackIds = new ArrayList<String>();
      }
      this.stackIds.add(Objects.requireNonNull(element, "stackIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListApplicationsRequest#getStackIds() stackIds} list.
     * @param elements An array of stackIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stackIds(String... elements) {
      if (this.stackIds == null) {
        this.stackIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.stackIds.add(Objects.requireNonNull(element, "stackIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListApplicationsRequest#getStackIds() stackIds} list.
     * @param elements An iterable of stackIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stackIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.stackIds = null;
        return this;
      }
      this.stackIds = new ArrayList<String>();
      return addAllStackIds(elements);
    }

    /**
     * Adds elements to {@link ListApplicationsRequest#getStackIds() stackIds} list.
     * @param elements An iterable of stackIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStackIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "stackIds element");
      if (this.stackIds == null) {
        this.stackIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.stackIds.add(Objects.requireNonNull(element, "stackIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListApplicationsRequest ListApplicationsRequest}.
     * @return An immutable instance of ListApplicationsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListApplicationsRequest build() {
      return new ListApplicationsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
