package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _NetInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code NetInfo.builder()}.
 */
@Generated(from = "_NetInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class NetInfo extends org.cloudfoundry.client.v2.applications._NetInfo {
  private final @Nullable String address;
  private final @Nullable List<NetInfoPorts> ports;

  private NetInfo(NetInfo.Builder builder) {
    this.address = builder.address;
    this.ports = builder.ports == null ? null : createUnmodifiableList(true, builder.ports);
  }

  /**
   * The address
   */
  @JsonProperty("address")
  @Override
  public @Nullable String getAddress() {
    return address;
  }

  /**
   * The ports
   */
  @JsonProperty("ports")
  @Override
  public @Nullable List<NetInfoPorts> getPorts() {
    return ports;
  }

  /**
   * This instance is equal to all instances of {@code NetInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof NetInfo
        && equalTo((NetInfo) another);
  }

  private boolean equalTo(NetInfo another) {
    return Objects.equals(address, another.address)
        && Objects.equals(ports, another.ports);
  }

  /**
   * Computes a hash code from attributes: {@code address}, {@code ports}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(address);
    h += (h << 5) + Objects.hashCode(ports);
    return h;
  }

  /**
   * Prints the immutable value {@code NetInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NetInfo{"
        + "address=" + address
        + ", ports=" + ports
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_NetInfo", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.applications._NetInfo {
    String address;
    List<NetInfoPorts> ports = null;
    @JsonProperty("address")
    public void setAddress(@Nullable String address) {
      this.address = address;
    }
    @JsonProperty("ports")
    public void setPorts(@Nullable List<NetInfoPorts> ports) {
      this.ports = ports;
    }
    @Override
    public String getAddress() { throw new UnsupportedOperationException(); }
    @Override
    public List<NetInfoPorts> getPorts() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static NetInfo fromJson(Json json) {
    NetInfo.Builder builder = NetInfo.builder();
    if (json.address != null) {
      builder.address(json.address);
    }
    if (json.ports != null) {
      builder.addAllPorts(json.ports);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link NetInfo NetInfo}.
   * <pre>
   * NetInfo.builder()
   *    .address(String | null) // nullable {@link NetInfo#getAddress() address}
   *    .ports(List&amp;lt;NetInfoPorts&amp;gt; | null) // nullable {@link NetInfo#getPorts() ports}
   *    .build();
   * </pre>
   * @return A new NetInfo builder
   */
  public static NetInfo.Builder builder() {
    return new NetInfo.Builder();
  }

  /**
   * Builds instances of type {@link NetInfo NetInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_NetInfo", generator = "Immutables")
  public static final class Builder {
    private String address;
    private List<NetInfoPorts> ports = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NetInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(NetInfo instance) {
      return from((_NetInfo) instance);
    }

    /**
     * Copy abstract value type {@code _NetInfo} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_NetInfo instance) {
      Objects.requireNonNull(instance, "instance");
      String addressValue = instance.getAddress();
      if (addressValue != null) {
        address(addressValue);
      }
      List<NetInfoPorts> portsValue = instance.getPorts();
      if (portsValue != null) {
        addAllPorts(portsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link NetInfo#getAddress() address} attribute.
     * @param address The value for address (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("address")
    public final Builder address(@Nullable String address) {
      this.address = address;
      return this;
    }

    /**
     * Adds one element to {@link NetInfo#getPorts() ports} list.
     * @param element A ports element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(NetInfoPorts element) {
      if (this.ports == null) {
        this.ports = new ArrayList<NetInfoPorts>();
      }
      this.ports.add(Objects.requireNonNull(element, "ports element"));
      return this;
    }

    /**
     * Adds elements to {@link NetInfo#getPorts() ports} list.
     * @param elements An array of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ports(NetInfoPorts... elements) {
      if (this.ports == null) {
        this.ports = new ArrayList<NetInfoPorts>();
      }
      for (NetInfoPorts element : elements) {
        this.ports.add(Objects.requireNonNull(element, "ports element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NetInfo#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ports")
    public final Builder ports(@Nullable Iterable<? extends NetInfoPorts> elements) {
      if (elements == null) {
        this.ports = null;
        return this;
      }
      this.ports = new ArrayList<NetInfoPorts>();
      return addAllPorts(elements);
    }

    /**
     * Adds elements to {@link NetInfo#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPorts(Iterable<? extends NetInfoPorts> elements) {
      Objects.requireNonNull(elements, "ports element");
      if (this.ports == null) {
        this.ports = new ArrayList<NetInfoPorts>();
      }
      for (NetInfoPorts element : elements) {
        this.ports.add(Objects.requireNonNull(element, "ports element"));
      }
      return this;
    }

    /**
     * Builds a new {@link NetInfo NetInfo}.
     * @return An immutable instance of NetInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public NetInfo build() {
      return new NetInfo(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
