package org.cloudfoundry.client.v2.domains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The domain
 */
@Generated(from = "_Domain", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Domain extends org.cloudfoundry.client.v2.domains._Domain {
  private final @Nullable String id;
  private final @Nullable Boolean internal;
  private final @Nullable String name;
  private final @Nullable String owningOrganizationId;
  private final @Nullable String routerGroupId;
  private final @Nullable String routerGroupType;

  private Domain(Domain.Builder builder) {
    this.id = builder.id;
    this.internal = builder.internal;
    this.name = builder.name;
    this.owningOrganizationId = builder.owningOrganizationId;
    this.routerGroupId = builder.routerGroupId;
    this.routerGroupType = builder.routerGroupType;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * Whether this is an internal domain
   */
  @JsonProperty("internal")
  @Override
  public @Nullable Boolean getInternal() {
    return internal;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The owning organization id
   */
  @JsonProperty("owning_organization_guid")
  @Override
  public @Nullable String getOwningOrganizationId() {
    return owningOrganizationId;
  }

  /**
   * The router group id
   */
  @JsonProperty("router_group_guid")
  @Override
  public @Nullable String getRouterGroupId() {
    return routerGroupId;
  }

  /**
   * The router group type
   */
  @JsonProperty("router_group_type")
  @Override
  public @Nullable String getRouterGroupType() {
    return routerGroupType;
  }

  /**
   * This instance is equal to all instances of {@code Domain} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Domain
        && equalTo((Domain) another);
  }

  private boolean equalTo(Domain another) {
    return Objects.equals(id, another.id)
        && Objects.equals(internal, another.internal)
        && Objects.equals(name, another.name)
        && Objects.equals(owningOrganizationId, another.owningOrganizationId)
        && Objects.equals(routerGroupId, another.routerGroupId)
        && Objects.equals(routerGroupType, another.routerGroupType);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code internal}, {@code name}, {@code owningOrganizationId}, {@code routerGroupId}, {@code routerGroupType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(internal);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(owningOrganizationId);
    h += (h << 5) + Objects.hashCode(routerGroupId);
    h += (h << 5) + Objects.hashCode(routerGroupType);
    return h;
  }

  /**
   * Prints the immutable value {@code Domain} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Domain{"
        + "id=" + id
        + ", internal=" + internal
        + ", name=" + name
        + ", owningOrganizationId=" + owningOrganizationId
        + ", routerGroupId=" + routerGroupId
        + ", routerGroupType=" + routerGroupType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Domain", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.domains._Domain {
    String id;
    Boolean internal;
    String name;
    String owningOrganizationId;
    String routerGroupId;
    String routerGroupType;
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("internal")
    public void setInternal(@Nullable Boolean internal) {
      this.internal = internal;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("owning_organization_guid")
    public void setOwningOrganizationId(@Nullable String owningOrganizationId) {
      this.owningOrganizationId = owningOrganizationId;
    }
    @JsonProperty("router_group_guid")
    public void setRouterGroupId(@Nullable String routerGroupId) {
      this.routerGroupId = routerGroupId;
    }
    @JsonProperty("router_group_type")
    public void setRouterGroupType(@Nullable String routerGroupType) {
      this.routerGroupType = routerGroupType;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getInternal() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getOwningOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouterGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouterGroupType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Domain fromJson(Json json) {
    Domain.Builder builder = Domain.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.internal != null) {
      builder.internal(json.internal);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.owningOrganizationId != null) {
      builder.owningOrganizationId(json.owningOrganizationId);
    }
    if (json.routerGroupId != null) {
      builder.routerGroupId(json.routerGroupId);
    }
    if (json.routerGroupType != null) {
      builder.routerGroupType(json.routerGroupType);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Domain Domain}.
   * <pre>
   * Domain.builder()
   *    .id(String | null) // nullable {@link Domain#getId() id}
   *    .internal(Boolean | null) // nullable {@link Domain#getInternal() internal}
   *    .name(String | null) // nullable {@link Domain#getName() name}
   *    .owningOrganizationId(String | null) // nullable {@link Domain#getOwningOrganizationId() owningOrganizationId}
   *    .routerGroupId(String | null) // nullable {@link Domain#getRouterGroupId() routerGroupId}
   *    .routerGroupType(String | null) // nullable {@link Domain#getRouterGroupType() routerGroupType}
   *    .build();
   * </pre>
   * @return A new Domain builder
   */
  public static Domain.Builder builder() {
    return new Domain.Builder();
  }

  /**
   * Builds instances of type {@link Domain Domain}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Domain", generator = "Immutables")
  public static final class Builder {
    private String id;
    private Boolean internal;
    private String name;
    private String owningOrganizationId;
    private String routerGroupId;
    private String routerGroupType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Domain} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Domain instance) {
      return from((_Domain) instance);
    }

    /**
     * Copy abstract value type {@code _Domain} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Domain instance) {
      Objects.requireNonNull(instance, "instance");
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      Boolean internalValue = instance.getInternal();
      if (internalValue != null) {
        internal(internalValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String owningOrganizationIdValue = instance.getOwningOrganizationId();
      if (owningOrganizationIdValue != null) {
        owningOrganizationId(owningOrganizationIdValue);
      }
      String routerGroupIdValue = instance.getRouterGroupId();
      if (routerGroupIdValue != null) {
        routerGroupId(routerGroupIdValue);
      }
      String routerGroupTypeValue = instance.getRouterGroupType();
      if (routerGroupTypeValue != null) {
        routerGroupType(routerGroupTypeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Domain#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Domain#getInternal() internal} attribute.
     * @param internal The value for internal (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("internal")
    public final Builder internal(@Nullable Boolean internal) {
      this.internal = internal;
      return this;
    }

    /**
     * Initializes the value for the {@link Domain#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Domain#getOwningOrganizationId() owningOrganizationId} attribute.
     * @param owningOrganizationId The value for owningOrganizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("owning_organization_guid")
    public final Builder owningOrganizationId(@Nullable String owningOrganizationId) {
      this.owningOrganizationId = owningOrganizationId;
      return this;
    }

    /**
     * Initializes the value for the {@link Domain#getRouterGroupId() routerGroupId} attribute.
     * @param routerGroupId The value for routerGroupId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("router_group_guid")
    public final Builder routerGroupId(@Nullable String routerGroupId) {
      this.routerGroupId = routerGroupId;
      return this;
    }

    /**
     * Initializes the value for the {@link Domain#getRouterGroupType() routerGroupType} attribute.
     * @param routerGroupType The value for routerGroupType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("router_group_type")
    public final Builder routerGroupType(@Nullable String routerGroupType) {
      this.routerGroupType = routerGroupType;
      return this;
    }

    /**
     * Builds a new {@link Domain Domain}.
     * @return An immutable instance of Domain
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Domain build() {
      return new Domain(this);
    }
  }
}
