package org.cloudfoundry.client.v2.organizationquotadefinitions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The entity response payload for the Quota Definition resource
 */
@Generated(from = "_OrganizationQuotaDefinitionEntity", generator = "Immutables")
@SuppressWarnings({"all", "deprecation"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class OrganizationQuotaDefinitionEntity
    extends org.cloudfoundry.client.v2.organizationquotadefinitions._OrganizationQuotaDefinitionEntity {
  private final @Nullable Integer applicationInstanceLimit;
  private final @Nullable Integer applicationTaskLimit;
  private final @Nullable Integer instanceMemoryLimit;
  private final @Nullable Integer memoryLimit;
  private final @Nullable String name;
  private final @Nullable Boolean nonBasicServicesAllowed;
  private final @Nullable Integer totalPrivateDomains;
  private final @Nullable Integer totalReservedRoutePorts;
  private final @Nullable Integer totalRoutes;
  private final @Nullable Integer totalServiceKeys;
  private final @Nullable Integer totalServices;
  private final @Nullable Boolean trialDatabaseAllowed;

  private OrganizationQuotaDefinitionEntity(OrganizationQuotaDefinitionEntity.Builder builder) {
    this.applicationInstanceLimit = builder.applicationInstanceLimit;
    this.applicationTaskLimit = builder.applicationTaskLimit;
    this.instanceMemoryLimit = builder.instanceMemoryLimit;
    this.memoryLimit = builder.memoryLimit;
    this.name = builder.name;
    this.nonBasicServicesAllowed = builder.nonBasicServicesAllowed;
    this.totalPrivateDomains = builder.totalPrivateDomains;
    this.totalReservedRoutePorts = builder.totalReservedRoutePorts;
    this.totalRoutes = builder.totalRoutes;
    this.totalServiceKeys = builder.totalServiceKeys;
    this.totalServices = builder.totalServices;
    this.trialDatabaseAllowed = builder.trialDatabaseAllowed;
  }

  /**
   * The application instance limit
   */
  @JsonProperty("app_instance_limit")
  @Override
  public @Nullable Integer getApplicationInstanceLimit() {
    return applicationInstanceLimit;
  }

  /**
   * The application task limit
   */
  @JsonProperty("app_task_limit")
  @Override
  public @Nullable Integer getApplicationTaskLimit() {
    return applicationTaskLimit;
  }

  /**
   * The instance memory limit
   */
  @JsonProperty("instance_memory_limit")
  @Override
  public @Nullable Integer getInstanceMemoryLimit() {
    return instanceMemoryLimit;
  }

  /**
   * The memory limit
   */
  @JsonProperty("memory_limit")
  @Override
  public @Nullable Integer getMemoryLimit() {
    return memoryLimit;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The non basic services allowed
   */
  @JsonProperty("non_basic_services_allowed")
  @Override
  public @Nullable Boolean getNonBasicServicesAllowed() {
    return nonBasicServicesAllowed;
  }

  /**
   * The total private domains
   */
  @JsonProperty("total_private_domains")
  @Override
  public @Nullable Integer getTotalPrivateDomains() {
    return totalPrivateDomains;
  }

  /**
   * The total reserved route ports
   */
  @JsonProperty("total_reserved_route_ports")
  @Override
  public @Nullable Integer getTotalReservedRoutePorts() {
    return totalReservedRoutePorts;
  }

  /**
   * The total routes
   */
  @JsonProperty("total_routes")
  @Override
  public @Nullable Integer getTotalRoutes() {
    return totalRoutes;
  }

  /**
   * The total service keys
   */
  @JsonProperty("total_service_keys")
  @Override
  public @Nullable Integer getTotalServiceKeys() {
    return totalServiceKeys;
  }

  /**
   * The total services
   */
  @JsonProperty("total_services")
  @Override
  public @Nullable Integer getTotalServices() {
    return totalServices;
  }

  /**
   * The trial db allowed
   */
  @JsonProperty("trial_db_allowed")
  @Deprecated
  @Override
  public @Nullable Boolean getTrialDatabaseAllowed() {
    return trialDatabaseAllowed;
  }

  /**
   * This instance is equal to all instances of {@code OrganizationQuotaDefinitionEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OrganizationQuotaDefinitionEntity
        && equalTo((OrganizationQuotaDefinitionEntity) another);
  }

  private boolean equalTo(OrganizationQuotaDefinitionEntity another) {
    return Objects.equals(applicationInstanceLimit, another.applicationInstanceLimit)
        && Objects.equals(applicationTaskLimit, another.applicationTaskLimit)
        && Objects.equals(instanceMemoryLimit, another.instanceMemoryLimit)
        && Objects.equals(memoryLimit, another.memoryLimit)
        && Objects.equals(name, another.name)
        && Objects.equals(nonBasicServicesAllowed, another.nonBasicServicesAllowed)
        && Objects.equals(totalPrivateDomains, another.totalPrivateDomains)
        && Objects.equals(totalReservedRoutePorts, another.totalReservedRoutePorts)
        && Objects.equals(totalRoutes, another.totalRoutes)
        && Objects.equals(totalServiceKeys, another.totalServiceKeys)
        && Objects.equals(totalServices, another.totalServices)
        && Objects.equals(trialDatabaseAllowed, another.trialDatabaseAllowed);
  }

  /**
   * Computes a hash code from attributes: {@code applicationInstanceLimit}, {@code applicationTaskLimit}, {@code instanceMemoryLimit}, {@code memoryLimit}, {@code name}, {@code nonBasicServicesAllowed}, {@code totalPrivateDomains}, {@code totalReservedRoutePorts}, {@code totalRoutes}, {@code totalServiceKeys}, {@code totalServices}, {@code trialDatabaseAllowed}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationInstanceLimit);
    h += (h << 5) + Objects.hashCode(applicationTaskLimit);
    h += (h << 5) + Objects.hashCode(instanceMemoryLimit);
    h += (h << 5) + Objects.hashCode(memoryLimit);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(nonBasicServicesAllowed);
    h += (h << 5) + Objects.hashCode(totalPrivateDomains);
    h += (h << 5) + Objects.hashCode(totalReservedRoutePorts);
    h += (h << 5) + Objects.hashCode(totalRoutes);
    h += (h << 5) + Objects.hashCode(totalServiceKeys);
    h += (h << 5) + Objects.hashCode(totalServices);
    h += (h << 5) + Objects.hashCode(trialDatabaseAllowed);
    return h;
  }

  /**
   * Prints the immutable value {@code OrganizationQuotaDefinitionEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OrganizationQuotaDefinitionEntity{"
        + "applicationInstanceLimit=" + applicationInstanceLimit
        + ", applicationTaskLimit=" + applicationTaskLimit
        + ", instanceMemoryLimit=" + instanceMemoryLimit
        + ", memoryLimit=" + memoryLimit
        + ", name=" + name
        + ", nonBasicServicesAllowed=" + nonBasicServicesAllowed
        + ", totalPrivateDomains=" + totalPrivateDomains
        + ", totalReservedRoutePorts=" + totalReservedRoutePorts
        + ", totalRoutes=" + totalRoutes
        + ", totalServiceKeys=" + totalServiceKeys
        + ", totalServices=" + totalServices
        + ", trialDatabaseAllowed=" + trialDatabaseAllowed
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_OrganizationQuotaDefinitionEntity", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.organizationquotadefinitions._OrganizationQuotaDefinitionEntity {
    Integer applicationInstanceLimit;
    Integer applicationTaskLimit;
    Integer instanceMemoryLimit;
    Integer memoryLimit;
    String name;
    Boolean nonBasicServicesAllowed;
    Integer totalPrivateDomains;
    Integer totalReservedRoutePorts;
    Integer totalRoutes;
    Integer totalServiceKeys;
    Integer totalServices;
    Boolean trialDatabaseAllowed;
    @JsonProperty("app_instance_limit")
    public void setApplicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
    }
    @JsonProperty("app_task_limit")
    public void setApplicationTaskLimit(@Nullable Integer applicationTaskLimit) {
      this.applicationTaskLimit = applicationTaskLimit;
    }
    @JsonProperty("instance_memory_limit")
    public void setInstanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = instanceMemoryLimit;
    }
    @JsonProperty("memory_limit")
    public void setMemoryLimit(@Nullable Integer memoryLimit) {
      this.memoryLimit = memoryLimit;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("non_basic_services_allowed")
    public void setNonBasicServicesAllowed(@Nullable Boolean nonBasicServicesAllowed) {
      this.nonBasicServicesAllowed = nonBasicServicesAllowed;
    }
    @JsonProperty("total_private_domains")
    public void setTotalPrivateDomains(@Nullable Integer totalPrivateDomains) {
      this.totalPrivateDomains = totalPrivateDomains;
    }
    @JsonProperty("total_reserved_route_ports")
    public void setTotalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = totalReservedRoutePorts;
    }
    @JsonProperty("total_routes")
    public void setTotalRoutes(@Nullable Integer totalRoutes) {
      this.totalRoutes = totalRoutes;
    }
    @JsonProperty("total_service_keys")
    public void setTotalServiceKeys(@Nullable Integer totalServiceKeys) {
      this.totalServiceKeys = totalServiceKeys;
    }
    @JsonProperty("total_services")
    public void setTotalServices(@Nullable Integer totalServices) {
      this.totalServices = totalServices;
    }
    @JsonProperty("trial_db_allowed")
    public void setTrialDatabaseAllowed(@Nullable Boolean trialDatabaseAllowed) {
      this.trialDatabaseAllowed = trialDatabaseAllowed;
    }
    @Override
    public Integer getApplicationInstanceLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getApplicationTaskLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInstanceMemoryLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryLimit() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getNonBasicServicesAllowed() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalPrivateDomains() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalReservedRoutePorts() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalRoutes() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalServiceKeys() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalServices() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getTrialDatabaseAllowed() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static OrganizationQuotaDefinitionEntity fromJson(Json json) {
    OrganizationQuotaDefinitionEntity.Builder builder = OrganizationQuotaDefinitionEntity.builder();
    if (json.applicationInstanceLimit != null) {
      builder.applicationInstanceLimit(json.applicationInstanceLimit);
    }
    if (json.applicationTaskLimit != null) {
      builder.applicationTaskLimit(json.applicationTaskLimit);
    }
    if (json.instanceMemoryLimit != null) {
      builder.instanceMemoryLimit(json.instanceMemoryLimit);
    }
    if (json.memoryLimit != null) {
      builder.memoryLimit(json.memoryLimit);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.nonBasicServicesAllowed != null) {
      builder.nonBasicServicesAllowed(json.nonBasicServicesAllowed);
    }
    if (json.totalPrivateDomains != null) {
      builder.totalPrivateDomains(json.totalPrivateDomains);
    }
    if (json.totalReservedRoutePorts != null) {
      builder.totalReservedRoutePorts(json.totalReservedRoutePorts);
    }
    if (json.totalRoutes != null) {
      builder.totalRoutes(json.totalRoutes);
    }
    if (json.totalServiceKeys != null) {
      builder.totalServiceKeys(json.totalServiceKeys);
    }
    if (json.totalServices != null) {
      builder.totalServices(json.totalServices);
    }
    if (json.trialDatabaseAllowed != null) {
      builder.trialDatabaseAllowed(json.trialDatabaseAllowed);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link OrganizationQuotaDefinitionEntity OrganizationQuotaDefinitionEntity}.
   * <pre>
   * OrganizationQuotaDefinitionEntity.builder()
   *    .applicationInstanceLimit(Integer | null) // nullable {@link OrganizationQuotaDefinitionEntity#getApplicationInstanceLimit() applicationInstanceLimit}
   *    .applicationTaskLimit(Integer | null) // nullable {@link OrganizationQuotaDefinitionEntity#getApplicationTaskLimit() applicationTaskLimit}
   *    .instanceMemoryLimit(Integer | null) // nullable {@link OrganizationQuotaDefinitionEntity#getInstanceMemoryLimit() instanceMemoryLimit}
   *    .memoryLimit(Integer | null) // nullable {@link OrganizationQuotaDefinitionEntity#getMemoryLimit() memoryLimit}
   *    .name(String | null) // nullable {@link OrganizationQuotaDefinitionEntity#getName() name}
   *    .nonBasicServicesAllowed(Boolean | null) // nullable {@link OrganizationQuotaDefinitionEntity#getNonBasicServicesAllowed() nonBasicServicesAllowed}
   *    .totalPrivateDomains(Integer | null) // nullable {@link OrganizationQuotaDefinitionEntity#getTotalPrivateDomains() totalPrivateDomains}
   *    .totalReservedRoutePorts(Integer | null) // nullable {@link OrganizationQuotaDefinitionEntity#getTotalReservedRoutePorts() totalReservedRoutePorts}
   *    .totalRoutes(Integer | null) // nullable {@link OrganizationQuotaDefinitionEntity#getTotalRoutes() totalRoutes}
   *    .totalServiceKeys(Integer | null) // nullable {@link OrganizationQuotaDefinitionEntity#getTotalServiceKeys() totalServiceKeys}
   *    .totalServices(Integer | null) // nullable {@link OrganizationQuotaDefinitionEntity#getTotalServices() totalServices}
   *    .trialDatabaseAllowed(Boolean | null) // nullable {@link OrganizationQuotaDefinitionEntity#getTrialDatabaseAllowed() trialDatabaseAllowed}
   *    .build();
   * </pre>
   * @return A new OrganizationQuotaDefinitionEntity builder
   */
  public static OrganizationQuotaDefinitionEntity.Builder builder() {
    return new OrganizationQuotaDefinitionEntity.Builder();
  }

  /**
   * Builds instances of type {@link OrganizationQuotaDefinitionEntity OrganizationQuotaDefinitionEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_OrganizationQuotaDefinitionEntity", generator = "Immutables")
  public static final class Builder {
    private Integer applicationInstanceLimit;
    private Integer applicationTaskLimit;
    private Integer instanceMemoryLimit;
    private Integer memoryLimit;
    private String name;
    private Boolean nonBasicServicesAllowed;
    private Integer totalPrivateDomains;
    private Integer totalReservedRoutePorts;
    private Integer totalRoutes;
    private Integer totalServiceKeys;
    private Integer totalServices;
    private Boolean trialDatabaseAllowed;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OrganizationQuotaDefinitionEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OrganizationQuotaDefinitionEntity instance) {
      return from((_OrganizationQuotaDefinitionEntity) instance);
    }

    /**
     * Copy abstract value type {@code _OrganizationQuotaDefinitionEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_OrganizationQuotaDefinitionEntity instance) {
      Objects.requireNonNull(instance, "instance");
      Integer applicationInstanceLimitValue = instance.getApplicationInstanceLimit();
      if (applicationInstanceLimitValue != null) {
        applicationInstanceLimit(applicationInstanceLimitValue);
      }
      Integer applicationTaskLimitValue = instance.getApplicationTaskLimit();
      if (applicationTaskLimitValue != null) {
        applicationTaskLimit(applicationTaskLimitValue);
      }
      Integer instanceMemoryLimitValue = instance.getInstanceMemoryLimit();
      if (instanceMemoryLimitValue != null) {
        instanceMemoryLimit(instanceMemoryLimitValue);
      }
      Integer memoryLimitValue = instance.getMemoryLimit();
      if (memoryLimitValue != null) {
        memoryLimit(memoryLimitValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Boolean nonBasicServicesAllowedValue = instance.getNonBasicServicesAllowed();
      if (nonBasicServicesAllowedValue != null) {
        nonBasicServicesAllowed(nonBasicServicesAllowedValue);
      }
      Integer totalPrivateDomainsValue = instance.getTotalPrivateDomains();
      if (totalPrivateDomainsValue != null) {
        totalPrivateDomains(totalPrivateDomainsValue);
      }
      Integer totalReservedRoutePortsValue = instance.getTotalReservedRoutePorts();
      if (totalReservedRoutePortsValue != null) {
        totalReservedRoutePorts(totalReservedRoutePortsValue);
      }
      Integer totalRoutesValue = instance.getTotalRoutes();
      if (totalRoutesValue != null) {
        totalRoutes(totalRoutesValue);
      }
      Integer totalServiceKeysValue = instance.getTotalServiceKeys();
      if (totalServiceKeysValue != null) {
        totalServiceKeys(totalServiceKeysValue);
      }
      Integer totalServicesValue = instance.getTotalServices();
      if (totalServicesValue != null) {
        totalServices(totalServicesValue);
      }
      Boolean trialDatabaseAllowedValue = instance.getTrialDatabaseAllowed();
      if (trialDatabaseAllowedValue != null) {
        trialDatabaseAllowed(trialDatabaseAllowedValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuotaDefinitionEntity#getApplicationInstanceLimit() applicationInstanceLimit} attribute.
     * @param applicationInstanceLimit The value for applicationInstanceLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app_instance_limit")
    public final Builder applicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuotaDefinitionEntity#getApplicationTaskLimit() applicationTaskLimit} attribute.
     * @param applicationTaskLimit The value for applicationTaskLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app_task_limit")
    public final Builder applicationTaskLimit(@Nullable Integer applicationTaskLimit) {
      this.applicationTaskLimit = applicationTaskLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuotaDefinitionEntity#getInstanceMemoryLimit() instanceMemoryLimit} attribute.
     * @param instanceMemoryLimit The value for instanceMemoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("instance_memory_limit")
    public final Builder instanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = instanceMemoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuotaDefinitionEntity#getMemoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("memory_limit")
    public final Builder memoryLimit(@Nullable Integer memoryLimit) {
      this.memoryLimit = memoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuotaDefinitionEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuotaDefinitionEntity#getNonBasicServicesAllowed() nonBasicServicesAllowed} attribute.
     * @param nonBasicServicesAllowed The value for nonBasicServicesAllowed (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("non_basic_services_allowed")
    public final Builder nonBasicServicesAllowed(@Nullable Boolean nonBasicServicesAllowed) {
      this.nonBasicServicesAllowed = nonBasicServicesAllowed;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuotaDefinitionEntity#getTotalPrivateDomains() totalPrivateDomains} attribute.
     * @param totalPrivateDomains The value for totalPrivateDomains (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_private_domains")
    public final Builder totalPrivateDomains(@Nullable Integer totalPrivateDomains) {
      this.totalPrivateDomains = totalPrivateDomains;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuotaDefinitionEntity#getTotalReservedRoutePorts() totalReservedRoutePorts} attribute.
     * @param totalReservedRoutePorts The value for totalReservedRoutePorts (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_reserved_route_ports")
    public final Builder totalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = totalReservedRoutePorts;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuotaDefinitionEntity#getTotalRoutes() totalRoutes} attribute.
     * @param totalRoutes The value for totalRoutes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_routes")
    public final Builder totalRoutes(@Nullable Integer totalRoutes) {
      this.totalRoutes = totalRoutes;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuotaDefinitionEntity#getTotalServiceKeys() totalServiceKeys} attribute.
     * @param totalServiceKeys The value for totalServiceKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_service_keys")
    public final Builder totalServiceKeys(@Nullable Integer totalServiceKeys) {
      this.totalServiceKeys = totalServiceKeys;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuotaDefinitionEntity#getTotalServices() totalServices} attribute.
     * @param totalServices The value for totalServices (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_services")
    public final Builder totalServices(@Nullable Integer totalServices) {
      this.totalServices = totalServices;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuotaDefinitionEntity#getTrialDatabaseAllowed() trialDatabaseAllowed} attribute.
     * @param trialDatabaseAllowed The value for trialDatabaseAllowed (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("trial_db_allowed")
    @Deprecated
    public final Builder trialDatabaseAllowed(@Nullable Boolean trialDatabaseAllowed) {
      this.trialDatabaseAllowed = trialDatabaseAllowed;
      return this;
    }

    /**
     * Builds a new {@link OrganizationQuotaDefinitionEntity OrganizationQuotaDefinitionEntity}.
     * @return An immutable instance of OrganizationQuotaDefinitionEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OrganizationQuotaDefinitionEntity build() {
      return new OrganizationQuotaDefinitionEntity(this);
    }
  }
}
