package org.cloudfoundry.client.v2.organizationquotadefinitions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Updating an Organization Quota Definition operation
 */
@Generated(from = "_UpdateOrganizationQuotaDefinitionRequest", generator = "Immutables")
@SuppressWarnings({"all", "deprecation"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateOrganizationQuotaDefinitionRequest
    extends org.cloudfoundry.client.v2.organizationquotadefinitions._UpdateOrganizationQuotaDefinitionRequest {
  private final @Nullable Integer applicationInstanceLimit;
  private final @Nullable Integer applicationTaskLimit;
  private final @Nullable Integer instanceMemoryLimit;
  private final @Nullable Integer memoryLimit;
  private final @Nullable String name;
  private final @Nullable Boolean nonBasicServicesAllowed;
  private final String organizationQuotaDefinitionId;
  private final @Nullable Integer totalPrivateDomains;
  private final @Nullable Integer totalReservedRoutePorts;
  private final @Nullable Integer totalRoutes;
  private final @Nullable Integer totalServiceKeys;
  private final @Nullable Integer totalServices;
  private final @Nullable Boolean trialDatabaseAllowed;

  private UpdateOrganizationQuotaDefinitionRequest(UpdateOrganizationQuotaDefinitionRequest.Builder builder) {
    this.applicationInstanceLimit = builder.applicationInstanceLimit;
    this.applicationTaskLimit = builder.applicationTaskLimit;
    this.instanceMemoryLimit = builder.instanceMemoryLimit;
    this.memoryLimit = builder.memoryLimit;
    this.name = builder.name;
    this.nonBasicServicesAllowed = builder.nonBasicServicesAllowed;
    this.organizationQuotaDefinitionId = builder.organizationQuotaDefinitionId;
    this.totalPrivateDomains = builder.totalPrivateDomains;
    this.totalReservedRoutePorts = builder.totalReservedRoutePorts;
    this.totalRoutes = builder.totalRoutes;
    this.totalServiceKeys = builder.totalServiceKeys;
    this.totalServices = builder.totalServices;
    this.trialDatabaseAllowed = builder.trialDatabaseAllowed;
  }

  /**
   * The application instance limit
   */
  @JsonProperty("app_instance_limit")
  @Override
  public @Nullable Integer getApplicationInstanceLimit() {
    return applicationInstanceLimit;
  }

  /**
   * The application task limit
   */
  @JsonProperty("app_task_limit")
  @Override
  public @Nullable Integer getApplicationTaskLimit() {
    return applicationTaskLimit;
  }

  /**
   * The instance memory limit
   */
  @JsonProperty("instance_memory_limit")
  @Override
  public @Nullable Integer getInstanceMemoryLimit() {
    return instanceMemoryLimit;
  }

  /**
   * The memory limit
   */
  @JsonProperty("memory_limit")
  @Override
  public @Nullable Integer getMemoryLimit() {
    return memoryLimit;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The non basic services allowed
   */
  @JsonProperty("non_basic_services_allowed")
  @Override
  public @Nullable Boolean getNonBasicServicesAllowed() {
    return nonBasicServicesAllowed;
  }

  /**
   * The quota definition id
   */
  @JsonProperty("organizationQuotaDefinitionId")
  @JsonIgnore
  @Override
  public String getOrganizationQuotaDefinitionId() {
    return organizationQuotaDefinitionId;
  }

  /**
   * The total private domains
   */
  @JsonProperty("total_private_domains")
  @Override
  public @Nullable Integer getTotalPrivateDomains() {
    return totalPrivateDomains;
  }

  /**
   * The total reserved route ports
   */
  @JsonProperty("total_reserved_route_ports")
  @Override
  public @Nullable Integer getTotalReservedRoutePorts() {
    return totalReservedRoutePorts;
  }

  /**
   * The total routes
   */
  @JsonProperty("total_routes")
  @Override
  public @Nullable Integer getTotalRoutes() {
    return totalRoutes;
  }

  /**
   * The total service keys
   */
  @JsonProperty("total_service_keys")
  @Override
  public @Nullable Integer getTotalServiceKeys() {
    return totalServiceKeys;
  }

  /**
   * The total services
   */
  @JsonProperty("total_services")
  @Override
  public @Nullable Integer getTotalServices() {
    return totalServices;
  }

  /**
   * The trial db allowed
   */
  @JsonProperty("trial_db_allowed")
  @Deprecated
  @Override
  public @Nullable Boolean getTrialDatabaseAllowed() {
    return trialDatabaseAllowed;
  }

  /**
   * This instance is equal to all instances of {@code UpdateOrganizationQuotaDefinitionRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateOrganizationQuotaDefinitionRequest
        && equalTo((UpdateOrganizationQuotaDefinitionRequest) another);
  }

  private boolean equalTo(UpdateOrganizationQuotaDefinitionRequest another) {
    return Objects.equals(applicationInstanceLimit, another.applicationInstanceLimit)
        && Objects.equals(applicationTaskLimit, another.applicationTaskLimit)
        && Objects.equals(instanceMemoryLimit, another.instanceMemoryLimit)
        && Objects.equals(memoryLimit, another.memoryLimit)
        && Objects.equals(name, another.name)
        && Objects.equals(nonBasicServicesAllowed, another.nonBasicServicesAllowed)
        && organizationQuotaDefinitionId.equals(another.organizationQuotaDefinitionId)
        && Objects.equals(totalPrivateDomains, another.totalPrivateDomains)
        && Objects.equals(totalReservedRoutePorts, another.totalReservedRoutePorts)
        && Objects.equals(totalRoutes, another.totalRoutes)
        && Objects.equals(totalServiceKeys, another.totalServiceKeys)
        && Objects.equals(totalServices, another.totalServices)
        && Objects.equals(trialDatabaseAllowed, another.trialDatabaseAllowed);
  }

  /**
   * Computes a hash code from attributes: {@code applicationInstanceLimit}, {@code applicationTaskLimit}, {@code instanceMemoryLimit}, {@code memoryLimit}, {@code name}, {@code nonBasicServicesAllowed}, {@code organizationQuotaDefinitionId}, {@code totalPrivateDomains}, {@code totalReservedRoutePorts}, {@code totalRoutes}, {@code totalServiceKeys}, {@code totalServices}, {@code trialDatabaseAllowed}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationInstanceLimit);
    h += (h << 5) + Objects.hashCode(applicationTaskLimit);
    h += (h << 5) + Objects.hashCode(instanceMemoryLimit);
    h += (h << 5) + Objects.hashCode(memoryLimit);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(nonBasicServicesAllowed);
    h += (h << 5) + organizationQuotaDefinitionId.hashCode();
    h += (h << 5) + Objects.hashCode(totalPrivateDomains);
    h += (h << 5) + Objects.hashCode(totalReservedRoutePorts);
    h += (h << 5) + Objects.hashCode(totalRoutes);
    h += (h << 5) + Objects.hashCode(totalServiceKeys);
    h += (h << 5) + Objects.hashCode(totalServices);
    h += (h << 5) + Objects.hashCode(trialDatabaseAllowed);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateOrganizationQuotaDefinitionRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateOrganizationQuotaDefinitionRequest{"
        + "applicationInstanceLimit=" + applicationInstanceLimit
        + ", applicationTaskLimit=" + applicationTaskLimit
        + ", instanceMemoryLimit=" + instanceMemoryLimit
        + ", memoryLimit=" + memoryLimit
        + ", name=" + name
        + ", nonBasicServicesAllowed=" + nonBasicServicesAllowed
        + ", organizationQuotaDefinitionId=" + organizationQuotaDefinitionId
        + ", totalPrivateDomains=" + totalPrivateDomains
        + ", totalReservedRoutePorts=" + totalReservedRoutePorts
        + ", totalRoutes=" + totalRoutes
        + ", totalServiceKeys=" + totalServiceKeys
        + ", totalServices=" + totalServices
        + ", trialDatabaseAllowed=" + trialDatabaseAllowed
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateOrganizationQuotaDefinitionRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.organizationquotadefinitions._UpdateOrganizationQuotaDefinitionRequest {
    Integer applicationInstanceLimit;
    Integer applicationTaskLimit;
    Integer instanceMemoryLimit;
    Integer memoryLimit;
    String name;
    Boolean nonBasicServicesAllowed;
    String organizationQuotaDefinitionId;
    Integer totalPrivateDomains;
    Integer totalReservedRoutePorts;
    Integer totalRoutes;
    Integer totalServiceKeys;
    Integer totalServices;
    Boolean trialDatabaseAllowed;
    @JsonProperty("app_instance_limit")
    public void setApplicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
    }
    @JsonProperty("app_task_limit")
    public void setApplicationTaskLimit(@Nullable Integer applicationTaskLimit) {
      this.applicationTaskLimit = applicationTaskLimit;
    }
    @JsonProperty("instance_memory_limit")
    public void setInstanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = instanceMemoryLimit;
    }
    @JsonProperty("memory_limit")
    public void setMemoryLimit(@Nullable Integer memoryLimit) {
      this.memoryLimit = memoryLimit;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("non_basic_services_allowed")
    public void setNonBasicServicesAllowed(@Nullable Boolean nonBasicServicesAllowed) {
      this.nonBasicServicesAllowed = nonBasicServicesAllowed;
    }
    @JsonProperty("organizationQuotaDefinitionId")
    @JsonIgnore
    public void setOrganizationQuotaDefinitionId(String organizationQuotaDefinitionId) {
      this.organizationQuotaDefinitionId = organizationQuotaDefinitionId;
    }
    @JsonProperty("total_private_domains")
    public void setTotalPrivateDomains(@Nullable Integer totalPrivateDomains) {
      this.totalPrivateDomains = totalPrivateDomains;
    }
    @JsonProperty("total_reserved_route_ports")
    public void setTotalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = totalReservedRoutePorts;
    }
    @JsonProperty("total_routes")
    public void setTotalRoutes(@Nullable Integer totalRoutes) {
      this.totalRoutes = totalRoutes;
    }
    @JsonProperty("total_service_keys")
    public void setTotalServiceKeys(@Nullable Integer totalServiceKeys) {
      this.totalServiceKeys = totalServiceKeys;
    }
    @JsonProperty("total_services")
    public void setTotalServices(@Nullable Integer totalServices) {
      this.totalServices = totalServices;
    }
    @JsonProperty("trial_db_allowed")
    public void setTrialDatabaseAllowed(@Nullable Boolean trialDatabaseAllowed) {
      this.trialDatabaseAllowed = trialDatabaseAllowed;
    }
    @Override
    public Integer getApplicationInstanceLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getApplicationTaskLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInstanceMemoryLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryLimit() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getNonBasicServicesAllowed() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationQuotaDefinitionId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalPrivateDomains() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalReservedRoutePorts() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalRoutes() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalServiceKeys() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalServices() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getTrialDatabaseAllowed() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateOrganizationQuotaDefinitionRequest fromJson(Json json) {
    UpdateOrganizationQuotaDefinitionRequest.Builder builder = UpdateOrganizationQuotaDefinitionRequest.builder();
    if (json.applicationInstanceLimit != null) {
      builder.applicationInstanceLimit(json.applicationInstanceLimit);
    }
    if (json.applicationTaskLimit != null) {
      builder.applicationTaskLimit(json.applicationTaskLimit);
    }
    if (json.instanceMemoryLimit != null) {
      builder.instanceMemoryLimit(json.instanceMemoryLimit);
    }
    if (json.memoryLimit != null) {
      builder.memoryLimit(json.memoryLimit);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.nonBasicServicesAllowed != null) {
      builder.nonBasicServicesAllowed(json.nonBasicServicesAllowed);
    }
    if (json.organizationQuotaDefinitionId != null) {
      builder.organizationQuotaDefinitionId(json.organizationQuotaDefinitionId);
    }
    if (json.totalPrivateDomains != null) {
      builder.totalPrivateDomains(json.totalPrivateDomains);
    }
    if (json.totalReservedRoutePorts != null) {
      builder.totalReservedRoutePorts(json.totalReservedRoutePorts);
    }
    if (json.totalRoutes != null) {
      builder.totalRoutes(json.totalRoutes);
    }
    if (json.totalServiceKeys != null) {
      builder.totalServiceKeys(json.totalServiceKeys);
    }
    if (json.totalServices != null) {
      builder.totalServices(json.totalServices);
    }
    if (json.trialDatabaseAllowed != null) {
      builder.trialDatabaseAllowed(json.trialDatabaseAllowed);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateOrganizationQuotaDefinitionRequest UpdateOrganizationQuotaDefinitionRequest}.
   * <pre>
   * UpdateOrganizationQuotaDefinitionRequest.builder()
   *    .applicationInstanceLimit(Integer | null) // nullable {@link UpdateOrganizationQuotaDefinitionRequest#getApplicationInstanceLimit() applicationInstanceLimit}
   *    .applicationTaskLimit(Integer | null) // nullable {@link UpdateOrganizationQuotaDefinitionRequest#getApplicationTaskLimit() applicationTaskLimit}
   *    .instanceMemoryLimit(Integer | null) // nullable {@link UpdateOrganizationQuotaDefinitionRequest#getInstanceMemoryLimit() instanceMemoryLimit}
   *    .memoryLimit(Integer | null) // nullable {@link UpdateOrganizationQuotaDefinitionRequest#getMemoryLimit() memoryLimit}
   *    .name(String | null) // nullable {@link UpdateOrganizationQuotaDefinitionRequest#getName() name}
   *    .nonBasicServicesAllowed(Boolean | null) // nullable {@link UpdateOrganizationQuotaDefinitionRequest#getNonBasicServicesAllowed() nonBasicServicesAllowed}
   *    .organizationQuotaDefinitionId(String) // required {@link UpdateOrganizationQuotaDefinitionRequest#getOrganizationQuotaDefinitionId() organizationQuotaDefinitionId}
   *    .totalPrivateDomains(Integer | null) // nullable {@link UpdateOrganizationQuotaDefinitionRequest#getTotalPrivateDomains() totalPrivateDomains}
   *    .totalReservedRoutePorts(Integer | null) // nullable {@link UpdateOrganizationQuotaDefinitionRequest#getTotalReservedRoutePorts() totalReservedRoutePorts}
   *    .totalRoutes(Integer | null) // nullable {@link UpdateOrganizationQuotaDefinitionRequest#getTotalRoutes() totalRoutes}
   *    .totalServiceKeys(Integer | null) // nullable {@link UpdateOrganizationQuotaDefinitionRequest#getTotalServiceKeys() totalServiceKeys}
   *    .totalServices(Integer | null) // nullable {@link UpdateOrganizationQuotaDefinitionRequest#getTotalServices() totalServices}
   *    .trialDatabaseAllowed(Boolean | null) // nullable {@link UpdateOrganizationQuotaDefinitionRequest#getTrialDatabaseAllowed() trialDatabaseAllowed}
   *    .build();
   * </pre>
   * @return A new UpdateOrganizationQuotaDefinitionRequest builder
   */
  public static UpdateOrganizationQuotaDefinitionRequest.Builder builder() {
    return new UpdateOrganizationQuotaDefinitionRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateOrganizationQuotaDefinitionRequest UpdateOrganizationQuotaDefinitionRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateOrganizationQuotaDefinitionRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_QUOTA_DEFINITION_ID = 0x1L;
    private long initBits = 0x1L;

    private Integer applicationInstanceLimit;
    private Integer applicationTaskLimit;
    private Integer instanceMemoryLimit;
    private Integer memoryLimit;
    private String name;
    private Boolean nonBasicServicesAllowed;
    private String organizationQuotaDefinitionId;
    private Integer totalPrivateDomains;
    private Integer totalReservedRoutePorts;
    private Integer totalRoutes;
    private Integer totalServiceKeys;
    private Integer totalServices;
    private Boolean trialDatabaseAllowed;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateOrganizationQuotaDefinitionRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateOrganizationQuotaDefinitionRequest instance) {
      return from((_UpdateOrganizationQuotaDefinitionRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateOrganizationQuotaDefinitionRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateOrganizationQuotaDefinitionRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Integer applicationInstanceLimitValue = instance.getApplicationInstanceLimit();
      if (applicationInstanceLimitValue != null) {
        applicationInstanceLimit(applicationInstanceLimitValue);
      }
      Integer applicationTaskLimitValue = instance.getApplicationTaskLimit();
      if (applicationTaskLimitValue != null) {
        applicationTaskLimit(applicationTaskLimitValue);
      }
      Integer instanceMemoryLimitValue = instance.getInstanceMemoryLimit();
      if (instanceMemoryLimitValue != null) {
        instanceMemoryLimit(instanceMemoryLimitValue);
      }
      Integer memoryLimitValue = instance.getMemoryLimit();
      if (memoryLimitValue != null) {
        memoryLimit(memoryLimitValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Boolean nonBasicServicesAllowedValue = instance.getNonBasicServicesAllowed();
      if (nonBasicServicesAllowedValue != null) {
        nonBasicServicesAllowed(nonBasicServicesAllowedValue);
      }
      organizationQuotaDefinitionId(instance.getOrganizationQuotaDefinitionId());
      Integer totalPrivateDomainsValue = instance.getTotalPrivateDomains();
      if (totalPrivateDomainsValue != null) {
        totalPrivateDomains(totalPrivateDomainsValue);
      }
      Integer totalReservedRoutePortsValue = instance.getTotalReservedRoutePorts();
      if (totalReservedRoutePortsValue != null) {
        totalReservedRoutePorts(totalReservedRoutePortsValue);
      }
      Integer totalRoutesValue = instance.getTotalRoutes();
      if (totalRoutesValue != null) {
        totalRoutes(totalRoutesValue);
      }
      Integer totalServiceKeysValue = instance.getTotalServiceKeys();
      if (totalServiceKeysValue != null) {
        totalServiceKeys(totalServiceKeysValue);
      }
      Integer totalServicesValue = instance.getTotalServices();
      if (totalServicesValue != null) {
        totalServices(totalServicesValue);
      }
      Boolean trialDatabaseAllowedValue = instance.getTrialDatabaseAllowed();
      if (trialDatabaseAllowedValue != null) {
        trialDatabaseAllowed(trialDatabaseAllowedValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationQuotaDefinitionRequest#getApplicationInstanceLimit() applicationInstanceLimit} attribute.
     * @param applicationInstanceLimit The value for applicationInstanceLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationQuotaDefinitionRequest#getApplicationTaskLimit() applicationTaskLimit} attribute.
     * @param applicationTaskLimit The value for applicationTaskLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationTaskLimit(@Nullable Integer applicationTaskLimit) {
      this.applicationTaskLimit = applicationTaskLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationQuotaDefinitionRequest#getInstanceMemoryLimit() instanceMemoryLimit} attribute.
     * @param instanceMemoryLimit The value for instanceMemoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = instanceMemoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationQuotaDefinitionRequest#getMemoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryLimit(@Nullable Integer memoryLimit) {
      this.memoryLimit = memoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationQuotaDefinitionRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationQuotaDefinitionRequest#getNonBasicServicesAllowed() nonBasicServicesAllowed} attribute.
     * @param nonBasicServicesAllowed The value for nonBasicServicesAllowed (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nonBasicServicesAllowed(@Nullable Boolean nonBasicServicesAllowed) {
      this.nonBasicServicesAllowed = nonBasicServicesAllowed;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationQuotaDefinitionRequest#getOrganizationQuotaDefinitionId() organizationQuotaDefinitionId} attribute.
     * @param organizationQuotaDefinitionId The value for organizationQuotaDefinitionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationQuotaDefinitionId(String organizationQuotaDefinitionId) {
      this.organizationQuotaDefinitionId = Objects.requireNonNull(organizationQuotaDefinitionId, "organizationQuotaDefinitionId");
      initBits &= ~INIT_BIT_ORGANIZATION_QUOTA_DEFINITION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationQuotaDefinitionRequest#getTotalPrivateDomains() totalPrivateDomains} attribute.
     * @param totalPrivateDomains The value for totalPrivateDomains (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalPrivateDomains(@Nullable Integer totalPrivateDomains) {
      this.totalPrivateDomains = totalPrivateDomains;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationQuotaDefinitionRequest#getTotalReservedRoutePorts() totalReservedRoutePorts} attribute.
     * @param totalReservedRoutePorts The value for totalReservedRoutePorts (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = totalReservedRoutePorts;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationQuotaDefinitionRequest#getTotalRoutes() totalRoutes} attribute.
     * @param totalRoutes The value for totalRoutes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalRoutes(@Nullable Integer totalRoutes) {
      this.totalRoutes = totalRoutes;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationQuotaDefinitionRequest#getTotalServiceKeys() totalServiceKeys} attribute.
     * @param totalServiceKeys The value for totalServiceKeys (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServiceKeys(@Nullable Integer totalServiceKeys) {
      this.totalServiceKeys = totalServiceKeys;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationQuotaDefinitionRequest#getTotalServices() totalServices} attribute.
     * @param totalServices The value for totalServices (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServices(@Nullable Integer totalServices) {
      this.totalServices = totalServices;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateOrganizationQuotaDefinitionRequest#getTrialDatabaseAllowed() trialDatabaseAllowed} attribute.
     * @param trialDatabaseAllowed The value for trialDatabaseAllowed (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder trialDatabaseAllowed(@Nullable Boolean trialDatabaseAllowed) {
      this.trialDatabaseAllowed = trialDatabaseAllowed;
      return this;
    }

    /**
     * Builds a new {@link UpdateOrganizationQuotaDefinitionRequest UpdateOrganizationQuotaDefinitionRequest}.
     * @return An immutable instance of UpdateOrganizationQuotaDefinitionRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateOrganizationQuotaDefinitionRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateOrganizationQuotaDefinitionRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_QUOTA_DEFINITION_ID) != 0) attributes.add("organizationQuotaDefinitionId");
      return "Cannot build UpdateOrganizationQuotaDefinitionRequest, some of required attributes are not set " + attributes;
    }
  }
}
