package org.cloudfoundry.client.v2.resourcematch;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the List Matching Resources operation
 */
@Generated(from = "_ListMatchingResourcesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListMatchingResourcesRequest
    extends org.cloudfoundry.client.v2.resourcematch._ListMatchingResourcesRequest {
  private final List<Resource> resources;

  private ListMatchingResourcesRequest(ListMatchingResourcesRequest.Builder builder) {
    this.resources = createUnmodifiableList(true, builder.resources);
  }

  /**
   * The resources
   */
  @JsonProperty("resources")
  @Override
  public List<Resource> getResources() {
    return resources;
  }

  /**
   * This instance is equal to all instances of {@code ListMatchingResourcesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListMatchingResourcesRequest
        && equalTo((ListMatchingResourcesRequest) another);
  }

  private boolean equalTo(ListMatchingResourcesRequest another) {
    return resources.equals(another.resources);
  }

  /**
   * Computes a hash code from attributes: {@code resources}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + resources.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListMatchingResourcesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListMatchingResourcesRequest{"
        + "resources=" + resources
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ListMatchingResourcesRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.resourcematch._ListMatchingResourcesRequest {
    List<Resource> resources = Collections.emptyList();
    @JsonProperty("resources")
    public void setResources(List<Resource> resources) {
      this.resources = resources;
    }
    @Override
    public List<Resource> getResources() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListMatchingResourcesRequest fromJson(Json json) {
    ListMatchingResourcesRequest.Builder builder = ListMatchingResourcesRequest.builder();
    if (json.resources != null) {
      builder.addAllResources(json.resources);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListMatchingResourcesRequest ListMatchingResourcesRequest}.
   * <pre>
   * ListMatchingResourcesRequest.builder()
   *    .resource|addAllResources(Resource) // {@link ListMatchingResourcesRequest#getResources() resources} elements
   *    .build();
   * </pre>
   * @return A new ListMatchingResourcesRequest builder
   */
  public static ListMatchingResourcesRequest.Builder builder() {
    return new ListMatchingResourcesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListMatchingResourcesRequest ListMatchingResourcesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListMatchingResourcesRequest", generator = "Immutables")
  public static final class Builder {
    private List<Resource> resources = new ArrayList<Resource>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListMatchingResourcesRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListMatchingResourcesRequest instance) {
      return from((_ListMatchingResourcesRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ListMatchingResourcesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListMatchingResourcesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      addAllResources(instance.getResources());
      return this;
    }

    /**
     * Adds one element to {@link ListMatchingResourcesRequest#getResources() resources} list.
     * @param element A resources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resource(Resource element) {
      this.resources.add(Objects.requireNonNull(element, "resources element"));
      return this;
    }

    /**
     * Adds elements to {@link ListMatchingResourcesRequest#getResources() resources} list.
     * @param elements An array of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resources(Resource... elements) {
      for (Resource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListMatchingResourcesRequest#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resources(Iterable<? extends Resource> elements) {
      this.resources.clear();
      return addAllResources(elements);
    }

    /**
     * Adds elements to {@link ListMatchingResourcesRequest#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResources(Iterable<? extends Resource> elements) {
      for (Resource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListMatchingResourcesRequest ListMatchingResourcesRequest}.
     * @return An immutable instance of ListMatchingResourcesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListMatchingResourcesRequest build() {
      return new ListMatchingResourcesRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
