package org.cloudfoundry.client.v2.servicebindings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Service Binding Parameters operation
 */
@Generated(from = "_GetServiceBindingParametersRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetServiceBindingParametersRequest
    extends org.cloudfoundry.client.v2.servicebindings._GetServiceBindingParametersRequest {
  private final String serviceBindingId;

  private GetServiceBindingParametersRequest(GetServiceBindingParametersRequest.Builder builder) {
    this.serviceBindingId = builder.serviceBindingId;
  }

  /**
   * The service binding id
   */
  @Override
  public String getServiceBindingId() {
    return serviceBindingId;
  }

  /**
   * This instance is equal to all instances of {@code GetServiceBindingParametersRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetServiceBindingParametersRequest
        && equalTo((GetServiceBindingParametersRequest) another);
  }

  private boolean equalTo(GetServiceBindingParametersRequest another) {
    return serviceBindingId.equals(another.serviceBindingId);
  }

  /**
   * Computes a hash code from attributes: {@code serviceBindingId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceBindingId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetServiceBindingParametersRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetServiceBindingParametersRequest{"
        + "serviceBindingId=" + serviceBindingId
        + "}";
  }

  /**
   * Creates a builder for {@link GetServiceBindingParametersRequest GetServiceBindingParametersRequest}.
   * <pre>
   * GetServiceBindingParametersRequest.builder()
   *    .serviceBindingId(String) // required {@link GetServiceBindingParametersRequest#getServiceBindingId() serviceBindingId}
   *    .build();
   * </pre>
   * @return A new GetServiceBindingParametersRequest builder
   */
  public static GetServiceBindingParametersRequest.Builder builder() {
    return new GetServiceBindingParametersRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetServiceBindingParametersRequest GetServiceBindingParametersRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetServiceBindingParametersRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_BINDING_ID = 0x1L;
    private long initBits = 0x1L;

    private String serviceBindingId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetServiceBindingParametersRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetServiceBindingParametersRequest instance) {
      return from((_GetServiceBindingParametersRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetServiceBindingParametersRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetServiceBindingParametersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceBindingId(instance.getServiceBindingId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetServiceBindingParametersRequest#getServiceBindingId() serviceBindingId} attribute.
     * @param serviceBindingId The value for serviceBindingId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBindingId(String serviceBindingId) {
      this.serviceBindingId = Objects.requireNonNull(serviceBindingId, "serviceBindingId");
      initBits &= ~INIT_BIT_SERVICE_BINDING_ID;
      return this;
    }

    /**
     * Builds a new {@link GetServiceBindingParametersRequest GetServiceBindingParametersRequest}.
     * @return An immutable instance of GetServiceBindingParametersRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetServiceBindingParametersRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetServiceBindingParametersRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_BINDING_ID) != 0) attributes.add("serviceBindingId");
      return "Cannot build GetServiceBindingParametersRequest, some of required attributes are not set " + attributes;
    }
  }
}
