package org.cloudfoundry.client.v2.servicebrokers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _DeleteServiceBrokerRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DeleteServiceBrokerRequest.builder()}.
 */
@Generated(from = "_DeleteServiceBrokerRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteServiceBrokerRequest
    extends org.cloudfoundry.client.v2.servicebrokers._DeleteServiceBrokerRequest {
  private final String serviceBrokerId;

  private DeleteServiceBrokerRequest(DeleteServiceBrokerRequest.Builder builder) {
    this.serviceBrokerId = builder.serviceBrokerId;
  }

  /**
   * The service broker id
   */
  @Override
  public String getServiceBrokerId() {
    return serviceBrokerId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteServiceBrokerRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteServiceBrokerRequest
        && equalTo((DeleteServiceBrokerRequest) another);
  }

  private boolean equalTo(DeleteServiceBrokerRequest another) {
    return serviceBrokerId.equals(another.serviceBrokerId);
  }

  /**
   * Computes a hash code from attributes: {@code serviceBrokerId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceBrokerId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteServiceBrokerRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteServiceBrokerRequest{"
        + "serviceBrokerId=" + serviceBrokerId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteServiceBrokerRequest DeleteServiceBrokerRequest}.
   * <pre>
   * DeleteServiceBrokerRequest.builder()
   *    .serviceBrokerId(String) // required {@link DeleteServiceBrokerRequest#getServiceBrokerId() serviceBrokerId}
   *    .build();
   * </pre>
   * @return A new DeleteServiceBrokerRequest builder
   */
  public static DeleteServiceBrokerRequest.Builder builder() {
    return new DeleteServiceBrokerRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteServiceBrokerRequest DeleteServiceBrokerRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteServiceBrokerRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_BROKER_ID = 0x1L;
    private long initBits = 0x1L;

    private String serviceBrokerId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteServiceBrokerRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteServiceBrokerRequest instance) {
      return from((_DeleteServiceBrokerRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteServiceBrokerRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteServiceBrokerRequest instance) {
      Objects.requireNonNull(instance, "instance");
      serviceBrokerId(instance.getServiceBrokerId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteServiceBrokerRequest#getServiceBrokerId() serviceBrokerId} attribute.
     * @param serviceBrokerId The value for serviceBrokerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBrokerId(String serviceBrokerId) {
      this.serviceBrokerId = Objects.requireNonNull(serviceBrokerId, "serviceBrokerId");
      initBits &= ~INIT_BIT_SERVICE_BROKER_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteServiceBrokerRequest DeleteServiceBrokerRequest}.
     * @return An immutable instance of DeleteServiceBrokerRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteServiceBrokerRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteServiceBrokerRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_BROKER_ID) != 0) attributes.add("serviceBrokerId");
      return "Cannot build DeleteServiceBrokerRequest, some of required attributes are not set " + attributes;
    }
  }
}
