package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.MaintenanceInfo;
import org.immutables.value.Generated;

/**
 * The entity response payload for any type of Service Instances
 */
@Generated(from = "_UnionServiceInstanceEntity", generator = "Immutables")
@SuppressWarnings({"all", "deprecation"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UnionServiceInstanceEntity
    extends org.cloudfoundry.client.v2.serviceinstances._UnionServiceInstanceEntity {
  private final @Nullable Map<String, Object> credentials;
  private final @Nullable String name;
  private final @Nullable String routesUrl;
  private final @Nullable String serviceBindingsUrl;
  private final @Nullable String sharedFromUrl;
  private final @Nullable String sharedToUrl;
  private final @Nullable String spaceId;
  private final @Nullable String spaceUrl;
  private final @Nullable List<String> tags;
  private final @Nullable String type;
  private final @Nullable String dashboardUrl;
  private final @Nullable GatewayData gatewayData;
  private final @Nullable LastOperation lastOperation;
  private final @Nullable MaintenanceInfo maintenanceInfo;
  private final @Nullable String routeServiceUrl;
  private final @Nullable String serviceId;
  private final @Nullable String serviceInstanceParametersUrl;
  private final @Nullable String serviceKeysUrl;
  private final @Nullable String servicePlanId;
  private final @Nullable String servicePlanUrl;
  private final @Nullable String serviceUrl;
  private final @Nullable String syslogDrainUrl;

  private UnionServiceInstanceEntity(UnionServiceInstanceEntity.Builder builder) {
    this.credentials = builder.credentials == null ? null : createUnmodifiableMap(false, false, builder.credentials);
    this.name = builder.name;
    this.routesUrl = builder.routesUrl;
    this.serviceBindingsUrl = builder.serviceBindingsUrl;
    this.sharedFromUrl = builder.sharedFromUrl;
    this.sharedToUrl = builder.sharedToUrl;
    this.spaceId = builder.spaceId;
    this.spaceUrl = builder.spaceUrl;
    this.tags = builder.tags == null ? null : createUnmodifiableList(true, builder.tags);
    this.type = builder.type;
    this.dashboardUrl = builder.dashboardUrl;
    this.gatewayData = builder.gatewayData;
    this.lastOperation = builder.lastOperation;
    this.maintenanceInfo = builder.maintenanceInfo;
    this.routeServiceUrl = builder.routeServiceUrl;
    this.serviceId = builder.serviceId;
    this.serviceInstanceParametersUrl = builder.serviceInstanceParametersUrl;
    this.serviceKeysUrl = builder.serviceKeysUrl;
    this.servicePlanId = builder.servicePlanId;
    this.servicePlanUrl = builder.servicePlanUrl;
    this.serviceUrl = builder.serviceUrl;
    this.syslogDrainUrl = builder.syslogDrainUrl;
  }

  /**
   * The credentials
   */
  @JsonProperty("credentials")
  @Override
  public @Nullable Map<String, Object> getCredentials() {
    return credentials;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The routes url
   */
  @JsonProperty("routes_url")
  @Override
  public @Nullable String getRoutesUrl() {
    return routesUrl;
  }

  /**
   * The service bindings url
   */
  @JsonProperty("service_bindings_url")
  @Override
  public @Nullable String getServiceBindingsUrl() {
    return serviceBindingsUrl;
  }

  /**
   * The shared from url
   */
  @JsonProperty("shared_from_url")
  @Override
  public @Nullable String getSharedFromUrl() {
    return sharedFromUrl;
  }

  /**
   * The shared to url
   */
  @JsonProperty("shared_to_url")
  @Override
  public @Nullable String getSharedToUrl() {
    return sharedToUrl;
  }

  /**
   * The space id
   */
  @JsonProperty("space_guid")
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * The space url
   */
  @JsonProperty("space_url")
  @Override
  public @Nullable String getSpaceUrl() {
    return spaceUrl;
  }

  /**
   * A list of tags for the service instance
   */
  @JsonProperty("tags")
  @Override
  public @Nullable List<String> getTags() {
    return tags;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * The dashboard url
   */
  @JsonProperty("dashboard_url")
  @Override
  public @Nullable String getDashboardUrl() {
    return dashboardUrl;
  }

  /**
   * The gateway data
   */
  @JsonProperty("gateway_data")
  @Deprecated
  @Override
  public @Nullable GatewayData getGatewayData() {
    return gatewayData;
  }

  /**
   * The last operation
   */
  @JsonProperty("last_operation")
  @Override
  public @Nullable LastOperation getLastOperation() {
    return lastOperation;
  }

  /**
   * The maintenance info
   */
  @JsonProperty("maintenance_info")
  @Override
  public @Nullable MaintenanceInfo getMaintenanceInfo() {
    return maintenanceInfo;
  }

  /**
   * URL to which requests for bound routes will be forwarded
   */
  @JsonProperty("route_service_url")
  @Override
  public @Nullable String getRouteServiceUrl() {
    return routeServiceUrl;
  }

  /**
   * The service id
   */
  @JsonProperty("service_guid")
  @Override
  public @Nullable String getServiceId() {
    return serviceId;
  }

  /**
   * The service instance parameters url
   */
  @JsonProperty("service_instance_parameters_url")
  @Override
  public @Nullable String getServiceInstanceParametersUrl() {
    return serviceInstanceParametersUrl;
  }

  /**
   * The service keys url
   */
  @JsonProperty("service_keys_url")
  @Override
  public @Nullable String getServiceKeysUrl() {
    return serviceKeysUrl;
  }

  /**
   * The service plan id
   */
  @JsonProperty("service_plan_guid")
  @Override
  public @Nullable String getServicePlanId() {
    return servicePlanId;
  }

  /**
   * The service plan url
   */
  @JsonProperty("service_plan_url")
  @Override
  public @Nullable String getServicePlanUrl() {
    return servicePlanUrl;
  }

  /**
   * The service url
   */
  @JsonProperty("service_url")
  @Override
  public @Nullable String getServiceUrl() {
    return serviceUrl;
  }

  /**
   * The url for the syslog_drain to direct to
   */
  @JsonProperty("syslog_drain_url")
  @Override
  public @Nullable String getSyslogDrainUrl() {
    return syslogDrainUrl;
  }

  /**
   * This instance is equal to all instances of {@code UnionServiceInstanceEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnionServiceInstanceEntity
        && equalTo((UnionServiceInstanceEntity) another);
  }

  private boolean equalTo(UnionServiceInstanceEntity another) {
    return Objects.equals(credentials, another.credentials)
        && Objects.equals(name, another.name)
        && Objects.equals(routesUrl, another.routesUrl)
        && Objects.equals(serviceBindingsUrl, another.serviceBindingsUrl)
        && Objects.equals(sharedFromUrl, another.sharedFromUrl)
        && Objects.equals(sharedToUrl, another.sharedToUrl)
        && Objects.equals(spaceId, another.spaceId)
        && Objects.equals(spaceUrl, another.spaceUrl)
        && Objects.equals(tags, another.tags)
        && Objects.equals(type, another.type)
        && Objects.equals(dashboardUrl, another.dashboardUrl)
        && Objects.equals(gatewayData, another.gatewayData)
        && Objects.equals(lastOperation, another.lastOperation)
        && Objects.equals(maintenanceInfo, another.maintenanceInfo)
        && Objects.equals(routeServiceUrl, another.routeServiceUrl)
        && Objects.equals(serviceId, another.serviceId)
        && Objects.equals(serviceInstanceParametersUrl, another.serviceInstanceParametersUrl)
        && Objects.equals(serviceKeysUrl, another.serviceKeysUrl)
        && Objects.equals(servicePlanId, another.servicePlanId)
        && Objects.equals(servicePlanUrl, another.servicePlanUrl)
        && Objects.equals(serviceUrl, another.serviceUrl)
        && Objects.equals(syslogDrainUrl, another.syslogDrainUrl);
  }

  /**
   * Computes a hash code from attributes: {@code credentials}, {@code name}, {@code routesUrl}, {@code serviceBindingsUrl}, {@code sharedFromUrl}, {@code sharedToUrl}, {@code spaceId}, {@code spaceUrl}, {@code tags}, {@code type}, {@code dashboardUrl}, {@code gatewayData}, {@code lastOperation}, {@code maintenanceInfo}, {@code routeServiceUrl}, {@code serviceId}, {@code serviceInstanceParametersUrl}, {@code serviceKeysUrl}, {@code servicePlanId}, {@code servicePlanUrl}, {@code serviceUrl}, {@code syslogDrainUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(credentials);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(routesUrl);
    h += (h << 5) + Objects.hashCode(serviceBindingsUrl);
    h += (h << 5) + Objects.hashCode(sharedFromUrl);
    h += (h << 5) + Objects.hashCode(sharedToUrl);
    h += (h << 5) + Objects.hashCode(spaceId);
    h += (h << 5) + Objects.hashCode(spaceUrl);
    h += (h << 5) + Objects.hashCode(tags);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(dashboardUrl);
    h += (h << 5) + Objects.hashCode(gatewayData);
    h += (h << 5) + Objects.hashCode(lastOperation);
    h += (h << 5) + Objects.hashCode(maintenanceInfo);
    h += (h << 5) + Objects.hashCode(routeServiceUrl);
    h += (h << 5) + Objects.hashCode(serviceId);
    h += (h << 5) + Objects.hashCode(serviceInstanceParametersUrl);
    h += (h << 5) + Objects.hashCode(serviceKeysUrl);
    h += (h << 5) + Objects.hashCode(servicePlanId);
    h += (h << 5) + Objects.hashCode(servicePlanUrl);
    h += (h << 5) + Objects.hashCode(serviceUrl);
    h += (h << 5) + Objects.hashCode(syslogDrainUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code UnionServiceInstanceEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnionServiceInstanceEntity{"
        + "credentials=" + credentials
        + ", name=" + name
        + ", routesUrl=" + routesUrl
        + ", serviceBindingsUrl=" + serviceBindingsUrl
        + ", sharedFromUrl=" + sharedFromUrl
        + ", sharedToUrl=" + sharedToUrl
        + ", spaceId=" + spaceId
        + ", spaceUrl=" + spaceUrl
        + ", tags=" + tags
        + ", type=" + type
        + ", dashboardUrl=" + dashboardUrl
        + ", gatewayData=" + gatewayData
        + ", lastOperation=" + lastOperation
        + ", maintenanceInfo=" + maintenanceInfo
        + ", routeServiceUrl=" + routeServiceUrl
        + ", serviceId=" + serviceId
        + ", serviceInstanceParametersUrl=" + serviceInstanceParametersUrl
        + ", serviceKeysUrl=" + serviceKeysUrl
        + ", servicePlanId=" + servicePlanId
        + ", servicePlanUrl=" + servicePlanUrl
        + ", serviceUrl=" + serviceUrl
        + ", syslogDrainUrl=" + syslogDrainUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UnionServiceInstanceEntity", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceinstances._UnionServiceInstanceEntity {
    Map<String, Object> credentials = null;
    String name;
    String routesUrl;
    String serviceBindingsUrl;
    String sharedFromUrl;
    String sharedToUrl;
    String spaceId;
    String spaceUrl;
    List<String> tags = null;
    String type;
    String dashboardUrl;
    GatewayData gatewayData;
    LastOperation lastOperation;
    MaintenanceInfo maintenanceInfo;
    String routeServiceUrl;
    String serviceId;
    String serviceInstanceParametersUrl;
    String serviceKeysUrl;
    String servicePlanId;
    String servicePlanUrl;
    String serviceUrl;
    String syslogDrainUrl;
    @JsonProperty("credentials")
    public void setCredentials(@Nullable Map<String, Object> credentials) {
      this.credentials = credentials;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("routes_url")
    public void setRoutesUrl(@Nullable String routesUrl) {
      this.routesUrl = routesUrl;
    }
    @JsonProperty("service_bindings_url")
    public void setServiceBindingsUrl(@Nullable String serviceBindingsUrl) {
      this.serviceBindingsUrl = serviceBindingsUrl;
    }
    @JsonProperty("shared_from_url")
    public void setSharedFromUrl(@Nullable String sharedFromUrl) {
      this.sharedFromUrl = sharedFromUrl;
    }
    @JsonProperty("shared_to_url")
    public void setSharedToUrl(@Nullable String sharedToUrl) {
      this.sharedToUrl = sharedToUrl;
    }
    @JsonProperty("space_guid")
    public void setSpaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
    }
    @JsonProperty("space_url")
    public void setSpaceUrl(@Nullable String spaceUrl) {
      this.spaceUrl = spaceUrl;
    }
    @JsonProperty("tags")
    public void setTags(@Nullable List<String> tags) {
      this.tags = tags;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("dashboard_url")
    public void setDashboardUrl(@Nullable String dashboardUrl) {
      this.dashboardUrl = dashboardUrl;
    }
    @JsonProperty("gateway_data")
    public void setGatewayData(@Nullable GatewayData gatewayData) {
      this.gatewayData = gatewayData;
    }
    @JsonProperty("last_operation")
    public void setLastOperation(@Nullable LastOperation lastOperation) {
      this.lastOperation = lastOperation;
    }
    @JsonProperty("maintenance_info")
    public void setMaintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
    }
    @JsonProperty("route_service_url")
    public void setRouteServiceUrl(@Nullable String routeServiceUrl) {
      this.routeServiceUrl = routeServiceUrl;
    }
    @JsonProperty("service_guid")
    public void setServiceId(@Nullable String serviceId) {
      this.serviceId = serviceId;
    }
    @JsonProperty("service_instance_parameters_url")
    public void setServiceInstanceParametersUrl(@Nullable String serviceInstanceParametersUrl) {
      this.serviceInstanceParametersUrl = serviceInstanceParametersUrl;
    }
    @JsonProperty("service_keys_url")
    public void setServiceKeysUrl(@Nullable String serviceKeysUrl) {
      this.serviceKeysUrl = serviceKeysUrl;
    }
    @JsonProperty("service_plan_guid")
    public void setServicePlanId(@Nullable String servicePlanId) {
      this.servicePlanId = servicePlanId;
    }
    @JsonProperty("service_plan_url")
    public void setServicePlanUrl(@Nullable String servicePlanUrl) {
      this.servicePlanUrl = servicePlanUrl;
    }
    @JsonProperty("service_url")
    public void setServiceUrl(@Nullable String serviceUrl) {
      this.serviceUrl = serviceUrl;
    }
    @JsonProperty("syslog_drain_url")
    public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
    }
    @Override
    public Map<String, Object> getCredentials() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getRoutesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceBindingsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSharedFromUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSharedToUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getDashboardUrl() { throw new UnsupportedOperationException(); }
    @Override
    public GatewayData getGatewayData() { throw new UnsupportedOperationException(); }
    @Override
    public LastOperation getLastOperation() { throw new UnsupportedOperationException(); }
    @Override
    public MaintenanceInfo getMaintenanceInfo() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouteServiceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstanceParametersUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceKeysUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServicePlanId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServicePlanUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSyslogDrainUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UnionServiceInstanceEntity fromJson(Json json) {
    UnionServiceInstanceEntity.Builder builder = UnionServiceInstanceEntity.builder();
    if (json.credentials != null) {
      builder.putAllCredentials(json.credentials);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.routesUrl != null) {
      builder.routesUrl(json.routesUrl);
    }
    if (json.serviceBindingsUrl != null) {
      builder.serviceBindingsUrl(json.serviceBindingsUrl);
    }
    if (json.sharedFromUrl != null) {
      builder.sharedFromUrl(json.sharedFromUrl);
    }
    if (json.sharedToUrl != null) {
      builder.sharedToUrl(json.sharedToUrl);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    if (json.spaceUrl != null) {
      builder.spaceUrl(json.spaceUrl);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.dashboardUrl != null) {
      builder.dashboardUrl(json.dashboardUrl);
    }
    if (json.gatewayData != null) {
      builder.gatewayData(json.gatewayData);
    }
    if (json.lastOperation != null) {
      builder.lastOperation(json.lastOperation);
    }
    if (json.maintenanceInfo != null) {
      builder.maintenanceInfo(json.maintenanceInfo);
    }
    if (json.routeServiceUrl != null) {
      builder.routeServiceUrl(json.routeServiceUrl);
    }
    if (json.serviceId != null) {
      builder.serviceId(json.serviceId);
    }
    if (json.serviceInstanceParametersUrl != null) {
      builder.serviceInstanceParametersUrl(json.serviceInstanceParametersUrl);
    }
    if (json.serviceKeysUrl != null) {
      builder.serviceKeysUrl(json.serviceKeysUrl);
    }
    if (json.servicePlanId != null) {
      builder.servicePlanId(json.servicePlanId);
    }
    if (json.servicePlanUrl != null) {
      builder.servicePlanUrl(json.servicePlanUrl);
    }
    if (json.serviceUrl != null) {
      builder.serviceUrl(json.serviceUrl);
    }
    if (json.syslogDrainUrl != null) {
      builder.syslogDrainUrl(json.syslogDrainUrl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UnionServiceInstanceEntity UnionServiceInstanceEntity}.
   * <pre>
   * UnionServiceInstanceEntity.builder()
   *    .credentials(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link UnionServiceInstanceEntity#getCredentials() credentials}
   *    .name(String | null) // nullable {@link UnionServiceInstanceEntity#getName() name}
   *    .routesUrl(String | null) // nullable {@link UnionServiceInstanceEntity#getRoutesUrl() routesUrl}
   *    .serviceBindingsUrl(String | null) // nullable {@link UnionServiceInstanceEntity#getServiceBindingsUrl() serviceBindingsUrl}
   *    .sharedFromUrl(String | null) // nullable {@link UnionServiceInstanceEntity#getSharedFromUrl() sharedFromUrl}
   *    .sharedToUrl(String | null) // nullable {@link UnionServiceInstanceEntity#getSharedToUrl() sharedToUrl}
   *    .spaceId(String | null) // nullable {@link UnionServiceInstanceEntity#getSpaceId() spaceId}
   *    .spaceUrl(String | null) // nullable {@link UnionServiceInstanceEntity#getSpaceUrl() spaceUrl}
   *    .tags(List&amp;lt;String&amp;gt; | null) // nullable {@link UnionServiceInstanceEntity#getTags() tags}
   *    .type(String | null) // nullable {@link UnionServiceInstanceEntity#getType() type}
   *    .dashboardUrl(String | null) // nullable {@link UnionServiceInstanceEntity#getDashboardUrl() dashboardUrl}
   *    .gatewayData(org.cloudfoundry.client.v2.serviceinstances.GatewayData | null) // nullable {@link UnionServiceInstanceEntity#getGatewayData() gatewayData}
   *    .lastOperation(org.cloudfoundry.client.v2.serviceinstances.LastOperation | null) // nullable {@link UnionServiceInstanceEntity#getLastOperation() lastOperation}
   *    .maintenanceInfo(org.cloudfoundry.client.v2.MaintenanceInfo | null) // nullable {@link UnionServiceInstanceEntity#getMaintenanceInfo() maintenanceInfo}
   *    .routeServiceUrl(String | null) // nullable {@link UnionServiceInstanceEntity#getRouteServiceUrl() routeServiceUrl}
   *    .serviceId(String | null) // nullable {@link UnionServiceInstanceEntity#getServiceId() serviceId}
   *    .serviceInstanceParametersUrl(String | null) // nullable {@link UnionServiceInstanceEntity#getServiceInstanceParametersUrl() serviceInstanceParametersUrl}
   *    .serviceKeysUrl(String | null) // nullable {@link UnionServiceInstanceEntity#getServiceKeysUrl() serviceKeysUrl}
   *    .servicePlanId(String | null) // nullable {@link UnionServiceInstanceEntity#getServicePlanId() servicePlanId}
   *    .servicePlanUrl(String | null) // nullable {@link UnionServiceInstanceEntity#getServicePlanUrl() servicePlanUrl}
   *    .serviceUrl(String | null) // nullable {@link UnionServiceInstanceEntity#getServiceUrl() serviceUrl}
   *    .syslogDrainUrl(String | null) // nullable {@link UnionServiceInstanceEntity#getSyslogDrainUrl() syslogDrainUrl}
   *    .build();
   * </pre>
   * @return A new UnionServiceInstanceEntity builder
   */
  public static UnionServiceInstanceEntity.Builder builder() {
    return new UnionServiceInstanceEntity.Builder();
  }

  /**
   * Builds instances of type {@link UnionServiceInstanceEntity UnionServiceInstanceEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UnionServiceInstanceEntity", generator = "Immutables")
  public static final class Builder {
    private Map<String, Object> credentials = null;
    private String name;
    private String routesUrl;
    private String serviceBindingsUrl;
    private String sharedFromUrl;
    private String sharedToUrl;
    private String spaceId;
    private String spaceUrl;
    private List<String> tags = null;
    private String type;
    private String dashboardUrl;
    private GatewayData gatewayData;
    private LastOperation lastOperation;
    private MaintenanceInfo maintenanceInfo;
    private String routeServiceUrl;
    private String serviceId;
    private String serviceInstanceParametersUrl;
    private String serviceKeysUrl;
    private String servicePlanId;
    private String servicePlanUrl;
    private String serviceUrl;
    private String syslogDrainUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnionServiceInstanceEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnionServiceInstanceEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UnionServiceInstanceEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UnionServiceInstanceEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.serviceinstances.BaseServiceInstanceEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BaseServiceInstanceEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v2.serviceinstances._UnionServiceInstanceEntity) {
        org.cloudfoundry.client.v2.serviceinstances._UnionServiceInstanceEntity instance = (org.cloudfoundry.client.v2.serviceinstances._UnionServiceInstanceEntity) object;
        String dashboardUrlValue = instance.getDashboardUrl();
        if (dashboardUrlValue != null) {
          dashboardUrl(dashboardUrlValue);
        }
        LastOperation lastOperationValue = instance.getLastOperation();
        if (lastOperationValue != null) {
          lastOperation(lastOperationValue);
        }
        String serviceKeysUrlValue = instance.getServiceKeysUrl();
        if (serviceKeysUrlValue != null) {
          serviceKeysUrl(serviceKeysUrlValue);
        }
        String serviceUrlValue = instance.getServiceUrl();
        if (serviceUrlValue != null) {
          serviceUrl(serviceUrlValue);
        }
        String serviceInstanceParametersUrlValue = instance.getServiceInstanceParametersUrl();
        if (serviceInstanceParametersUrlValue != null) {
          serviceInstanceParametersUrl(serviceInstanceParametersUrlValue);
        }
        GatewayData gatewayDataValue = instance.getGatewayData();
        if (gatewayDataValue != null) {
          gatewayData(gatewayDataValue);
        }
        String servicePlanIdValue = instance.getServicePlanId();
        if (servicePlanIdValue != null) {
          servicePlanId(servicePlanIdValue);
        }
        String routeServiceUrlValue = instance.getRouteServiceUrl();
        if (routeServiceUrlValue != null) {
          routeServiceUrl(routeServiceUrlValue);
        }
        String serviceIdValue = instance.getServiceId();
        if (serviceIdValue != null) {
          serviceId(serviceIdValue);
        }
        MaintenanceInfo maintenanceInfoValue = instance.getMaintenanceInfo();
        if (maintenanceInfoValue != null) {
          maintenanceInfo(maintenanceInfoValue);
        }
        String syslogDrainUrlValue = instance.getSyslogDrainUrl();
        if (syslogDrainUrlValue != null) {
          syslogDrainUrl(syslogDrainUrlValue);
        }
        String servicePlanUrlValue = instance.getServicePlanUrl();
        if (servicePlanUrlValue != null) {
          servicePlanUrl(servicePlanUrlValue);
        }
      }
      if (object instanceof BaseServiceInstanceEntity) {
        BaseServiceInstanceEntity instance = (BaseServiceInstanceEntity) object;
        String spaceUrlValue = instance.getSpaceUrl();
        if (spaceUrlValue != null) {
          spaceUrl(spaceUrlValue);
        }
        String spaceIdValue = instance.getSpaceId();
        if (spaceIdValue != null) {
          spaceId(spaceIdValue);
        }
        String sharedFromUrlValue = instance.getSharedFromUrl();
        if (sharedFromUrlValue != null) {
          sharedFromUrl(sharedFromUrlValue);
        }
        Map<String, Object> credentialsValue = instance.getCredentials();
        if (credentialsValue != null) {
          putAllCredentials(credentialsValue);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        String serviceBindingsUrlValue = instance.getServiceBindingsUrl();
        if (serviceBindingsUrlValue != null) {
          serviceBindingsUrl(serviceBindingsUrlValue);
        }
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
        String sharedToUrlValue = instance.getSharedToUrl();
        if (sharedToUrlValue != null) {
          sharedToUrl(sharedToUrlValue);
        }
        String routesUrlValue = instance.getRoutesUrl();
        if (routesUrlValue != null) {
          routesUrl(routesUrlValue);
        }
        List<String> tagsValue = instance.getTags();
        if (tagsValue != null) {
          addAllTags(tagsValue);
        }
      }
    }

    /**
     * Put one entry to the {@link UnionServiceInstanceEntity#getCredentials() credentials} map.
     * @param key The key in the credentials map
     * @param value The associated value in the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(String key, Object value) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      this.credentials.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UnionServiceInstanceEntity#getCredentials() credentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(Map.Entry<String, ? extends Object> entry) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.credentials.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UnionServiceInstanceEntity#getCredentials() credentials} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("credentials")
    public final Builder credentials(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.credentials = null;
        return this;
      }
      this.credentials = new LinkedHashMap<String, Object>();
      return putAllCredentials(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UnionServiceInstanceEntity#getCredentials() credentials} map. Nulls are not permitted
     * @param entries The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredentials(Map<String, ? extends Object> entries) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.credentials.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getRoutesUrl() routesUrl} attribute.
     * @param routesUrl The value for routesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("routes_url")
    public final Builder routesUrl(@Nullable String routesUrl) {
      this.routesUrl = routesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getServiceBindingsUrl() serviceBindingsUrl} attribute.
     * @param serviceBindingsUrl The value for serviceBindingsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_bindings_url")
    public final Builder serviceBindingsUrl(@Nullable String serviceBindingsUrl) {
      this.serviceBindingsUrl = serviceBindingsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getSharedFromUrl() sharedFromUrl} attribute.
     * @param sharedFromUrl The value for sharedFromUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("shared_from_url")
    public final Builder sharedFromUrl(@Nullable String sharedFromUrl) {
      this.sharedFromUrl = sharedFromUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getSharedToUrl() sharedToUrl} attribute.
     * @param sharedToUrl The value for sharedToUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("shared_to_url")
    public final Builder sharedToUrl(@Nullable String sharedToUrl) {
      this.sharedToUrl = sharedToUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_guid")
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getSpaceUrl() spaceUrl} attribute.
     * @param spaceUrl The value for spaceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_url")
    public final Builder spaceUrl(@Nullable String spaceUrl) {
      this.spaceUrl = spaceUrl;
      return this;
    }

    /**
     * Adds one element to {@link UnionServiceInstanceEntity#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String element) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link UnionServiceInstanceEntity#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(String... elements) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UnionServiceInstanceEntity#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tags")
    public final Builder tags(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.tags = null;
        return this;
      }
      this.tags = new ArrayList<String>();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link UnionServiceInstanceEntity#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      Objects.requireNonNull(elements, "tags element");
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getDashboardUrl() dashboardUrl} attribute.
     * @param dashboardUrl The value for dashboardUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dashboard_url")
    public final Builder dashboardUrl(@Nullable String dashboardUrl) {
      this.dashboardUrl = dashboardUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getGatewayData() gatewayData} attribute.
     * @param gatewayData The value for gatewayData (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("gateway_data")
    @Deprecated
    public final Builder gatewayData(@Nullable GatewayData gatewayData) {
      this.gatewayData = gatewayData;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getLastOperation() lastOperation} attribute.
     * @param lastOperation The value for lastOperation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("last_operation")
    public final Builder lastOperation(@Nullable LastOperation lastOperation) {
      this.lastOperation = lastOperation;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getMaintenanceInfo() maintenanceInfo} attribute.
     * @param maintenanceInfo The value for maintenanceInfo (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("maintenance_info")
    public final Builder maintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getRouteServiceUrl() routeServiceUrl} attribute.
     * @param routeServiceUrl The value for routeServiceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("route_service_url")
    public final Builder routeServiceUrl(@Nullable String routeServiceUrl) {
      this.routeServiceUrl = routeServiceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getServiceId() serviceId} attribute.
     * @param serviceId The value for serviceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_guid")
    public final Builder serviceId(@Nullable String serviceId) {
      this.serviceId = serviceId;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getServiceInstanceParametersUrl() serviceInstanceParametersUrl} attribute.
     * @param serviceInstanceParametersUrl The value for serviceInstanceParametersUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_instance_parameters_url")
    public final Builder serviceInstanceParametersUrl(@Nullable String serviceInstanceParametersUrl) {
      this.serviceInstanceParametersUrl = serviceInstanceParametersUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getServiceKeysUrl() serviceKeysUrl} attribute.
     * @param serviceKeysUrl The value for serviceKeysUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_keys_url")
    public final Builder serviceKeysUrl(@Nullable String serviceKeysUrl) {
      this.serviceKeysUrl = serviceKeysUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getServicePlanId() servicePlanId} attribute.
     * @param servicePlanId The value for servicePlanId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_plan_guid")
    public final Builder servicePlanId(@Nullable String servicePlanId) {
      this.servicePlanId = servicePlanId;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getServicePlanUrl() servicePlanUrl} attribute.
     * @param servicePlanUrl The value for servicePlanUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_plan_url")
    public final Builder servicePlanUrl(@Nullable String servicePlanUrl) {
      this.servicePlanUrl = servicePlanUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getServiceUrl() serviceUrl} attribute.
     * @param serviceUrl The value for serviceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_url")
    public final Builder serviceUrl(@Nullable String serviceUrl) {
      this.serviceUrl = serviceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UnionServiceInstanceEntity#getSyslogDrainUrl() syslogDrainUrl} attribute.
     * @param syslogDrainUrl The value for syslogDrainUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("syslog_drain_url")
    public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
      return this;
    }

    /**
     * Builds a new {@link UnionServiceInstanceEntity UnionServiceInstanceEntity}.
     * @return An immutable instance of UnionServiceInstanceEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnionServiceInstanceEntity build() {
      return new UnionServiceInstanceEntity(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
