package org.cloudfoundry.client.v2.spacequotadefinitions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;
import org.immutables.value.Generated;

/**
 * The response payload for the Update a Space Quota Definition operation
 */
@Generated(from = "_UpdateSpaceQuotaDefinitionResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateSpaceQuotaDefinitionResponse
    extends org.cloudfoundry.client.v2.spacequotadefinitions._UpdateSpaceQuotaDefinitionResponse {
  private final @Nullable SpaceQuotaDefinitionEntity entity;
  private final @Nullable Metadata metadata;

  private UpdateSpaceQuotaDefinitionResponse(UpdateSpaceQuotaDefinitionResponse.Builder builder) {
    this.entity = builder.entity;
    this.metadata = builder.metadata;
  }

  /**
   * The resource's entity
   */
  @JsonProperty("entity")
  @Override
  public @Nullable SpaceQuotaDefinitionEntity getEntity() {
    return entity;
  }

  /**
   * The resource's metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * This instance is equal to all instances of {@code UpdateSpaceQuotaDefinitionResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateSpaceQuotaDefinitionResponse
        && equalTo((UpdateSpaceQuotaDefinitionResponse) another);
  }

  private boolean equalTo(UpdateSpaceQuotaDefinitionResponse another) {
    return Objects.equals(entity, another.entity)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code entity}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(entity);
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateSpaceQuotaDefinitionResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateSpaceQuotaDefinitionResponse{"
        + "entity=" + entity
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateSpaceQuotaDefinitionResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.spacequotadefinitions._UpdateSpaceQuotaDefinitionResponse {
    SpaceQuotaDefinitionEntity entity;
    Metadata metadata;
    @JsonProperty("entity")
    public void setEntity(@Nullable SpaceQuotaDefinitionEntity entity) {
      this.entity = entity;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public SpaceQuotaDefinitionEntity getEntity() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateSpaceQuotaDefinitionResponse fromJson(Json json) {
    UpdateSpaceQuotaDefinitionResponse.Builder builder = UpdateSpaceQuotaDefinitionResponse.builder();
    if (json.entity != null) {
      builder.entity(json.entity);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateSpaceQuotaDefinitionResponse UpdateSpaceQuotaDefinitionResponse}.
   * <pre>
   * UpdateSpaceQuotaDefinitionResponse.builder()
   *    .entity(org.cloudfoundry.client.v2.spacequotadefinitions.SpaceQuotaDefinitionEntity | null) // nullable {@link UpdateSpaceQuotaDefinitionResponse#getEntity() entity}
   *    .metadata(org.cloudfoundry.client.v2.Metadata | null) // nullable {@link UpdateSpaceQuotaDefinitionResponse#getMetadata() metadata}
   *    .build();
   * </pre>
   * @return A new UpdateSpaceQuotaDefinitionResponse builder
   */
  public static UpdateSpaceQuotaDefinitionResponse.Builder builder() {
    return new UpdateSpaceQuotaDefinitionResponse.Builder();
  }

  /**
   * Builds instances of type {@link UpdateSpaceQuotaDefinitionResponse UpdateSpaceQuotaDefinitionResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateSpaceQuotaDefinitionResponse", generator = "Immutables")
  public static final class Builder {
    private SpaceQuotaDefinitionEntity entity;
    private Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateSpaceQuotaDefinitionResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateSpaceQuotaDefinitionResponse instance) {
      return from((_UpdateSpaceQuotaDefinitionResponse) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateSpaceQuotaDefinitionResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateSpaceQuotaDefinitionResponse instance) {
      Objects.requireNonNull(instance, "instance");
      SpaceQuotaDefinitionEntity entityValue = instance.getEntity();
      if (entityValue != null) {
        entity(entityValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceQuotaDefinitionResponse#getEntity() entity} attribute.
     * @param entity The value for entity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("entity")
    public final Builder entity(@Nullable SpaceQuotaDefinitionEntity entity) {
      this.entity = entity;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateSpaceQuotaDefinitionResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Builds a new {@link UpdateSpaceQuotaDefinitionResponse UpdateSpaceQuotaDefinitionResponse}.
     * @return An immutable instance of UpdateSpaceQuotaDefinitionResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateSpaceQuotaDefinitionResponse build() {
      return new UpdateSpaceQuotaDefinitionResponse(this);
    }
  }
}
