package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Remove Auditor from the Space operation
 */
@Generated(from = "_RemoveSpaceAuditorRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RemoveSpaceAuditorRequest
    extends org.cloudfoundry.client.v2.spaces._RemoveSpaceAuditorRequest {
  private final String auditorId;
  private final String spaceId;

  private RemoveSpaceAuditorRequest(RemoveSpaceAuditorRequest.Builder builder) {
    this.auditorId = builder.auditorId;
    this.spaceId = builder.spaceId;
  }

  /**
   * The auditor id
   */
  @Override
  public String getAuditorId() {
    return auditorId;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code RemoveSpaceAuditorRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RemoveSpaceAuditorRequest
        && equalTo((RemoveSpaceAuditorRequest) another);
  }

  private boolean equalTo(RemoveSpaceAuditorRequest another) {
    return auditorId.equals(another.auditorId)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code auditorId}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + auditorId.hashCode();
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RemoveSpaceAuditorRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoveSpaceAuditorRequest{"
        + "auditorId=" + auditorId
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link RemoveSpaceAuditorRequest RemoveSpaceAuditorRequest}.
   * <pre>
   * RemoveSpaceAuditorRequest.builder()
   *    .auditorId(String) // required {@link RemoveSpaceAuditorRequest#getAuditorId() auditorId}
   *    .spaceId(String) // required {@link RemoveSpaceAuditorRequest#getSpaceId() spaceId}
   *    .build();
   * </pre>
   * @return A new RemoveSpaceAuditorRequest builder
   */
  public static RemoveSpaceAuditorRequest.Builder builder() {
    return new RemoveSpaceAuditorRequest.Builder();
  }

  /**
   * Builds instances of type {@link RemoveSpaceAuditorRequest RemoveSpaceAuditorRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RemoveSpaceAuditorRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_AUDITOR_ID = 0x1L;
    private static final long INIT_BIT_SPACE_ID = 0x2L;
    private long initBits = 0x3L;

    private String auditorId;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoveSpaceAuditorRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RemoveSpaceAuditorRequest instance) {
      return from((_RemoveSpaceAuditorRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RemoveSpaceAuditorRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RemoveSpaceAuditorRequest instance) {
      Objects.requireNonNull(instance, "instance");
      auditorId(instance.getAuditorId());
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveSpaceAuditorRequest#getAuditorId() auditorId} attribute.
     * @param auditorId The value for auditorId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorId(String auditorId) {
      this.auditorId = Objects.requireNonNull(auditorId, "auditorId");
      initBits &= ~INIT_BIT_AUDITOR_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoveSpaceAuditorRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link RemoveSpaceAuditorRequest RemoveSpaceAuditorRequest}.
     * @return An immutable instance of RemoveSpaceAuditorRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RemoveSpaceAuditorRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RemoveSpaceAuditorRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AUDITOR_ID) != 0) attributes.add("auditorId");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build RemoveSpaceAuditorRequest, some of required attributes are not set " + attributes;
    }
  }
}
