package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Update User Provided Service Instance
 */
@Generated(from = "_UpdateUserProvidedServiceInstanceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateUserProvidedServiceInstanceRequest
    extends org.cloudfoundry.client.v2.userprovidedserviceinstances._UpdateUserProvidedServiceInstanceRequest {
  private final @Nullable Map<String, Object> credentials;
  private final @Nullable String name;
  private final @Nullable String routeServiceUrl;
  private final @Nullable String syslogDrainUrl;
  private final @Nullable List<String> tags;
  private final String userProvidedServiceInstanceId;

  private UpdateUserProvidedServiceInstanceRequest(UpdateUserProvidedServiceInstanceRequest.Builder builder) {
    this.credentials = builder.credentials == null ? null : createUnmodifiableMap(false, false, builder.credentials);
    this.name = builder.name;
    this.routeServiceUrl = builder.routeServiceUrl;
    this.syslogDrainUrl = builder.syslogDrainUrl;
    this.tags = builder.tags == null ? null : createUnmodifiableList(true, builder.tags);
    this.userProvidedServiceInstanceId = builder.userProvidedServiceInstanceId;
  }

  /**
   * Key/value pairs that can be stored to store credentials
   */
  @JsonProperty("credentials")
  @Override
  public @Nullable Map<String, Object> getCredentials() {
    return credentials;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * URL to which requests for bound routes will be forwarded
   */
  @JsonProperty("route_service_url")
  @Override
  public @Nullable String getRouteServiceUrl() {
    return routeServiceUrl;
  }

  /**
   * The url for the syslog_drain to direct to
   */
  @JsonProperty("syslog_drain_url")
  @Override
  public @Nullable String getSyslogDrainUrl() {
    return syslogDrainUrl;
  }

  /**
   * The tags
   */
  @JsonProperty
  @Override
  public @Nullable List<String> getTags() {
    return tags;
  }

  /**
   * The user provided service instance id
   */
  @JsonProperty("userProvidedServiceInstanceId")
  @JsonIgnore
  @Override
  public String getUserProvidedServiceInstanceId() {
    return userProvidedServiceInstanceId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateUserProvidedServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateUserProvidedServiceInstanceRequest
        && equalTo((UpdateUserProvidedServiceInstanceRequest) another);
  }

  private boolean equalTo(UpdateUserProvidedServiceInstanceRequest another) {
    return Objects.equals(credentials, another.credentials)
        && Objects.equals(name, another.name)
        && Objects.equals(routeServiceUrl, another.routeServiceUrl)
        && Objects.equals(syslogDrainUrl, another.syslogDrainUrl)
        && Objects.equals(tags, another.tags)
        && userProvidedServiceInstanceId.equals(another.userProvidedServiceInstanceId);
  }

  /**
   * Computes a hash code from attributes: {@code credentials}, {@code name}, {@code routeServiceUrl}, {@code syslogDrainUrl}, {@code tags}, {@code userProvidedServiceInstanceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(credentials);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(routeServiceUrl);
    h += (h << 5) + Objects.hashCode(syslogDrainUrl);
    h += (h << 5) + Objects.hashCode(tags);
    h += (h << 5) + userProvidedServiceInstanceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateUserProvidedServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateUserProvidedServiceInstanceRequest{"
        + "credentials=" + credentials
        + ", name=" + name
        + ", routeServiceUrl=" + routeServiceUrl
        + ", syslogDrainUrl=" + syslogDrainUrl
        + ", tags=" + tags
        + ", userProvidedServiceInstanceId=" + userProvidedServiceInstanceId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateUserProvidedServiceInstanceRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.userprovidedserviceinstances._UpdateUserProvidedServiceInstanceRequest {
    Map<String, Object> credentials = null;
    String name;
    String routeServiceUrl;
    String syslogDrainUrl;
    List<String> tags = null;
    String userProvidedServiceInstanceId;
    @JsonProperty("credentials")
    public void setCredentials(@Nullable Map<String, Object> credentials) {
      this.credentials = credentials;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("route_service_url")
    public void setRouteServiceUrl(@Nullable String routeServiceUrl) {
      this.routeServiceUrl = routeServiceUrl;
    }
    @JsonProperty("syslog_drain_url")
    public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
    }
    @JsonProperty
    public void setTags(@Nullable List<String> tags) {
      this.tags = tags;
    }
    @JsonProperty("userProvidedServiceInstanceId")
    @JsonIgnore
    public void setUserProvidedServiceInstanceId(String userProvidedServiceInstanceId) {
      this.userProvidedServiceInstanceId = userProvidedServiceInstanceId;
    }
    @Override
    public Map<String, Object> getCredentials() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouteServiceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSyslogDrainUrl() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserProvidedServiceInstanceId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateUserProvidedServiceInstanceRequest fromJson(Json json) {
    UpdateUserProvidedServiceInstanceRequest.Builder builder = UpdateUserProvidedServiceInstanceRequest.builder();
    if (json.credentials != null) {
      builder.putAllCredentials(json.credentials);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.routeServiceUrl != null) {
      builder.routeServiceUrl(json.routeServiceUrl);
    }
    if (json.syslogDrainUrl != null) {
      builder.syslogDrainUrl(json.syslogDrainUrl);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    if (json.userProvidedServiceInstanceId != null) {
      builder.userProvidedServiceInstanceId(json.userProvidedServiceInstanceId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateUserProvidedServiceInstanceRequest UpdateUserProvidedServiceInstanceRequest}.
   * <pre>
   * UpdateUserProvidedServiceInstanceRequest.builder()
   *    .credentials(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link UpdateUserProvidedServiceInstanceRequest#getCredentials() credentials}
   *    .name(String | null) // nullable {@link UpdateUserProvidedServiceInstanceRequest#getName() name}
   *    .routeServiceUrl(String | null) // nullable {@link UpdateUserProvidedServiceInstanceRequest#getRouteServiceUrl() routeServiceUrl}
   *    .syslogDrainUrl(String | null) // nullable {@link UpdateUserProvidedServiceInstanceRequest#getSyslogDrainUrl() syslogDrainUrl}
   *    .tags(List&amp;lt;String&amp;gt; | null) // nullable {@link UpdateUserProvidedServiceInstanceRequest#getTags() tags}
   *    .userProvidedServiceInstanceId(String) // required {@link UpdateUserProvidedServiceInstanceRequest#getUserProvidedServiceInstanceId() userProvidedServiceInstanceId}
   *    .build();
   * </pre>
   * @return A new UpdateUserProvidedServiceInstanceRequest builder
   */
  public static UpdateUserProvidedServiceInstanceRequest.Builder builder() {
    return new UpdateUserProvidedServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateUserProvidedServiceInstanceRequest UpdateUserProvidedServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateUserProvidedServiceInstanceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID = 0x1L;
    private long initBits = 0x1L;

    private Map<String, Object> credentials = null;
    private String name;
    private String routeServiceUrl;
    private String syslogDrainUrl;
    private List<String> tags = null;
    private String userProvidedServiceInstanceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateUserProvidedServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateUserProvidedServiceInstanceRequest instance) {
      return from((_UpdateUserProvidedServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateUserProvidedServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateUserProvidedServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, Object> credentialsValue = instance.getCredentials();
      if (credentialsValue != null) {
        putAllCredentials(credentialsValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String routeServiceUrlValue = instance.getRouteServiceUrl();
      if (routeServiceUrlValue != null) {
        routeServiceUrl(routeServiceUrlValue);
      }
      String syslogDrainUrlValue = instance.getSyslogDrainUrl();
      if (syslogDrainUrlValue != null) {
        syslogDrainUrl(syslogDrainUrlValue);
      }
      List<String> tagsValue = instance.getTags();
      if (tagsValue != null) {
        addAllTags(tagsValue);
      }
      userProvidedServiceInstanceId(instance.getUserProvidedServiceInstanceId());
      return this;
    }

    /**
     * Put one entry to the {@link UpdateUserProvidedServiceInstanceRequest#getCredentials() credentials} map.
     * @param key The key in the credentials map
     * @param value The associated value in the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(String key, Object value) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      this.credentials.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UpdateUserProvidedServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(Map.Entry<String, ? extends Object> entry) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.credentials.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UpdateUserProvidedServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credentials(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.credentials = null;
        return this;
      }
      this.credentials = new LinkedHashMap<String, Object>();
      return putAllCredentials(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UpdateUserProvidedServiceInstanceRequest#getCredentials() credentials} map. Nulls are not permitted
     * @param entries The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredentials(Map<String, ? extends Object> entries) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.credentials.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateUserProvidedServiceInstanceRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateUserProvidedServiceInstanceRequest#getRouteServiceUrl() routeServiceUrl} attribute.
     * @param routeServiceUrl The value for routeServiceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeServiceUrl(@Nullable String routeServiceUrl) {
      this.routeServiceUrl = routeServiceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateUserProvidedServiceInstanceRequest#getSyslogDrainUrl() syslogDrainUrl} attribute.
     * @param syslogDrainUrl The value for syslogDrainUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
      return this;
    }

    /**
     * Adds one element to {@link UpdateUserProvidedServiceInstanceRequest#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String element) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateUserProvidedServiceInstanceRequest#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(String... elements) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateUserProvidedServiceInstanceRequest#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.tags = null;
        return this;
      }
      this.tags = new ArrayList<String>();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link UpdateUserProvidedServiceInstanceRequest#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      Objects.requireNonNull(elements, "tags element");
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateUserProvidedServiceInstanceRequest#getUserProvidedServiceInstanceId() userProvidedServiceInstanceId} attribute.
     * @param userProvidedServiceInstanceId The value for userProvidedServiceInstanceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userProvidedServiceInstanceId(String userProvidedServiceInstanceId) {
      this.userProvidedServiceInstanceId = Objects.requireNonNull(userProvidedServiceInstanceId, "userProvidedServiceInstanceId");
      initBits &= ~INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateUserProvidedServiceInstanceRequest UpdateUserProvidedServiceInstanceRequest}.
     * @return An immutable instance of UpdateUserProvidedServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateUserProvidedServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateUserProvidedServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID) != 0) attributes.add("userProvidedServiceInstanceId");
      return "Cannot build UpdateUserProvidedServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
