package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The entity representing service plan maintenance info
 */
@Generated(from = "_MaintenanceInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class MaintenanceInfo extends org.cloudfoundry.client.v3._MaintenanceInfo {
  private final @Nullable String description;
  private final @Nullable String version;

  private MaintenanceInfo(MaintenanceInfo.Builder builder) {
    this.description = builder.description;
    this.version = builder.version;
  }

  /**
   * The description
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The version
   */
  @JsonProperty("version")
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code MaintenanceInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof MaintenanceInfo
        && equalTo((MaintenanceInfo) another);
  }

  private boolean equalTo(MaintenanceInfo another) {
    return Objects.equals(description, another.description)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code MaintenanceInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MaintenanceInfo{"
        + "description=" + description
        + ", version=" + version
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_MaintenanceInfo", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._MaintenanceInfo {
    String description;
    String version;
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("version")
    public void setVersion(@Nullable String version) {
      this.version = version;
    }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static MaintenanceInfo fromJson(Json json) {
    MaintenanceInfo.Builder builder = MaintenanceInfo.builder();
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link MaintenanceInfo MaintenanceInfo}.
   * <pre>
   * MaintenanceInfo.builder()
   *    .description(String | null) // nullable {@link MaintenanceInfo#getDescription() description}
   *    .version(String | null) // nullable {@link MaintenanceInfo#getVersion() version}
   *    .build();
   * </pre>
   * @return A new MaintenanceInfo builder
   */
  public static MaintenanceInfo.Builder builder() {
    return new MaintenanceInfo.Builder();
  }

  /**
   * Builds instances of type {@link MaintenanceInfo MaintenanceInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_MaintenanceInfo", generator = "Immutables")
  public static final class Builder {
    private String description;
    private String version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MaintenanceInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MaintenanceInfo instance) {
      return from((_MaintenanceInfo) instance);
    }

    /**
     * Copy abstract value type {@code _MaintenanceInfo} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_MaintenanceInfo instance) {
      Objects.requireNonNull(instance, "instance");
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      String versionValue = instance.getVersion();
      if (versionValue != null) {
        version(versionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MaintenanceInfo#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link MaintenanceInfo#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }

    /**
     * Builds a new {@link MaintenanceInfo MaintenanceInfo}.
     * @return An immutable instance of MaintenanceInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public MaintenanceInfo build() {
      return new MaintenanceInfo(this);
    }
  }
}
