package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Represents a summary of resource usage
 */
@Generated(from = "_UsageSummary", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UsageSummary extends org.cloudfoundry.client.v3._UsageSummary {
  private final Integer memoryInMb;
  private final Integer startedInstances;

  private UsageSummary(UsageSummary.Builder builder) {
    this.memoryInMb = builder.memoryInMb;
    this.startedInstances = builder.startedInstances;
  }

  /**
   * The total memory usage
   */
  @JsonProperty("memory_in_mb")
  @Override
  public Integer getMemoryInMb() {
    return memoryInMb;
  }

  /**
   * The number of started instances
   */
  @JsonProperty("started_instances")
  @Override
  public Integer getStartedInstances() {
    return startedInstances;
  }

  /**
   * This instance is equal to all instances of {@code UsageSummary} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UsageSummary
        && equalTo((UsageSummary) another);
  }

  private boolean equalTo(UsageSummary another) {
    return memoryInMb.equals(another.memoryInMb)
        && startedInstances.equals(another.startedInstances);
  }

  /**
   * Computes a hash code from attributes: {@code memoryInMb}, {@code startedInstances}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + memoryInMb.hashCode();
    h += (h << 5) + startedInstances.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UsageSummary} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UsageSummary{"
        + "memoryInMb=" + memoryInMb
        + ", startedInstances=" + startedInstances
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UsageSummary", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._UsageSummary {
    Integer memoryInMb;
    Integer startedInstances;
    @JsonProperty("memory_in_mb")
    public void setMemoryInMb(Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
    }
    @JsonProperty("started_instances")
    public void setStartedInstances(Integer startedInstances) {
      this.startedInstances = startedInstances;
    }
    @Override
    public Integer getMemoryInMb() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getStartedInstances() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UsageSummary fromJson(Json json) {
    UsageSummary.Builder builder = UsageSummary.builder();
    if (json.memoryInMb != null) {
      builder.memoryInMb(json.memoryInMb);
    }
    if (json.startedInstances != null) {
      builder.startedInstances(json.startedInstances);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UsageSummary UsageSummary}.
   * <pre>
   * UsageSummary.builder()
   *    .memoryInMb(Integer) // required {@link UsageSummary#getMemoryInMb() memoryInMb}
   *    .startedInstances(Integer) // required {@link UsageSummary#getStartedInstances() startedInstances}
   *    .build();
   * </pre>
   * @return A new UsageSummary builder
   */
  public static UsageSummary.Builder builder() {
    return new UsageSummary.Builder();
  }

  /**
   * Builds instances of type {@link UsageSummary UsageSummary}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UsageSummary", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MEMORY_IN_MB = 0x1L;
    private static final long INIT_BIT_STARTED_INSTANCES = 0x2L;
    private long initBits = 0x3L;

    private Integer memoryInMb;
    private Integer startedInstances;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UsageSummary} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UsageSummary instance) {
      return from((_UsageSummary) instance);
    }

    /**
     * Copy abstract value type {@code _UsageSummary} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UsageSummary instance) {
      Objects.requireNonNull(instance, "instance");
      memoryInMb(instance.getMemoryInMb());
      startedInstances(instance.getStartedInstances());
      return this;
    }

    /**
     * Initializes the value for the {@link UsageSummary#getMemoryInMb() memoryInMb} attribute.
     * @param memoryInMb The value for memoryInMb 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("memory_in_mb")
    public final Builder memoryInMb(Integer memoryInMb) {
      this.memoryInMb = Objects.requireNonNull(memoryInMb, "memoryInMb");
      initBits &= ~INIT_BIT_MEMORY_IN_MB;
      return this;
    }

    /**
     * Initializes the value for the {@link UsageSummary#getStartedInstances() startedInstances} attribute.
     * @param startedInstances The value for startedInstances 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("started_instances")
    public final Builder startedInstances(Integer startedInstances) {
      this.startedInstances = Objects.requireNonNull(startedInstances, "startedInstances");
      initBits &= ~INIT_BIT_STARTED_INSTANCES;
      return this;
    }

    /**
     * Builds a new {@link UsageSummary UsageSummary}.
     * @return An immutable instance of UsageSummary
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UsageSummary build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UsageSummary(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MEMORY_IN_MB) != 0) attributes.add("memoryInMb");
      if ((initBits & INIT_BIT_STARTED_INSTANCES) != 0) attributes.add("startedInstances");
      return "Cannot build UsageSummary, some of required attributes are not set " + attributes;
    }
  }
}
