package org.cloudfoundry.client.v3.buildpacks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete Buildpack operation.
 */
@Generated(from = "_DeleteBuildpackRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteBuildpackRequest
    extends org.cloudfoundry.client.v3.buildpacks._DeleteBuildpackRequest {
  private final String buildpackId;

  private DeleteBuildpackRequest(DeleteBuildpackRequest.Builder builder) {
    this.buildpackId = builder.buildpackId;
  }

  /**
   * The buildpack id
   */
  @Override
  public String getBuildpackId() {
    return buildpackId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteBuildpackRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteBuildpackRequest
        && equalTo((DeleteBuildpackRequest) another);
  }

  private boolean equalTo(DeleteBuildpackRequest another) {
    return buildpackId.equals(another.buildpackId);
  }

  /**
   * Computes a hash code from attributes: {@code buildpackId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + buildpackId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteBuildpackRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteBuildpackRequest{"
        + "buildpackId=" + buildpackId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteBuildpackRequest DeleteBuildpackRequest}.
   * <pre>
   * DeleteBuildpackRequest.builder()
   *    .buildpackId(String) // required {@link DeleteBuildpackRequest#getBuildpackId() buildpackId}
   *    .build();
   * </pre>
   * @return A new DeleteBuildpackRequest builder
   */
  public static DeleteBuildpackRequest.Builder builder() {
    return new DeleteBuildpackRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteBuildpackRequest DeleteBuildpackRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteBuildpackRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_BUILDPACK_ID = 0x1L;
    private long initBits = 0x1L;

    private String buildpackId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteBuildpackRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteBuildpackRequest instance) {
      return from((_DeleteBuildpackRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteBuildpackRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteBuildpackRequest instance) {
      Objects.requireNonNull(instance, "instance");
      buildpackId(instance.getBuildpackId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteBuildpackRequest#getBuildpackId() buildpackId} attribute.
     * @param buildpackId The value for buildpackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpackId(String buildpackId) {
      this.buildpackId = Objects.requireNonNull(buildpackId, "buildpackId");
      initBits &= ~INIT_BIT_BUILDPACK_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteBuildpackRequest DeleteBuildpackRequest}.
     * @return An immutable instance of DeleteBuildpackRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteBuildpackRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteBuildpackRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BUILDPACK_ID) != 0) attributes.add("buildpackId");
      return "Cannot build DeleteBuildpackRequest, some of required attributes are not set " + attributes;
    }
  }
}
