package org.cloudfoundry.client.v3.domains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The response payload for the Check Reserved Routes operation
 */
@Generated(from = "_CheckReservedRoutesResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CheckReservedRoutesResponse
    extends org.cloudfoundry.client.v3.domains._CheckReservedRoutesResponse {
  private final Boolean matchingRoute;

  private CheckReservedRoutesResponse(CheckReservedRoutesResponse.Builder builder) {
    this.matchingRoute = builder.matchingRoute;
  }

  /**
   * The matching route
   */
  @JsonProperty("matching_route")
  @Override
  public Boolean getMatchingRoute() {
    return matchingRoute;
  }

  /**
   * This instance is equal to all instances of {@code CheckReservedRoutesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CheckReservedRoutesResponse
        && equalTo((CheckReservedRoutesResponse) another);
  }

  private boolean equalTo(CheckReservedRoutesResponse another) {
    return matchingRoute.equals(another.matchingRoute);
  }

  /**
   * Computes a hash code from attributes: {@code matchingRoute}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + matchingRoute.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CheckReservedRoutesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CheckReservedRoutesResponse{"
        + "matchingRoute=" + matchingRoute
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CheckReservedRoutesResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.domains._CheckReservedRoutesResponse {
    Boolean matchingRoute;
    @JsonProperty("matching_route")
    public void setMatchingRoute(Boolean matchingRoute) {
      this.matchingRoute = matchingRoute;
    }
    @Override
    public Boolean getMatchingRoute() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CheckReservedRoutesResponse fromJson(Json json) {
    CheckReservedRoutesResponse.Builder builder = CheckReservedRoutesResponse.builder();
    if (json.matchingRoute != null) {
      builder.matchingRoute(json.matchingRoute);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CheckReservedRoutesResponse CheckReservedRoutesResponse}.
   * <pre>
   * CheckReservedRoutesResponse.builder()
   *    .matchingRoute(Boolean) // required {@link CheckReservedRoutesResponse#getMatchingRoute() matchingRoute}
   *    .build();
   * </pre>
   * @return A new CheckReservedRoutesResponse builder
   */
  public static CheckReservedRoutesResponse.Builder builder() {
    return new CheckReservedRoutesResponse.Builder();
  }

  /**
   * Builds instances of type {@link CheckReservedRoutesResponse CheckReservedRoutesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CheckReservedRoutesResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MATCHING_ROUTE = 0x1L;
    private long initBits = 0x1L;

    private Boolean matchingRoute;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckReservedRoutesResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CheckReservedRoutesResponse instance) {
      return from((_CheckReservedRoutesResponse) instance);
    }

    /**
     * Copy abstract value type {@code _CheckReservedRoutesResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CheckReservedRoutesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      matchingRoute(instance.getMatchingRoute());
      return this;
    }

    /**
     * Initializes the value for the {@link CheckReservedRoutesResponse#getMatchingRoute() matchingRoute} attribute.
     * @param matchingRoute The value for matchingRoute 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("matching_route")
    public final Builder matchingRoute(Boolean matchingRoute) {
      this.matchingRoute = Objects.requireNonNull(matchingRoute, "matchingRoute");
      initBits &= ~INIT_BIT_MATCHING_ROUTE;
      return this;
    }

    /**
     * Builds a new {@link CheckReservedRoutesResponse CheckReservedRoutesResponse}.
     * @return An immutable instance of CheckReservedRoutesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CheckReservedRoutesResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CheckReservedRoutesResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MATCHING_ROUTE) != 0) attributes.add("matchingRoute");
      return "Cannot build CheckReservedRoutesResponse, some of required attributes are not set " + attributes;
    }
  }
}
