package org.cloudfoundry.client.v3.domains;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Delete a Particular Domain operation
 */
@Generated(from = "_DeleteDomainRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DeleteDomainRequest extends org.cloudfoundry.client.v3.domains._DeleteDomainRequest {
  private final String domainId;

  private DeleteDomainRequest(DeleteDomainRequest.Builder builder) {
    this.domainId = builder.domainId;
  }

  /**
   * The domain id
   */
  @Override
  public String getDomainId() {
    return domainId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteDomainRequest
        && equalTo((DeleteDomainRequest) another);
  }

  private boolean equalTo(DeleteDomainRequest another) {
    return domainId.equals(another.domainId);
  }

  /**
   * Computes a hash code from attributes: {@code domainId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domainId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteDomainRequest{"
        + "domainId=" + domainId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteDomainRequest DeleteDomainRequest}.
   * <pre>
   * DeleteDomainRequest.builder()
   *    .domainId(String) // required {@link DeleteDomainRequest#getDomainId() domainId}
   *    .build();
   * </pre>
   * @return A new DeleteDomainRequest builder
   */
  public static DeleteDomainRequest.Builder builder() {
    return new DeleteDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteDomainRequest DeleteDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DeleteDomainRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN_ID = 0x1L;
    private long initBits = 0x1L;

    private String domainId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteDomainRequest instance) {
      return from((_DeleteDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      domainId(instance.getDomainId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteDomainRequest#getDomainId() domainId} attribute.
     * @param domainId The value for domainId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String domainId) {
      this.domainId = Objects.requireNonNull(domainId, "domainId");
      initBits &= ~INIT_BIT_DOMAIN_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteDomainRequest DeleteDomainRequest}.
     * @return An immutable instance of DeleteDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN_ID) != 0) attributes.add("domainId");
      return "Cannot build DeleteDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
