package org.cloudfoundry.client.v3.domains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.ToManyRelationship;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _DomainRelationships}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DomainRelationships.builder()}.
 */
@Generated(from = "_DomainRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DomainRelationships extends org.cloudfoundry.client.v3.domains._DomainRelationships {
  private final ToOneRelationship organization;
  private final @Nullable ToManyRelationship sharedOrganizations;

  private DomainRelationships(DomainRelationships.Builder builder) {
    this.organization = builder.organization;
    this.sharedOrganizations = builder.sharedOrganizations;
  }

  /**
   * The organization the domain is scoped to. If set, the domain will only be available in that organization.
   * Otherwise, the domain will be globally available.
   */
  @JsonProperty("organization")
  @Override
  public ToOneRelationship getOrganization() {
    return organization;
  }

  /**
   * Organizations the domain is shared with. If set, the domain will be available in these organizations in addition
   * to the organization the domain is scoped to.
   */
  @JsonProperty("shared_organizations")
  @Override
  public @Nullable ToManyRelationship getSharedOrganizations() {
    return sharedOrganizations;
  }

  /**
   * This instance is equal to all instances of {@code DomainRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DomainRelationships
        && equalTo((DomainRelationships) another);
  }

  private boolean equalTo(DomainRelationships another) {
    return organization.equals(another.organization)
        && Objects.equals(sharedOrganizations, another.sharedOrganizations);
  }

  /**
   * Computes a hash code from attributes: {@code organization}, {@code sharedOrganizations}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organization.hashCode();
    h += (h << 5) + Objects.hashCode(sharedOrganizations);
    return h;
  }

  /**
   * Prints the immutable value {@code DomainRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DomainRelationships{"
        + "organization=" + organization
        + ", sharedOrganizations=" + sharedOrganizations
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_DomainRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.domains._DomainRelationships {
    ToOneRelationship organization;
    ToManyRelationship sharedOrganizations;
    @JsonProperty("organization")
    public void setOrganization(ToOneRelationship organization) {
      this.organization = organization;
    }
    @JsonProperty("shared_organizations")
    public void setSharedOrganizations(@Nullable ToManyRelationship sharedOrganizations) {
      this.sharedOrganizations = sharedOrganizations;
    }
    @Override
    public ToOneRelationship getOrganization() { throw new UnsupportedOperationException(); }
    @Override
    public ToManyRelationship getSharedOrganizations() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static DomainRelationships fromJson(Json json) {
    DomainRelationships.Builder builder = DomainRelationships.builder();
    if (json.organization != null) {
      builder.organization(json.organization);
    }
    if (json.sharedOrganizations != null) {
      builder.sharedOrganizations(json.sharedOrganizations);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link DomainRelationships DomainRelationships}.
   * <pre>
   * DomainRelationships.builder()
   *    .organization(org.cloudfoundry.client.v3.ToOneRelationship) // required {@link DomainRelationships#getOrganization() organization}
   *    .sharedOrganizations(org.cloudfoundry.client.v3.ToManyRelationship | null) // nullable {@link DomainRelationships#getSharedOrganizations() sharedOrganizations}
   *    .build();
   * </pre>
   * @return A new DomainRelationships builder
   */
  public static DomainRelationships.Builder builder() {
    return new DomainRelationships.Builder();
  }

  /**
   * Builds instances of type {@link DomainRelationships DomainRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DomainRelationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION = 0x1L;
    private long initBits = 0x1L;

    private ToOneRelationship organization;
    private ToManyRelationship sharedOrganizations;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DomainRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DomainRelationships instance) {
      return from((_DomainRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _DomainRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DomainRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      organization(instance.getOrganization());
      ToManyRelationship sharedOrganizationsValue = instance.getSharedOrganizations();
      if (sharedOrganizationsValue != null) {
        sharedOrganizations(sharedOrganizationsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DomainRelationships#getOrganization() organization} attribute.
     * @param organization The value for organization 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("organization")
    public final Builder organization(ToOneRelationship organization) {
      this.organization = Objects.requireNonNull(organization, "organization");
      initBits &= ~INIT_BIT_ORGANIZATION;
      return this;
    }

    /**
     * Initializes the value for the {@link DomainRelationships#getSharedOrganizations() sharedOrganizations} attribute.
     * @param sharedOrganizations The value for sharedOrganizations (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("shared_organizations")
    public final Builder sharedOrganizations(@Nullable ToManyRelationship sharedOrganizations) {
      this.sharedOrganizations = sharedOrganizations;
      return this;
    }

    /**
     * Builds a new {@link DomainRelationships DomainRelationships}.
     * @return An immutable instance of DomainRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DomainRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DomainRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION) != 0) attributes.add("organization");
      return "Cannot build DomainRelationships, some of required attributes are not set " + attributes;
    }
  }
}
