package org.cloudfoundry.client.v3.domains;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Get Domain operation
 */
@Generated(from = "_GetDomainRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetDomainRequest extends org.cloudfoundry.client.v3.domains._GetDomainRequest {
  private final String domainId;

  private GetDomainRequest(GetDomainRequest.Builder builder) {
    this.domainId = builder.domainId;
  }

  /**
   * The domain id
   */
  @JsonProperty("domainId")
  @Override
  public String getDomainId() {
    return domainId;
  }

  /**
   * This instance is equal to all instances of {@code GetDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetDomainRequest
        && equalTo((GetDomainRequest) another);
  }

  private boolean equalTo(GetDomainRequest another) {
    return domainId.equals(another.domainId);
  }

  /**
   * Computes a hash code from attributes: {@code domainId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domainId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetDomainRequest{"
        + "domainId=" + domainId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetDomainRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.domains._GetDomainRequest {
    String domainId;
    @JsonProperty("domainId")
    public void setDomainId(String domainId) {
      this.domainId = domainId;
    }
    @Override
    public String getDomainId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetDomainRequest fromJson(Json json) {
    GetDomainRequest.Builder builder = GetDomainRequest.builder();
    if (json.domainId != null) {
      builder.domainId(json.domainId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetDomainRequest GetDomainRequest}.
   * <pre>
   * GetDomainRequest.builder()
   *    .domainId(String) // required {@link GetDomainRequest#getDomainId() domainId}
   *    .build();
   * </pre>
   * @return A new GetDomainRequest builder
   */
  public static GetDomainRequest.Builder builder() {
    return new GetDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetDomainRequest GetDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetDomainRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN_ID = 0x1L;
    private long initBits = 0x1L;

    private String domainId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetDomainRequest instance) {
      return from((_GetDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      domainId(instance.getDomainId());
      return this;
    }

    /**
     * Initializes the value for the {@link GetDomainRequest#getDomainId() domainId} attribute.
     * @param domainId The value for domainId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String domainId) {
      this.domainId = Objects.requireNonNull(domainId, "domainId");
      initBits &= ~INIT_BIT_DOMAIN_ID;
      return this;
    }

    /**
     * Builds a new {@link GetDomainRequest GetDomainRequest}.
     * @return An immutable instance of GetDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN_ID) != 0) attributes.add("domainId");
      return "Cannot build GetDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
