package org.cloudfoundry.client.v3.isolationsegments;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Relationship;
import org.immutables.value.Generated;

/**
 * The response payload for the List Spaces Relationship operation
 */
@Generated(from = "_ListIsolationSegmentSpacesRelationshipResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListIsolationSegmentSpacesRelationshipResponse
    extends org.cloudfoundry.client.v3.isolationsegments._ListIsolationSegmentSpacesRelationshipResponse {
  private final @Nullable List<Relationship> data;
  private final @Nullable Map<String, Link> links;

  private ListIsolationSegmentSpacesRelationshipResponse(ListIsolationSegmentSpacesRelationshipResponse.Builder builder) {
    this.data = builder.data == null ? null : createUnmodifiableList(true, builder.data);
    this.links = builder.links == null ? null : createUnmodifiableMap(false, false, builder.links);
  }

  /**
   * The assigned spaces
   */
  @JsonProperty("data")
  @Override
  public @Nullable List<Relationship> getData() {
    return data;
  }

  /**
   * The links
   */
  @JsonProperty("links")
  @Override
  public @Nullable Map<String, Link> getLinks() {
    return links;
  }

  /**
   * This instance is equal to all instances of {@code ListIsolationSegmentSpacesRelationshipResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListIsolationSegmentSpacesRelationshipResponse
        && equalTo((ListIsolationSegmentSpacesRelationshipResponse) another);
  }

  private boolean equalTo(ListIsolationSegmentSpacesRelationshipResponse another) {
    return Objects.equals(data, another.data)
        && Objects.equals(links, another.links);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code links}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + Objects.hashCode(links);
    return h;
  }

  /**
   * Prints the immutable value {@code ListIsolationSegmentSpacesRelationshipResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListIsolationSegmentSpacesRelationshipResponse{"
        + "data=" + data
        + ", links=" + links
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ListIsolationSegmentSpacesRelationshipResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v3.isolationsegments._ListIsolationSegmentSpacesRelationshipResponse {
    List<Relationship> data = null;
    Map<String, Link> links = null;
    @JsonProperty("data")
    public void setData(@Nullable List<Relationship> data) {
      this.data = data;
    }
    @JsonProperty("links")
    public void setLinks(@Nullable Map<String, Link> links) {
      this.links = links;
    }
    @Override
    public List<Relationship> getData() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListIsolationSegmentSpacesRelationshipResponse fromJson(Json json) {
    ListIsolationSegmentSpacesRelationshipResponse.Builder builder = ListIsolationSegmentSpacesRelationshipResponse.builder();
    if (json.data != null) {
      builder.addAllData(json.data);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListIsolationSegmentSpacesRelationshipResponse ListIsolationSegmentSpacesRelationshipResponse}.
   * <pre>
   * ListIsolationSegmentSpacesRelationshipResponse.builder()
   *    .data(List&amp;lt;org.cloudfoundry.client.v3.Relationship&amp;gt; | null) // nullable {@link ListIsolationSegmentSpacesRelationshipResponse#getData() data}
   *    .links(Map&amp;lt;String, org.cloudfoundry.client.v3.Link&amp;gt; | null) // nullable {@link ListIsolationSegmentSpacesRelationshipResponse#getLinks() links}
   *    .build();
   * </pre>
   * @return A new ListIsolationSegmentSpacesRelationshipResponse builder
   */
  public static ListIsolationSegmentSpacesRelationshipResponse.Builder builder() {
    return new ListIsolationSegmentSpacesRelationshipResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListIsolationSegmentSpacesRelationshipResponse ListIsolationSegmentSpacesRelationshipResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListIsolationSegmentSpacesRelationshipResponse", generator = "Immutables")
  public static final class Builder {
    private List<Relationship> data = null;
    private Map<String, Link> links = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListIsolationSegmentSpacesRelationshipResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListIsolationSegmentSpacesRelationshipResponse instance) {
      return from((_ListIsolationSegmentSpacesRelationshipResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListIsolationSegmentSpacesRelationshipResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListIsolationSegmentSpacesRelationshipResponse instance) {
      Objects.requireNonNull(instance, "instance");
      List<Relationship> dataValue = instance.getData();
      if (dataValue != null) {
        addAllData(dataValue);
      }
      Map<String, Link> linksValue = instance.getLinks();
      if (linksValue != null) {
        putAllLinks(linksValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link ListIsolationSegmentSpacesRelationshipResponse#getData() data} list.
     * @param element A data element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Relationship element) {
      if (this.data == null) {
        this.data = new ArrayList<Relationship>();
      }
      this.data.add(Objects.requireNonNull(element, "data element"));
      return this;
    }

    /**
     * Adds elements to {@link ListIsolationSegmentSpacesRelationshipResponse#getData() data} list.
     * @param elements An array of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Relationship... elements) {
      if (this.data == null) {
        this.data = new ArrayList<Relationship>();
      }
      for (Relationship element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListIsolationSegmentSpacesRelationshipResponse#getData() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(@Nullable Iterable<? extends Relationship> elements) {
      if (elements == null) {
        this.data = null;
        return this;
      }
      this.data = new ArrayList<Relationship>();
      return addAllData(elements);
    }

    /**
     * Adds elements to {@link ListIsolationSegmentSpacesRelationshipResponse#getData() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllData(Iterable<? extends Relationship> elements) {
      Objects.requireNonNull(elements, "data element");
      if (this.data == null) {
        this.data = new ArrayList<Relationship>();
      }
      for (Relationship element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link ListIsolationSegmentSpacesRelationshipResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ListIsolationSegmentSpacesRelationshipResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ListIsolationSegmentSpacesRelationshipResponse#getLinks() links} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(@Nullable Map<String, ? extends Link> entries) {
      if (entries == null) {
        this.links = null;
        return this;
      }
      this.links = new LinkedHashMap<String, Link>();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ListIsolationSegmentSpacesRelationshipResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link ListIsolationSegmentSpacesRelationshipResponse ListIsolationSegmentSpacesRelationshipResponse}.
     * @return An immutable instance of ListIsolationSegmentSpacesRelationshipResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListIsolationSegmentSpacesRelationshipResponse build() {
      return new ListIsolationSegmentSpacesRelationshipResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
