package org.cloudfoundry.client.v3.isolationsegments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Isolation Segments operation.
 */
@Generated(from = "_ListIsolationSegmentsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListIsolationSegmentsRequest
    extends org.cloudfoundry.client.v3.isolationsegments._ListIsolationSegmentsRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final List<String> isolationSegmentIds;
  private final List<String> names;
  private final List<String> organizationIds;

  private ListIsolationSegmentsRequest(ListIsolationSegmentsRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.isolationSegmentIds = createUnmodifiableList(true, builder.isolationSegmentIds);
    this.names = createUnmodifiableList(true, builder.names);
    this.organizationIds = createUnmodifiableList(true, builder.organizationIds);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The ids
   */
  @Override
  public List<String> getIsolationSegmentIds() {
    return isolationSegmentIds;
  }

  /**
   * The names
   */
  @Override
  public List<String> getNames() {
    return names;
  }

  /**
   * The organization ids
   */
  @Override
  public List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * This instance is equal to all instances of {@code ListIsolationSegmentsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListIsolationSegmentsRequest
        && equalTo((ListIsolationSegmentsRequest) another);
  }

  private boolean equalTo(ListIsolationSegmentsRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && isolationSegmentIds.equals(another.isolationSegmentIds)
        && names.equals(another.names)
        && organizationIds.equals(another.organizationIds);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code isolationSegmentIds}, {@code names}, {@code organizationIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + isolationSegmentIds.hashCode();
    h += (h << 5) + names.hashCode();
    h += (h << 5) + organizationIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListIsolationSegmentsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListIsolationSegmentsRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", isolationSegmentIds=" + isolationSegmentIds
        + ", names=" + names
        + ", organizationIds=" + organizationIds
        + "}";
  }

  /**
   * Creates a builder for {@link ListIsolationSegmentsRequest ListIsolationSegmentsRequest}.
   * <pre>
   * ListIsolationSegmentsRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListIsolationSegmentsRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListIsolationSegmentsRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListIsolationSegmentsRequest#getPerPage() perPage}
   *    .isolationSegmentId|addAllIsolationSegmentIds(String) // {@link ListIsolationSegmentsRequest#getIsolationSegmentIds() isolationSegmentIds} elements
   *    .name|addAllNames(String) // {@link ListIsolationSegmentsRequest#getNames() names} elements
   *    .organizationId|addAllOrganizationIds(String) // {@link ListIsolationSegmentsRequest#getOrganizationIds() organizationIds} elements
   *    .build();
   * </pre>
   * @return A new ListIsolationSegmentsRequest builder
   */
  public static ListIsolationSegmentsRequest.Builder builder() {
    return new ListIsolationSegmentsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListIsolationSegmentsRequest ListIsolationSegmentsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListIsolationSegmentsRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private List<String> isolationSegmentIds = new ArrayList<String>();
    private List<String> names = new ArrayList<String>();
    private List<String> organizationIds = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListIsolationSegmentsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListIsolationSegmentsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListIsolationSegmentsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListIsolationSegmentsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v3.isolationsegments._ListIsolationSegmentsRequest) {
        org.cloudfoundry.client.v3.isolationsegments._ListIsolationSegmentsRequest instance = (org.cloudfoundry.client.v3.isolationsegments._ListIsolationSegmentsRequest) object;
        addAllOrganizationIds(instance.getOrganizationIds());
        addAllNames(instance.getNames());
        addAllIsolationSegmentIds(instance.getIsolationSegmentIds());
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListIsolationSegmentsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListIsolationSegmentsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListIsolationSegmentsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Adds one element to {@link ListIsolationSegmentsRequest#getIsolationSegmentIds() isolationSegmentIds} list.
     * @param element A isolationSegmentIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isolationSegmentId(String element) {
      this.isolationSegmentIds.add(Objects.requireNonNull(element, "isolationSegmentIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListIsolationSegmentsRequest#getIsolationSegmentIds() isolationSegmentIds} list.
     * @param elements An array of isolationSegmentIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isolationSegmentIds(String... elements) {
      for (String element : elements) {
        this.isolationSegmentIds.add(Objects.requireNonNull(element, "isolationSegmentIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListIsolationSegmentsRequest#getIsolationSegmentIds() isolationSegmentIds} list.
     * @param elements An iterable of isolationSegmentIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isolationSegmentIds(Iterable<String> elements) {
      this.isolationSegmentIds.clear();
      return addAllIsolationSegmentIds(elements);
    }

    /**
     * Adds elements to {@link ListIsolationSegmentsRequest#getIsolationSegmentIds() isolationSegmentIds} list.
     * @param elements An iterable of isolationSegmentIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIsolationSegmentIds(Iterable<String> elements) {
      for (String element : elements) {
        this.isolationSegmentIds.add(Objects.requireNonNull(element, "isolationSegmentIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListIsolationSegmentsRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListIsolationSegmentsRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListIsolationSegmentsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(Iterable<String> elements) {
      this.names.clear();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListIsolationSegmentsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListIsolationSegmentsRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListIsolationSegmentsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListIsolationSegmentsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(Iterable<String> elements) {
      this.organizationIds.clear();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListIsolationSegmentsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListIsolationSegmentsRequest ListIsolationSegmentsRequest}.
     * @return An immutable instance of ListIsolationSegmentsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListIsolationSegmentsRequest build() {
      return new ListIsolationSegmentsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
