package org.cloudfoundry.client.v3.organizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Organization Domains operation
 */
@Generated(from = "_ListOrganizationDomainsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListOrganizationDomainsRequest
    extends org.cloudfoundry.client.v3.organizations._ListOrganizationDomainsRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final @Nullable List<String> domainIds;
  private final @Nullable String labelSelector;
  private final @Nullable List<String> names;
  private final String organizationId;
  private final @Nullable List<String> owningOrganizationIds;

  private ListOrganizationDomainsRequest(ListOrganizationDomainsRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.domainIds = builder.domainIds == null ? null : createUnmodifiableList(true, builder.domainIds);
    this.labelSelector = builder.labelSelector;
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
    this.organizationId = builder.organizationId;
    this.owningOrganizationIds = builder.owningOrganizationIds == null ? null : createUnmodifiableList(true, builder.owningOrganizationIds);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The domain ids to filter by
   */
  @Override
  public @Nullable List<String> getDomainIds() {
    return domainIds;
  }

  /**
   * The metadata query
   */
  @Override
  public @Nullable String getLabelSelector() {
    return labelSelector;
  }

  /**
   * The names
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The owning organization ids
   */
  @Override
  public @Nullable List<String> getOwningOrganizationIds() {
    return owningOrganizationIds;
  }

  /**
   * This instance is equal to all instances of {@code ListOrganizationDomainsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListOrganizationDomainsRequest
        && equalTo((ListOrganizationDomainsRequest) another);
  }

  private boolean equalTo(ListOrganizationDomainsRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && Objects.equals(domainIds, another.domainIds)
        && Objects.equals(labelSelector, another.labelSelector)
        && Objects.equals(names, another.names)
        && organizationId.equals(another.organizationId)
        && Objects.equals(owningOrganizationIds, another.owningOrganizationIds);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code domainIds}, {@code labelSelector}, {@code names}, {@code organizationId}, {@code owningOrganizationIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + Objects.hashCode(domainIds);
    h += (h << 5) + Objects.hashCode(labelSelector);
    h += (h << 5) + Objects.hashCode(names);
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + Objects.hashCode(owningOrganizationIds);
    return h;
  }

  /**
   * Prints the immutable value {@code ListOrganizationDomainsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListOrganizationDomainsRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", domainIds=" + domainIds
        + ", labelSelector=" + labelSelector
        + ", names=" + names
        + ", organizationId=" + organizationId
        + ", owningOrganizationIds=" + owningOrganizationIds
        + "}";
  }

  /**
   * Creates a builder for {@link ListOrganizationDomainsRequest ListOrganizationDomainsRequest}.
   * <pre>
   * ListOrganizationDomainsRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListOrganizationDomainsRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListOrganizationDomainsRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListOrganizationDomainsRequest#getPerPage() perPage}
   *    .domainIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListOrganizationDomainsRequest#getDomainIds() domainIds}
   *    .labelSelector(String | null) // nullable {@link ListOrganizationDomainsRequest#getLabelSelector() labelSelector}
   *    .names(List&amp;lt;String&amp;gt; | null) // nullable {@link ListOrganizationDomainsRequest#getNames() names}
   *    .organizationId(String) // required {@link ListOrganizationDomainsRequest#getOrganizationId() organizationId}
   *    .owningOrganizationIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListOrganizationDomainsRequest#getOwningOrganizationIds() owningOrganizationIds}
   *    .build();
   * </pre>
   * @return A new ListOrganizationDomainsRequest builder
   */
  public static ListOrganizationDomainsRequest.Builder builder() {
    return new ListOrganizationDomainsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListOrganizationDomainsRequest ListOrganizationDomainsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListOrganizationDomainsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String orderBy;
    private Integer page;
    private Integer perPage;
    private List<String> domainIds = null;
    private String labelSelector;
    private List<String> names = null;
    private String organizationId;
    private List<String> owningOrganizationIds = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListOrganizationDomainsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListOrganizationDomainsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListOrganizationDomainsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListOrganizationDomainsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v3.organizations._ListOrganizationDomainsRequest) {
        org.cloudfoundry.client.v3.organizations._ListOrganizationDomainsRequest instance = (org.cloudfoundry.client.v3.organizations._ListOrganizationDomainsRequest) object;
        organizationId(instance.getOrganizationId());
        List<String> owningOrganizationIdsValue = instance.getOwningOrganizationIds();
        if (owningOrganizationIdsValue != null) {
          addAllOwningOrganizationIds(owningOrganizationIdsValue);
        }
        String labelSelectorValue = instance.getLabelSelector();
        if (labelSelectorValue != null) {
          labelSelector(labelSelectorValue);
        }
        List<String> domainIdsValue = instance.getDomainIds();
        if (domainIdsValue != null) {
          addAllDomainIds(domainIdsValue);
        }
        List<String> namesValue = instance.getNames();
        if (namesValue != null) {
          addAllNames(namesValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListOrganizationDomainsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListOrganizationDomainsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListOrganizationDomainsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Adds one element to {@link ListOrganizationDomainsRequest#getDomainIds() domainIds} list.
     * @param element A domainIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainId(String element) {
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListOrganizationDomainsRequest#getDomainIds() domainIds} list.
     * @param elements An array of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainIds(String... elements) {
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListOrganizationDomainsRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.domainIds = null;
        return this;
      }
      this.domainIds = new ArrayList<String>();
      return addAllDomainIds(elements);
    }

    /**
     * Adds elements to {@link ListOrganizationDomainsRequest#getDomainIds() domainIds} list.
     * @param elements An iterable of domainIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomainIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "domainIds element");
      if (this.domainIds == null) {
        this.domainIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListOrganizationDomainsRequest#getLabelSelector() labelSelector} attribute.
     * @param labelSelector The value for labelSelector (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labelSelector(@Nullable String labelSelector) {
      this.labelSelector = labelSelector;
      return this;
    }

    /**
     * Adds one element to {@link ListOrganizationDomainsRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListOrganizationDomainsRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListOrganizationDomainsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListOrganizationDomainsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListOrganizationDomainsRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Adds one element to {@link ListOrganizationDomainsRequest#getOwningOrganizationIds() owningOrganizationIds} list.
     * @param element A owningOrganizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder owningOrganizationId(String element) {
      if (this.owningOrganizationIds == null) {
        this.owningOrganizationIds = new ArrayList<String>();
      }
      this.owningOrganizationIds.add(Objects.requireNonNull(element, "owningOrganizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListOrganizationDomainsRequest#getOwningOrganizationIds() owningOrganizationIds} list.
     * @param elements An array of owningOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder owningOrganizationIds(String... elements) {
      if (this.owningOrganizationIds == null) {
        this.owningOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.owningOrganizationIds.add(Objects.requireNonNull(element, "owningOrganizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListOrganizationDomainsRequest#getOwningOrganizationIds() owningOrganizationIds} list.
     * @param elements An iterable of owningOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder owningOrganizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.owningOrganizationIds = null;
        return this;
      }
      this.owningOrganizationIds = new ArrayList<String>();
      return addAllOwningOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListOrganizationDomainsRequest#getOwningOrganizationIds() owningOrganizationIds} list.
     * @param elements An iterable of owningOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOwningOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "owningOrganizationIds element");
      if (this.owningOrganizationIds == null) {
        this.owningOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.owningOrganizationIds.add(Objects.requireNonNull(element, "owningOrganizationIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListOrganizationDomainsRequest ListOrganizationDomainsRequest}.
     * @return An immutable instance of ListOrganizationDomainsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListOrganizationDomainsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListOrganizationDomainsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build ListOrganizationDomainsRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
