package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Process usage information
 */
@Generated(from = "_ProcessUsage", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ProcessUsage extends org.cloudfoundry.client.v3.processes._ProcessUsage {
  private final Double cpu;
  private final Integer disk;
  private final Integer memory;
  private final String time;

  private ProcessUsage(ProcessUsage.Builder builder) {
    this.cpu = builder.cpu;
    this.disk = builder.disk;
    this.memory = builder.memory;
    this.time = builder.time;
  }

  /**
   * The CPU
   */
  @JsonProperty("cpu")
  @Override
  public Double getCpu() {
    return cpu;
  }

  /**
   * The disk
   */
  @JsonProperty("disk")
  @Override
  public Integer getDisk() {
    return disk;
  }

  /**
   * The memory
   */
  @JsonProperty("mem")
  @Override
  public Integer getMemory() {
    return memory;
  }

  /**
   * The time
   */
  @JsonProperty("time")
  @Override
  public String getTime() {
    return time;
  }

  /**
   * This instance is equal to all instances of {@code ProcessUsage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ProcessUsage
        && equalTo((ProcessUsage) another);
  }

  private boolean equalTo(ProcessUsage another) {
    return cpu.equals(another.cpu)
        && disk.equals(another.disk)
        && memory.equals(another.memory)
        && time.equals(another.time);
  }

  /**
   * Computes a hash code from attributes: {@code cpu}, {@code disk}, {@code memory}, {@code time}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + cpu.hashCode();
    h += (h << 5) + disk.hashCode();
    h += (h << 5) + memory.hashCode();
    h += (h << 5) + time.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessUsage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessUsage{"
        + "cpu=" + cpu
        + ", disk=" + disk
        + ", memory=" + memory
        + ", time=" + time
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ProcessUsage", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.processes._ProcessUsage {
    Double cpu;
    Integer disk;
    Integer memory;
    String time;
    @JsonProperty("cpu")
    public void setCpu(Double cpu) {
      this.cpu = cpu;
    }
    @JsonProperty("disk")
    public void setDisk(Integer disk) {
      this.disk = disk;
    }
    @JsonProperty("mem")
    public void setMemory(Integer memory) {
      this.memory = memory;
    }
    @JsonProperty("time")
    public void setTime(String time) {
      this.time = time;
    }
    @Override
    public Double getCpu() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getDisk() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemory() { throw new UnsupportedOperationException(); }
    @Override
    public String getTime() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ProcessUsage fromJson(Json json) {
    ProcessUsage.Builder builder = ProcessUsage.builder();
    if (json.cpu != null) {
      builder.cpu(json.cpu);
    }
    if (json.disk != null) {
      builder.disk(json.disk);
    }
    if (json.memory != null) {
      builder.memory(json.memory);
    }
    if (json.time != null) {
      builder.time(json.time);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ProcessUsage ProcessUsage}.
   * <pre>
   * ProcessUsage.builder()
   *    .cpu(Double) // required {@link ProcessUsage#getCpu() cpu}
   *    .disk(Integer) // required {@link ProcessUsage#getDisk() disk}
   *    .memory(Integer) // required {@link ProcessUsage#getMemory() memory}
   *    .time(String) // required {@link ProcessUsage#getTime() time}
   *    .build();
   * </pre>
   * @return A new ProcessUsage builder
   */
  public static ProcessUsage.Builder builder() {
    return new ProcessUsage.Builder();
  }

  /**
   * Builds instances of type {@link ProcessUsage ProcessUsage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ProcessUsage", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CPU = 0x1L;
    private static final long INIT_BIT_DISK = 0x2L;
    private static final long INIT_BIT_MEMORY = 0x4L;
    private static final long INIT_BIT_TIME = 0x8L;
    private long initBits = 0xfL;

    private Double cpu;
    private Integer disk;
    private Integer memory;
    private String time;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcessUsage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessUsage instance) {
      return from((_ProcessUsage) instance);
    }

    /**
     * Copy abstract value type {@code _ProcessUsage} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ProcessUsage instance) {
      Objects.requireNonNull(instance, "instance");
      cpu(instance.getCpu());
      disk(instance.getDisk());
      memory(instance.getMemory());
      time(instance.getTime());
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessUsage#getCpu() cpu} attribute.
     * @param cpu The value for cpu 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("cpu")
    public final Builder cpu(Double cpu) {
      this.cpu = Objects.requireNonNull(cpu, "cpu");
      initBits &= ~INIT_BIT_CPU;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessUsage#getDisk() disk} attribute.
     * @param disk The value for disk 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("disk")
    public final Builder disk(Integer disk) {
      this.disk = Objects.requireNonNull(disk, "disk");
      initBits &= ~INIT_BIT_DISK;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessUsage#getMemory() memory} attribute.
     * @param memory The value for memory 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("mem")
    public final Builder memory(Integer memory) {
      this.memory = Objects.requireNonNull(memory, "memory");
      initBits &= ~INIT_BIT_MEMORY;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessUsage#getTime() time} attribute.
     * @param time The value for time 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("time")
    public final Builder time(String time) {
      this.time = Objects.requireNonNull(time, "time");
      initBits &= ~INIT_BIT_TIME;
      return this;
    }

    /**
     * Builds a new {@link ProcessUsage ProcessUsage}.
     * @return An immutable instance of ProcessUsage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ProcessUsage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ProcessUsage(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CPU) != 0) attributes.add("cpu");
      if ((initBits & INIT_BIT_DISK) != 0) attributes.add("disk");
      if ((initBits & INIT_BIT_MEMORY) != 0) attributes.add("memory");
      if ((initBits & INIT_BIT_TIME) != 0) attributes.add("time");
      return "Cannot build ProcessUsage, some of required attributes are not set " + attributes;
    }
  }
}
