package org.cloudfoundry.client.v3.roles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Roles operation
 */
@Generated(from = "_ListRolesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListRolesRequest extends org.cloudfoundry.client.v3.roles._ListRolesRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final List<String> roleIds;
  private final List<String> organizationIds;
  private final List<String> spaceIds;
  private final List<RoleType> types;
  private final List<String> userIds;

  private ListRolesRequest(ListRolesRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.roleIds = createUnmodifiableList(true, builder.roleIds);
    this.organizationIds = createUnmodifiableList(true, builder.organizationIds);
    this.spaceIds = createUnmodifiableList(true, builder.spaceIds);
    this.types = createUnmodifiableList(true, builder.types);
    this.userIds = createUnmodifiableList(true, builder.userIds);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The role ids filter
   */
  @Override
  public List<String> getRoleIds() {
    return roleIds;
  }

  /**
   * The organization ids filter
   */
  @Override
  public List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The space ids filter
   */
  @Override
  public List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * The types filter
   */
  @Override
  public List<RoleType> getTypes() {
    return types;
  }

  /**
   * The user ids filter
   */
  @Override
  public List<String> getUserIds() {
    return userIds;
  }

  /**
   * This instance is equal to all instances of {@code ListRolesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListRolesRequest
        && equalTo((ListRolesRequest) another);
  }

  private boolean equalTo(ListRolesRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && roleIds.equals(another.roleIds)
        && organizationIds.equals(another.organizationIds)
        && spaceIds.equals(another.spaceIds)
        && types.equals(another.types)
        && userIds.equals(another.userIds);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code roleIds}, {@code organizationIds}, {@code spaceIds}, {@code types}, {@code userIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + roleIds.hashCode();
    h += (h << 5) + organizationIds.hashCode();
    h += (h << 5) + spaceIds.hashCode();
    h += (h << 5) + types.hashCode();
    h += (h << 5) + userIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListRolesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListRolesRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", roleIds=" + roleIds
        + ", organizationIds=" + organizationIds
        + ", spaceIds=" + spaceIds
        + ", types=" + types
        + ", userIds=" + userIds
        + "}";
  }

  /**
   * Creates a builder for {@link ListRolesRequest ListRolesRequest}.
   * <pre>
   * ListRolesRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListRolesRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListRolesRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListRolesRequest#getPerPage() perPage}
   *    .roleId|addAllRoleIds(String) // {@link ListRolesRequest#getRoleIds() roleIds} elements
   *    .organizationId|addAllOrganizationIds(String) // {@link ListRolesRequest#getOrganizationIds() organizationIds} elements
   *    .spaceId|addAllSpaceIds(String) // {@link ListRolesRequest#getSpaceIds() spaceIds} elements
   *    .type|addAllTypes(org.cloudfoundry.client.v3.roles.RoleType) // {@link ListRolesRequest#getTypes() types} elements
   *    .userId|addAllUserIds(String) // {@link ListRolesRequest#getUserIds() userIds} elements
   *    .build();
   * </pre>
   * @return A new ListRolesRequest builder
   */
  public static ListRolesRequest.Builder builder() {
    return new ListRolesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListRolesRequest ListRolesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListRolesRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private List<String> roleIds = new ArrayList<String>();
    private List<String> organizationIds = new ArrayList<String>();
    private List<String> spaceIds = new ArrayList<String>();
    private List<RoleType> types = new ArrayList<RoleType>();
    private List<String> userIds = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListRolesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListRolesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListRolesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListRolesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v3.roles._ListRolesRequest) {
        org.cloudfoundry.client.v3.roles._ListRolesRequest instance = (org.cloudfoundry.client.v3.roles._ListRolesRequest) object;
        addAllTypes(instance.getTypes());
        addAllRoleIds(instance.getRoleIds());
        addAllSpaceIds(instance.getSpaceIds());
        addAllOrganizationIds(instance.getOrganizationIds());
        addAllUserIds(instance.getUserIds());
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListRolesRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListRolesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListRolesRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Adds one element to {@link ListRolesRequest#getRoleIds() roleIds} list.
     * @param element A roleIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder roleId(String element) {
      this.roleIds.add(Objects.requireNonNull(element, "roleIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRolesRequest#getRoleIds() roleIds} list.
     * @param elements An array of roleIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder roleIds(String... elements) {
      for (String element : elements) {
        this.roleIds.add(Objects.requireNonNull(element, "roleIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRolesRequest#getRoleIds() roleIds} list.
     * @param elements An iterable of roleIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder roleIds(Iterable<String> elements) {
      this.roleIds.clear();
      return addAllRoleIds(elements);
    }

    /**
     * Adds elements to {@link ListRolesRequest#getRoleIds() roleIds} list.
     * @param elements An iterable of roleIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRoleIds(Iterable<String> elements) {
      for (String element : elements) {
        this.roleIds.add(Objects.requireNonNull(element, "roleIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListRolesRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRolesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRolesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(Iterable<String> elements) {
      this.organizationIds.clear();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListRolesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListRolesRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRolesRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRolesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(Iterable<String> elements) {
      this.spaceIds.clear();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListRolesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListRolesRequest#getTypes() types} list.
     * @param element A types element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(RoleType element) {
      this.types.add(Objects.requireNonNull(element, "types element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRolesRequest#getTypes() types} list.
     * @param elements An array of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(RoleType... elements) {
      for (RoleType element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRolesRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(Iterable<? extends RoleType> elements) {
      this.types.clear();
      return addAllTypes(elements);
    }

    /**
     * Adds elements to {@link ListRolesRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTypes(Iterable<? extends RoleType> elements) {
      for (RoleType element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListRolesRequest#getUserIds() userIds} list.
     * @param element A userIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String element) {
      this.userIds.add(Objects.requireNonNull(element, "userIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRolesRequest#getUserIds() userIds} list.
     * @param elements An array of userIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userIds(String... elements) {
      for (String element : elements) {
        this.userIds.add(Objects.requireNonNull(element, "userIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRolesRequest#getUserIds() userIds} list.
     * @param elements An iterable of userIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userIds(Iterable<String> elements) {
      this.userIds.clear();
      return addAllUserIds(elements);
    }

    /**
     * Adds elements to {@link ListRolesRequest#getUserIds() userIds} list.
     * @param elements An iterable of userIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllUserIds(Iterable<String> elements) {
      for (String element : elements) {
        this.userIds.add(Objects.requireNonNull(element, "userIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListRolesRequest ListRolesRequest}.
     * @return An immutable instance of ListRolesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListRolesRequest build() {
      return new ListRolesRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
